/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.cell;

import cofh.core.render.IconRegistry;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermalexpansion.block.cell.BlockCell;
import cofh.thermalexpansion.block.cell.TileCell;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileCellCreative
extends TileCell {
    public static final byte[] DEFAULT_SIDES = new byte[]{1, 1, 1, 1, 1, 1};

    public static void initialize() {
        GameRegistry.registerTileEntity(TileCellCreative.class, (String)"thermalexpansion.CellCreative");
    }

    public TileCellCreative() {
        this.energyStorage.setEnergyStored(-1);
    }

    public TileCellCreative(int n) {
        super(n);
        this.energyStorage.setEnergyStored(-1);
    }

    @Override
    public byte[] getDefaultSides() {
        return (byte[])DEFAULT_SIDES.clone();
    }

    @Override
    public void func_145845_h() {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            return;
        }
        if (!this.cached) {
            this.onNeighborBlockChange();
        }
        if (this.redstoneControlOrDisable()) {
            for (int i = 0; i < 6; ++i) {
                this.transferEnergy(i);
            }
        }
    }

    @Override
    protected void transferEnergy(int n) {
        if (this.sideCache[n] != 1) {
            return;
        }
        if (this.adjacentHandlers[n] == null) {
            return;
        }
        this.adjacentHandlers[n].receiveEnergy(ForgeDirection.VALID_DIRECTIONS[n ^ 1], this.energySend, false);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.energyStorage.setEnergyStored(this.energyStorage.getMaxEnergyStored());
    }

    @Override
    public int receiveEnergy(ForgeDirection forgeDirection, int n, boolean bl) {
        if (forgeDirection == ForgeDirection.UNKNOWN || this.sideCache[forgeDirection.ordinal()] == 2) {
            return Math.min(n, this.energyReceive);
        }
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection forgeDirection, int n, boolean bl) {
        if (forgeDirection == ForgeDirection.UNKNOWN || this.sideCache[forgeDirection.ordinal()] == 1) {
            return Math.min(n, this.energySend);
        }
        return 0;
    }

    @Override
    public IIcon getTexture(int n, int n2) {
        if (n2 == 0) {
            return IconRegistry.getIcon((String)"FluidRedstone");
        }
        if (n2 == 1) {
            return IconRegistry.getIcon((String)"Cell", (int)(this.type * 2));
        }
        if (n2 == 2) {
            return IconRegistry.getIcon((String)BlockCell.textureSelection, (int)this.sideCache[n]);
        }
        return n != this.facing ? IconRegistry.getIcon((String)BlockCell.textureSelection, (int)0) : IconRegistry.getIcon((String)"CellMeterCreative");
    }
}

