/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import jds.bibliocraft.BiblioCraft;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.ResourcePackRepository;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FilenameUtils;

public class PaintingUtil {
    public static int[] test;
    public static String[] customArtNames;
    public static int[] customArtHeights;
    public static int[] customArtWidths;
    public static ResourceLocation[] customArtResources;

    public static void updateCustomArtDatas() {
        customArtNames = PaintingUtil.getListOfPaintings();
        if (customArtNames != null) {
            customArtResources = PaintingUtil.getPaintingsResourceLocations(customArtNames);
            customArtHeights = PaintingUtil.getPaintingSetHeights(customArtNames, customArtResources);
            customArtWidths = PaintingUtil.getPaintingSetWidths(customArtNames, customArtResources);
        }
    }

    private static ResourceLocation[] getPaintingsResourceLocations(String[] names) {
        ResourceLocation[] paintings = new ResourceLocation[names.length];
        for (int i = 0; i < names.length; ++i) {
            paintings[i] = new ResourceLocation("bibliocraft", "textures/custompaintings/" + names[i]);
        }
        return paintings;
    }

    private static int[] getPaintingSetHeights(String[] paintings, ResourceLocation[] resources) {
        int[] heights = new int[paintings.length];
        IResourceManager rm = Minecraft.func_71410_x().func_110442_L();
        try {
            for (int i = 0; i < paintings.length; ++i) {
                BufferedImage img;
                IResource theThing = rm.func_110536_a(resources[i]);
                if (theThing == null || (img = ImageIO.read(theThing.func_110527_b())) == null) continue;
                heights[i] = ((Image)img).getHeight(null);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return heights;
    }

    private static int[] getPaintingSetWidths(String[] paintings, ResourceLocation[] resources) {
        int[] widths = new int[paintings.length];
        IResourceManager rm = Minecraft.func_71410_x().func_110442_L();
        try {
            for (int i = 0; i < paintings.length; ++i) {
                BufferedImage img;
                IResource theThing = rm.func_110536_a(resources[i]);
                if (theThing == null || (img = ImageIO.read(theThing.func_110527_b())) == null) continue;
                widths[i] = ((Image)img).getWidth(null);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return widths;
    }

    private static String[] getListOfPaintings() {
        String[] resources = PaintingUtil.getJarPaintings();
        String[] resourcePacks = PaintingUtil.getResourcePackPaintings();
        if (resources != null && resources.length > 0 && resourcePacks != null && resourcePacks.length > 0) {
            String[] masterList = new String[resources.length + resourcePacks.length];
            boolean indexAdjuster = false;
            for (int i = 0; i < masterList.length; ++i) {
                masterList[i] = i < resources.length ? resources[i] : resourcePacks[i - resources.length];
            }
            return masterList;
        }
        if ((resources == null || resources.length < 1) && resourcePacks != null && resourcePacks.length > 0) {
            return resourcePacks;
        }
        if (resources != null && resources.length > 0 && (resourcePacks == null || resourcePacks.length < 1)) {
            return resources;
        }
        return null;
    }

    private static String[] getJarPaintings() {
        String path = "assets/bibliocraft/textures/custompaintings/";
        URL dirURL = BiblioCraft.instance.getClass().getResource("/assets/bibliocraft/textures/custompaintings/");
        if (dirURL != null && dirURL.getProtocol().equals("file")) {
            try {
                String[] newSet = new File(dirURL.toURI()).list();
                boolean setSize = false;
                ArrayList<String> thePNGs = new ArrayList<String>();
                for (int i = 0; i < newSet.length; ++i) {
                    if (!newSet[i].contains(".png")) continue;
                    thePNGs.add(newSet[i]);
                }
                String[] finalSet = new String[thePNGs.size()];
                for (int i = 0; i < thePNGs.size(); ++i) {
                    finalSet[i] = (String)thePNGs.get(i);
                }
                return finalSet;
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        if (dirURL != null && dirURL.getProtocol().equals("jar")) {
            String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
            try {
                JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
                Enumeration<JarEntry> entries = jar.entries();
                HashSet<String> result = new HashSet<String>();
                while (entries.hasMoreElements()) {
                    String entry;
                    String name = entries.nextElement().getName();
                    if (!name.startsWith(path) || !(entry = name.substring(path.length())).contains(".png")) continue;
                    result.add(entry);
                }
                return result.toArray(new String[result.size()]);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static String[] getResourcePackPaintings() {
        ResourcePackRepository pack = Minecraft.func_71410_x().func_110438_M();
        File[] packFileList = pack.func_110612_e().listFiles();
        String[] currentlyUsedPacks = PaintingUtil.getCurrentResoucePackList(pack);
        if (packFileList != null && currentlyUsedPacks != null) {
            ArrayList<String> packPaintings = new ArrayList<String>();
            block0: for (int i = 0; i < currentlyUsedPacks.length; ++i) {
                for (int j = 0; j < packFileList.length; ++j) {
                    if (!packFileList[j].getAbsolutePath().contains(currentlyUsedPacks[i])) continue;
                    String[] paintingsInThisPack = PaintingUtil.getListFromResourcePack(packFileList[j]);
                    if (paintingsInThisPack == null || paintingsInThisPack.length <= 0) continue block0;
                    for (int k = 0; k < paintingsInThisPack.length; ++k) {
                        packPaintings.add(paintingsInThisPack[k]);
                    }
                    continue block0;
                }
            }
            if (!packPaintings.isEmpty() && packPaintings.size() > 0) {
                String[] fullPackPaintingList = new String[packPaintings.size()];
                for (int i = 0; i < packPaintings.size(); ++i) {
                    fullPackPaintingList[i] = (String)packPaintings.get(i);
                }
                return fullPackPaintingList;
            }
        }
        return null;
    }

    private static String[] getCurrentResoucePackList(ResourcePackRepository pack) {
        List lst = pack.func_110613_c();
        if (lst.size() > 0) {
            String[] currentPacks = new String[lst.size()];
            for (int i = 0; i < lst.size(); ++i) {
                ResourcePackRepository.Entry entry = (ResourcePackRepository.Entry)lst.get(i);
                IResourcePack packet = entry.func_110514_c();
                currentPacks[i] = packet.func_130077_b();
            }
            return currentPacks;
        }
        return null;
    }

    private static String[] getListFromResourcePack(File resourceZipFile) {
        try {
            String ext = FilenameUtils.getExtension((String)resourceZipFile.getName());
            if (ext.equals("zip")) {
                String path = "assets/bibliocraft/textures/custompaintings/";
                ZipFile zippy = new ZipFile(resourceZipFile);
                Enumeration<? extends ZipEntry> packEntries = zippy.entries();
                String fileName = "";
                HashSet<String> result = new HashSet<String>();
                while (packEntries.hasMoreElements()) {
                    String entry;
                    fileName = packEntries.nextElement().getName();
                    if (!fileName.startsWith(path) || !(entry = fileName.substring(path.length())).contains(".png")) continue;
                    result.add(entry);
                }
                zippy.close();
                if (!result.isEmpty() && result.size() > 0) {
                    return result.toArray(new String[result.size()]);
                }
            } else if (ext.equals("")) {
                String[] newSet;
                File paintingsLoc = new File(resourceZipFile, "assets/bibliocraft/textures/custompaintings/");
                String[] finalSet = new String[]{};
                if (paintingsLoc.exists() && (newSet = paintingsLoc.list()).length > 0) {
                    int i;
                    ArrayList<String> thePNGs = new ArrayList<String>();
                    for (i = 0; i < newSet.length; ++i) {
                        if (!newSet[i].contains(".png")) continue;
                        thePNGs.add(newSet[i]);
                    }
                    finalSet = new String[thePNGs.size()];
                    for (i = 0; i < thePNGs.size(); ++i) {
                        finalSet[i] = (String)thePNGs.get(i);
                    }
                }
                return finalSet;
            }
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    static {
        customArtNames = null;
        customArtHeights = null;
        customArtWidths = null;
        customArtResources = null;
    }
}

