/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.world.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.Facing;
import net.minecraft.world.World;
import net.tropicraft.registry.TCBlockRegistry;
import net.tropicraft.world.worldgen.TCGenBase;

public class WorldGenTallTree
extends TCGenBase {
    private static final int VINE_CHANCE = 5;
    private static final int SMALL_LEAF_CHANCE = 3;
    private static final int SECOND_CANOPY_CHANCE = 3;
    private static final Block WOOD_BLOCK = TCBlockRegistry.logs;
    private static final int WOOD_META = 1;
    private static final Block LEAF_BLOCK = TCBlockRegistry.rainforestLeaves;
    private static final int LEAF_META = 1;

    public WorldGenTallTree(World world, Random random) {
        super(world, random);
    }

    @Override
    public boolean func_76484_a(World world, Random random, int i, int j, int k) {
        return this.generate(i, j, k);
    }

    @Override
    public boolean generate(int i, int j, int k) {
        int z;
        int x;
        int y;
        Block blockUnder = this.worldObj.func_147439_a(i, j - 1, k);
        if (blockUnder != Blocks.field_150346_d && blockUnder != Blocks.field_150349_c) {
            return false;
        }
        blockUnder = this.worldObj.func_147439_a(i + 1, j - 1, k);
        if (blockUnder != Blocks.field_150346_d && blockUnder != Blocks.field_150349_c) {
            return false;
        }
        blockUnder = this.worldObj.func_147439_a(i - 1, j - 1, k);
        if (blockUnder != Blocks.field_150346_d && blockUnder != Blocks.field_150349_c) {
            return false;
        }
        blockUnder = this.worldObj.func_147439_a(i, j - 1, k + 1);
        if (blockUnder != Blocks.field_150346_d && blockUnder != Blocks.field_150349_c) {
            return false;
        }
        blockUnder = this.worldObj.func_147439_a(i, j - 1, k - 1);
        if (blockUnder != Blocks.field_150346_d && blockUnder != Blocks.field_150349_c) {
            return false;
        }
        int height = this.rand.nextInt(15) + 15;
        for (y = j; y < j + height + 6; ++y) {
            for (x = i - 1; x <= i + 1; ++x) {
                for (z = k - 1; z <= k + 1; ++z) {
                    Block block = this.worldObj.func_147439_a(x, y, z);
                    if (block == Blocks.field_150350_a || block == Blocks.field_150329_H || block == LEAF_BLOCK) continue;
                    return false;
                }
            }
        }
        this.worldObj.func_147465_d(i, j, k, Blocks.field_150346_d, 0, blockGenNotifyFlag);
        this.worldObj.func_147465_d(i - 1, j, k, Blocks.field_150346_d, 0, blockGenNotifyFlag);
        this.worldObj.func_147465_d(i + 1, j, k, Blocks.field_150346_d, 0, blockGenNotifyFlag);
        this.worldObj.func_147465_d(i, j, k - 1, Blocks.field_150346_d, 0, blockGenNotifyFlag);
        this.worldObj.func_147465_d(i, j, k + 1, Blocks.field_150346_d, 0, blockGenNotifyFlag);
        for (y = j; y < j + height; ++y) {
            int nz;
            int nx;
            this.worldObj.func_147465_d(i, y, k, WOOD_BLOCK, 1, blockGenNotifyFlag);
            this.worldObj.func_147465_d(i - 1, y, k, WOOD_BLOCK, 1, blockGenNotifyFlag);
            this.worldObj.func_147465_d(i + 1, y, k, WOOD_BLOCK, 1, blockGenNotifyFlag);
            this.worldObj.func_147465_d(i, y, k - 1, WOOD_BLOCK, 1, blockGenNotifyFlag);
            this.worldObj.func_147465_d(i, y, k + 1, WOOD_BLOCK, 1, blockGenNotifyFlag);
            if (y - j > height / 2 && this.rand.nextInt(3) == 0) {
                nx = this.rand.nextInt(3) - 1 + i;
                nz = this.rand.nextInt(3) - 1 + k;
                this.genCircle(nx, y + 1, nz, 1.0, 0.0, LEAF_BLOCK, 1, false);
                this.genCircle(nx, y, nz, 2.0, 1.0, LEAF_BLOCK, 1, false);
                for (int x2 = nx - 3; x2 <= nx + 3; ++x2) {
                    for (int z2 = nz - 3; z2 <= nz + 3; ++z2) {
                        for (int y1 = y - 1; y1 <= y; ++y1) {
                            if (this.rand.nextInt(5) != 0) continue;
                            this.genVines(x2, y1, z2);
                        }
                    }
                }
            }
            if (y - j <= height - height / 4 || y - j >= height - 3 || this.rand.nextInt(3) != 0) continue;
            nx = i + this.rand.nextInt(9) - 4;
            nz = k + this.rand.nextInt(9) - 4;
            int leafSize = this.rand.nextInt(3) + 5;
            this.genCircle(nx, y + 3, nz, leafSize - 2, 0.0, LEAF_BLOCK, 1, false);
            this.genCircle(nx, y + 2, nz, leafSize - 1, leafSize - 3, LEAF_BLOCK, 1, false);
            this.genCircle(nx, y + 1, nz, leafSize, leafSize - 1, LEAF_BLOCK, 1, false);
            this.placeBlockLine(new int[]{i, y - 2, k}, new int[]{nx, y + 2, nz}, WOOD_BLOCK, 1);
            for (int x3 = nx - leafSize; x3 <= nx + leafSize; ++x3) {
                for (int z3 = nz - leafSize; z3 <= nz + leafSize; ++z3) {
                    for (int y1 = y; y1 <= y + 2; ++y1) {
                        if (this.rand.nextInt(5) != 0) continue;
                        this.genVines(x3, y1, z3);
                    }
                }
            }
        }
        int leafSize = this.rand.nextInt(5) + 9;
        this.genCircle(i, j + height, k, leafSize - 2, 0.0, LEAF_BLOCK, 1, false);
        this.genCircle(i, j + height - 1, k, leafSize - 1, leafSize - 4, LEAF_BLOCK, 1, false);
        this.genCircle(i, j + height - 2, k, leafSize, leafSize - 1, LEAF_BLOCK, 1, false);
        for (x = i - leafSize; x <= i + leafSize; ++x) {
            for (z = k - leafSize; z <= k + leafSize; ++z) {
                for (int y1 = j + height + 3; y1 <= j + height + 6; ++y1) {
                    if (this.rand.nextInt(5) != 0) continue;
                    this.genVines(x, y1, z);
                }
            }
        }
        return true;
    }

    private boolean genVines(int i, int j, int k) {
        int m = 2;
        while (true) {
            if (m > 5) {
                return false;
            }
            if (Blocks.field_150395_bd.func_149707_d(this.worldObj, i, j, k, m) && this.worldObj.func_147439_a(i, j, k) == Blocks.field_150350_a) break;
            ++m;
        }
        this.worldObj.func_147465_d(i, j, k, Blocks.field_150395_bd, 1 << Direction.field_71579_d[Facing.field_71588_a[m]], blockGenNotifyFlag);
        int length = this.rand.nextInt(4) + 4;
        for (int y = j - 1; y > j - length; --y) {
            if (this.worldObj.func_147439_a(i, y, k) != Blocks.field_150350_a) {
                return true;
            }
            this.worldObj.func_147465_d(i, y, k, Blocks.field_150395_bd, 1 << Direction.field_71579_d[Facing.field_71588_a[m]], blockGenNotifyFlag);
        }
        return true;
    }
}

