/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.world.worldgen;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.tropicraft.registry.TCBlockRegistry;
import net.tropicraft.registry.TCItemRegistry;
import net.tropicraft.world.worldgen.TCGenBase;

public class WorldGenHomeTree
extends TCGenBase {
    private final Block woodID = TCBlockRegistry.logs;
    private final int woodMeta = 1;
    private final Block leafID = TCBlockRegistry.rainforestLeaves;
    private final int leafMeta = 0;
    private ArrayList<BranchNode> branchList = new ArrayList();
    private int trunkRadius;

    public WorldGenHomeTree(World world, Random random) {
        super(world, random);
    }

    @Override
    public boolean generate(int i, int j, int k) {
        j = 127;
        this.trunkRadius = this.rand.nextInt(3) + 7;
        for (int x = i - this.trunkRadius; x < i + this.trunkRadius; ++x) {
            for (int z = k - this.trunkRadius; z < k + this.trunkRadius; ++z) {
                int tHeight = this.getTerrainHeightAt(x, z);
                if (tHeight >= j) continue;
                j = tHeight;
            }
        }
        int height = this.rand.nextInt(20) + 30;
        if (height + j + 12 > 255) {
            return false;
        }
        System.err.println("HOME TREE INCOMING! " + i + " " + j + " " + k);
        int[] top = this.generateTrunk(i, j, k, height);
        this.generateBranches(top[0], top[1], height + j);
        return true;
    }

    public int[] generateTrunk(int i, int j, int k, int height) {
        int x;
        int bn = 0;
        int chanceToDisplace = 0;
        int xDisplace = this.rand.nextBoolean() ? 1 : -1;
        int zDisplace = this.rand.nextBoolean() ? 1 : -1;
        int trunkX = i;
        int trunkZ = k;
        for (int y = j; y < height + j; ++y) {
            ++chanceToDisplace;
            this.genCircle(trunkX, y, trunkZ, this.trunkRadius, this.trunkRadius - 3, this.woodID, 1, false);
            if (y == height + j - 1 || (y - j) % 6 == 0) {
                this.genCircle(trunkX, y, trunkZ, this.trunkRadius, 2.0, this.woodID, 1, false);
                this.placeBlock(trunkX + 1, y, trunkZ + 1, this.woodID, 1, false);
                this.placeBlock(trunkX + 1, y, trunkZ - 1, this.woodID, 1, false);
                this.placeBlock(trunkX - 1, y, trunkZ + 1, this.woodID, 1, false);
                this.placeBlock(trunkX - 1, y, trunkZ - 1, this.woodID, 1, false);
                double angle = this.rand.nextDouble() * 3.141592 * 2.0;
                if (this.rand.nextInt(3) == 0) {
                    double length = this.rand.nextDouble() * (double)this.trunkRadius - 4.0;
                    int spawnerX = trunkX - 4 + this.rand.nextInt(9);
                    int spawnerZ = trunkZ - 4 + this.rand.nextInt(9);
                    this.worldObj.func_147449_b(spawnerX, y + 1, spawnerZ, Blocks.field_150474_ac);
                    StringBuilder sb = new StringBuilder(String.format("%s.", "tropicraft"));
                    sb.append(this.rand.nextBoolean() ? "AshenHunter" : "Iguana");
                    TileEntityMobSpawner spawner = (TileEntityMobSpawner)this.worldObj.func_147438_o(spawnerX, y + 1, spawnerZ);
                    if (spawner != null) {
                        spawner.func_145881_a().func_98272_a(sb.toString());
                    }
                }
            }
            this.placeBlock(trunkX, y, trunkZ, this.woodID, 1, false);
            this.placeBlock(trunkX + 1, y, trunkZ, Blocks.field_150395_bd, 2, false);
            this.placeBlock(trunkX - 1, y, trunkZ, Blocks.field_150395_bd, 2, false);
            this.placeBlock(trunkX, y, trunkZ + 1, Blocks.field_150395_bd, 2, false);
            this.placeBlock(trunkX, y, trunkZ - 1, Blocks.field_150395_bd, 2, false);
            if (this.rand.nextInt(6) == 0) {
                // empty if block
            }
            if (y >= j + height - 6) {
                int branches = this.rand.nextInt(4) + 2;
                for (x = 0; x < branches; ++x) {
                    int branchLength = this.rand.nextInt(10) + 15;
                    int branchX1 = trunkX;
                    int branchZ1 = trunkZ;
                    double angle = this.rand.nextDouble() * 3.141592 * 2.0;
                    branchX1 = (int)((double)this.trunkRadius * Math.sin(angle) + (double)branchX1);
                    branchZ1 = (int)((double)this.trunkRadius * Math.cos(angle) + (double)branchZ1);
                    int branchX2 = (int)((double)branchLength * Math.sin(angle) + (double)branchX1);
                    int branchZ2 = (int)((double)branchLength * Math.cos(angle) + (double)branchZ1);
                    int branchY2 = this.rand.nextInt(4) + 4;
                    this.branchList.add(new BranchNode(branchX1, y, branchZ1, branchX2, y + branchY2, branchZ2));
                    ++bn;
                }
            }
            if (this.rand.nextInt(6) + 4 <= chanceToDisplace && chanceToDisplace * 9 > y) {
                if (this.rand.nextBoolean()) {
                    trunkX += xDisplace;
                    if (this.rand.nextBoolean()) {
                        trunkZ += zDisplace;
                    }
                } else if (this.rand.nextBoolean()) {
                    trunkZ += zDisplace;
                    if (this.rand.nextBoolean()) {
                        trunkZ += xDisplace;
                    }
                }
                chanceToDisplace = 0;
            }
            this.placeBlock(trunkX, y, trunkZ, Blocks.field_150364_r, 0, false);
        }
        this.worldObj.func_147449_b(trunkX - 1, height + j, trunkZ - 1, (Block)TCBlockRegistry.bambooChest);
        TileEntityChest chest = (TileEntityChest)this.worldObj.func_147438_o(trunkX - 1, height + j, trunkZ - 1);
        if (chest != null) {
            int treasure = this.rand.nextInt(6) + 4;
            for (x = 0; x < treasure; ++x) {
                chest.func_70299_a(this.rand.nextInt(chest.func_70302_i_()), this.randLoot());
            }
        }
        return new int[]{trunkX, trunkZ};
    }

    public void generateBranches(int topX, int topZ, int height) {
        for (int x = 0; x < this.branchList.size(); ++x) {
            BranchNode bnode = this.branchList.get(x);
            int lSize = 3;
            if (!this.checkBlockLine(new int[]{bnode.x1, bnode.y1, bnode.z1}, new int[]{bnode.x2, bnode.y2, bnode.z2}, this.standardAllowedBlocks) && !this.checkBlockLine(new int[]{bnode.x1 + 1, bnode.y1, bnode.z1}, new int[]{bnode.x2 + 1, bnode.y2, bnode.z2}, this.standardAllowedBlocks) && !this.checkBlockLine(new int[]{bnode.x1 - 1, bnode.y1, bnode.z1}, new int[]{bnode.x2 - 1, bnode.y2, bnode.z2}, this.standardAllowedBlocks) && !this.checkBlockLine(new int[]{bnode.x1, bnode.y1, bnode.z1 + 1}, new int[]{bnode.x2, bnode.y2, bnode.z2 + 1}, this.standardAllowedBlocks) && !this.checkBlockLine(new int[]{bnode.x1, bnode.y1, bnode.z1 - 1}, new int[]{bnode.x2, bnode.y2, bnode.z2 - 1}, this.standardAllowedBlocks) && !this.checkBlockLine(new int[]{bnode.x1, bnode.y1 - 1, bnode.z1}, new int[]{bnode.x2, bnode.y2 - 1, bnode.z2}, this.standardAllowedBlocks)) continue;
            this.placeBlockLine(new int[]{bnode.x1, bnode.y1, bnode.z1}, new int[]{bnode.x2, bnode.y2, bnode.z2}, this.woodID, 1);
            this.placeBlockLine(new int[]{bnode.x1 + 1, bnode.y1, bnode.z1}, new int[]{bnode.x2 + 1, bnode.y2, bnode.z2}, this.woodID, 1);
            this.placeBlockLine(new int[]{bnode.x1 - 1, bnode.y1, bnode.z1}, new int[]{bnode.x2 - 1, bnode.y2, bnode.z2}, this.woodID, 1);
            this.placeBlockLine(new int[]{bnode.x1, bnode.y1, bnode.z1 + 1}, new int[]{bnode.x2, bnode.y2, bnode.z2 + 1}, this.woodID, 1);
            this.placeBlockLine(new int[]{bnode.x1, bnode.y1, bnode.z1 - 1}, new int[]{bnode.x2, bnode.y2, bnode.z2 - 1}, this.woodID, 1);
            this.placeBlockLine(new int[]{bnode.x1, bnode.y1 - 1, bnode.z1}, new int[]{bnode.x2, bnode.y2 - 1, bnode.z2}, this.woodID, 1);
            if (bnode.y2 + 1 <= height) {
                this.placeBlockLine(new int[]{bnode.x1, bnode.y1 + 1, bnode.z1}, new int[]{bnode.x2, bnode.y2 + 1, bnode.z2}, this.woodID, 1);
            }
            this.genLeafCircle(bnode.x2, bnode.y2 - 1, bnode.z2, lSize + 5, lSize + 3, this.leafID, 0, true);
            this.genLeafCircle(bnode.x2, bnode.y2, bnode.z2, lSize + 6, 0, this.leafID, 0, true);
            this.genLeafCircle(bnode.x2, bnode.y2 + 1, bnode.z2, lSize + 10, 0, this.leafID, 0, true);
            this.genLeafCircle(bnode.x2, bnode.y2 + 2, bnode.z2, lSize + 9, 0, this.leafID, 0, true);
        }
        int topBranches = this.rand.nextInt(6) + 6;
    }

    public boolean genTopBranch(int i, int j, int k, int sX, int sY, int sZ, int topX, int topZ) {
        int z;
        int x;
        ArrayList<Block> allowedBlocks = new ArrayList<Block>(this.standardAllowedBlocks);
        allowedBlocks.add(this.woodID);
        allowedBlocks.add(this.leafID);
        allowedBlocks.add(Blocks.field_150395_bd);
        int branchSize = this.rand.nextInt(2) + 4;
        ArrayList lines = new ArrayList();
        for (x = i - branchSize; x < i + branchSize; ++x) {
            for (z = k - branchSize; z < k + branchSize; ++z) {
                if ((x - i) * (x - i) + (z - k) * (z - k) >= branchSize * branchSize || (x - topX) * (x - topX) + (z - topZ) * (z - topZ) >= this.trunkRadius * this.trunkRadius || this.checkBlockLine(new int[]{x, j, z}, new int[]{sX + (i - x), sY, sZ + (k - z)}, allowedBlocks)) continue;
                return false;
            }
        }
        for (x = i - branchSize; x < i + branchSize; ++x) {
            for (z = k - branchSize; z < k + branchSize; ++z) {
                if ((x - i) * (x - i) + (z - k) * (z - k) >= branchSize * branchSize || (x - topX) * (x - topX) + (z - topZ) * (z - topZ) >= this.trunkRadius * this.trunkRadius) continue;
                this.placeBlockLine(new int[]{x, j, z}, new int[]{sX + (i - x), sY, sZ + (k - z)}, this.woodID, 1);
            }
        }
        return true;
    }

    public void genLeafCircle(int x, int y, int z, int outerRadius, int innerRadius, Block leafID2, int meta, boolean vines) {
        int outerRadiusSquared = outerRadius * outerRadius;
        int innerRadiusSquared = innerRadius * innerRadius;
        for (int i = -outerRadius + x; i < outerRadius + x; ++i) {
            for (int k = -outerRadius + z; k < outerRadius + z; ++k) {
                double d = (x - i) * (x - i) + (z - k) * (z - k);
                if (!(d <= (double)outerRadiusSquared) || !(d >= (double)innerRadiusSquared)) continue;
                if (this.worldObj.func_147437_c(i, y, k) || this.worldObj.func_147439_a(i, y, k) == leafID2) {
                    this.placeBlock(i, y, k, leafID2, meta, false);
                }
                if (this.rand.nextInt(20) != 0 || !vines) continue;
                this.genVines(i, y - 1, k);
            }
        }
    }

    public void genVines(int i, int j, int k) {
        int length = this.rand.nextInt(15) + 8;
        int dir = this.rand.nextInt(4);
        for (int y = j; y > j - length && this.worldObj.func_147437_c(i, y, k); --y) {
            this.placeBlock(i, y, k, Blocks.field_150395_bd, dir, false);
        }
    }

    public boolean placeBlock(int i, int j, int k, Block woodID2, int meta, boolean force) {
        Block bID = this.worldObj.func_147439_a(i, j, k);
        if (force || bID == Blocks.field_150355_j || bID == Blocks.field_150358_i || bID == TCBlockRegistry.tropicsWater || bID == Blocks.field_150350_a) {
            if (meta == 0) {
                return this.worldObj.func_147465_d(i, j, k, woodID2, 0, 0);
            }
            return this.worldObj.func_147465_d(i, j, k, woodID2, meta, 0);
        }
        return false;
    }

    @Override
    public boolean genCircle(int i, int j, int k, double outerRadius, double innerRadius, Block id, int meta, boolean solid) {
        boolean hasGenned = false;
        double outerRadiusSquared = outerRadius * outerRadius;
        double innerRadiusSquared = innerRadius * innerRadius;
        for (int x = (int)(-outerRadius) + i; x < (int)outerRadius + i; ++x) {
            for (int z = (int)(-outerRadius) + k; z < (int)outerRadius + k; ++z) {
                Block bID;
                double d = (x - i) * (x - i) + (z - k) * (z - k);
                if (!(d <= outerRadiusSquared) || !(d >= innerRadiusSquared) || (bID = this.worldObj.func_147439_a(x, j, z)) != Blocks.field_150350_a && bID != Blocks.field_150355_j && bID != Blocks.field_150358_i && bID != TCBlockRegistry.tropicsWater && !solid || !this.placeBlock(x, j, z, id, meta, solid)) continue;
                hasGenned = true;
            }
        }
        return hasGenned;
    }

    @Override
    public ArrayList<int[]> placeBlockLine(int[] ai, int[] ai1, Block i, int meta) {
        ArrayList<int[]> places = new ArrayList<int[]>();
        int[] ai2 = new int[]{0, 0, 0};
        int j = 0;
        for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
            ai2[byte0] = ai1[byte0] - ai[byte0];
            if (Math.abs(ai2[byte0]) <= Math.abs(ai2[j])) continue;
            j = byte0;
        }
        if (ai2[j] == 0) {
            return null;
        }
        byte byte1 = otherCoordPairs[j];
        byte byte2 = otherCoordPairs[j + 3];
        int byte3 = ai2[j] > 0 ? 1 : -1;
        double d = (double)ai2[byte1] / (double)ai2[j];
        double d1 = (double)ai2[byte2] / (double)ai2[j];
        int[] ai3 = new int[]{0, 0, 0};
        int l = ai2[j] + byte3;
        for (int k = 0; k != l; k += byte3) {
            ai3[j] = MathHelper.func_76128_c((double)((double)(ai[j] + k) + 0.5));
            ai3[byte1] = MathHelper.func_76128_c((double)((double)ai[byte1] + (double)k * d + 0.5));
            ai3[byte2] = MathHelper.func_76128_c((double)((double)ai[byte2] + (double)k * d1 + 0.5));
            this.placeBlock(ai3[0], ai3[1], ai3[2], i, meta, true);
            places.add(new int[]{ai3[0], ai3[1], ai3[2]});
        }
        return places;
    }

    @Override
    public ArrayList<int[]> checkAndPlaceBlockLine(int[] ai, int[] ai1, Block i, int meta, List a) {
        int k;
        ArrayList<int[]> places = new ArrayList<int[]>();
        int[] ai2 = new int[]{0, 0, 0};
        int j = 0;
        for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
            ai2[byte0] = ai1[byte0] - ai[byte0];
            if (Math.abs(ai2[byte0]) <= Math.abs(ai2[j])) continue;
            j = byte0;
        }
        if (ai2[j] == 0) {
            return null;
        }
        byte byte1 = otherCoordPairs[j];
        byte byte2 = otherCoordPairs[j + 3];
        int byte3 = ai2[j] > 0 ? 1 : -1;
        double d = (double)ai2[byte1] / (double)ai2[j];
        double d1 = (double)ai2[byte2] / (double)ai2[j];
        int[] ai3 = new int[]{0, 0, 0};
        int l = ai2[j] + byte3;
        for (k = 0; k != l; k += byte3) {
            ai3[j] = MathHelper.func_76128_c((double)((double)(ai[j] + k) + 0.5));
            ai3[byte1] = MathHelper.func_76128_c((double)((double)ai[byte1] + (double)k * d + 0.5));
            ai3[byte2] = MathHelper.func_76128_c((double)((double)ai[byte2] + (double)k * d1 + 0.5));
            Block bId = this.worldObj.func_147439_a(ai3[0], ai3[1], ai3[2]);
            if (a.contains(bId)) continue;
            return null;
        }
        l = ai2[j] + byte3;
        while (k != l) {
            ai3[j] = MathHelper.func_76128_c((double)((double)(ai[j] + k) + 0.5));
            ai3[byte1] = MathHelper.func_76128_c((double)((double)ai[byte1] + (double)k * d + 0.5));
            ai3[byte2] = MathHelper.func_76128_c((double)((double)ai[byte2] + (double)k * d1 + 0.5));
            this.placeBlock(ai3[0], ai3[1], ai3[2], i, meta, true);
            places.add(new int[]{ai3[0], ai3[1], ai3[2]});
            k += byte3;
        }
        return places;
    }

    public ItemStack randLoot() {
        int picker = this.rand.nextInt(18);
        if (picker < 6) {
            return new ItemStack(TCItemRegistry.bambooChute, this.rand.nextInt(20) + 1);
        }
        if (picker < 8) {
            return new ItemStack((Item)TCItemRegistry.coconutBomb, this.rand.nextInt(3) + 1);
        }
        if (picker < 10) {
            return new ItemStack((Item)TCItemRegistry.scale, this.rand.nextInt(3) + 1);
        }
        if (picker < 14) {
            return new ItemStack((Item)TCItemRegistry.cookedFrogLeg, this.rand.nextInt(4) + 1);
        }
        if (picker <= 15) {
            return new ItemStack(TCItemRegistry.recordTradeWinds, 1);
        }
        if (picker == 16) {
            return new ItemStack(TCItemRegistry.recordEasternIsles, 1);
        }
        return new ItemStack((Item)TCItemRegistry.ore, 1, 3);
    }

    private class BranchNode {
        public int x1;
        public int y1;
        public int z1;
        public int x2;
        public int y2;
        public int z2;

        public BranchNode(int i, int j, int k, int x, int y, int z) {
            this.x1 = i;
            this.y1 = j;
            this.z1 = k;
            this.x2 = x;
            this.y2 = y;
            this.z2 = z;
        }
    }
}

