/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.world.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.world.World;
import net.tropicraft.registry.TCBlockRegistry;
import net.tropicraft.world.worldgen.TCGenBase;

public class WorldGenBamboo
extends TCGenBase {
    private static final int MIN_BAMBOO = 30;
    private static final int MAX_BAMBOO = 60;
    private static final int MIN_HEIGHT = 4;
    private static final int MAX_HEIGHT = 8;
    private static final Block BAMBOO_BLOCK = TCBlockRegistry.bambooChute;

    public WorldGenBamboo(World world, Random random) {
        super(world, random);
    }

    @Override
    public boolean generate(int i, int j, int k) {
        j = this.getTerrainHeightAt(i, k);
        if (!this.worldObj.func_147437_c(i, j, k)) {
            return false;
        }
        if (this.worldObj.func_147439_a(i + 1, j - 1, k).func_149688_o() != Material.field_151586_h && this.worldObj.func_147439_a(i - 1, j - 1, k).func_149688_o() != Material.field_151586_h && this.worldObj.func_147439_a(i, j - 1, k + 1).func_149688_o() != Material.field_151586_h && this.worldObj.func_147439_a(i, j - 1, k - 1).func_149688_o() != Material.field_151586_h) {
            return false;
        }
        int amount = this.rand.nextInt(30) + 30;
        int spread = this.rand.nextInt(3) - 1 + (int)(Math.sqrt(amount) / 2.0);
        for (int l = 0; l < amount; ++l) {
            int x = i + this.rand.nextInt(spread) - this.rand.nextInt(spread);
            int z = k + this.rand.nextInt(spread) - this.rand.nextInt(spread);
            int y = this.getTerrainHeightAt(x, z);
            int height = this.rand.nextInt(4) + 4;
            for (int h = 0; h < height && this.worldObj.func_147437_c(x, y + h, z); ++h) {
                this.worldObj.func_147465_d(x, y + h, z, BAMBOO_BLOCK, 0, blockGenNotifyFlag);
            }
        }
        return true;
    }
}

