/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.world.mapgen;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.tropicraft.registry.TCBlockRegistry;
import net.tropicraft.world.biomes.BiomeGenTropicraft;
import net.tropicraft.world.perlin.NoiseModule;
import net.tropicraft.world.perlin.generator.Billowed;

public class MapGenVolcano {
    protected HashMap coordMap = new HashMap();
    public static List<BiomeGenBase> volcanoSpawnBiomesLand = Arrays.asList(BiomeGenTropicraft.tropics, BiomeGenTropicraft.rainforestPlains);
    public static List<BiomeGenBase> volcanoSpawnBiomesOcean = Arrays.asList(BiomeGenTropicraft.tropicsOcean);
    private World worldObj;
    private boolean useArrays;
    private static final int CHUNK_SIZE_X = 16;
    private static final int CHUNK_SIZE_Z = 16;
    private static final int CHUNK_SIZE_Y = 256;
    private static final int MAX_RADIUS = 65;
    private static final int MIN_RADIUS = 45;
    private static final int LAND_STEEPNESS_MOD = 4;
    private static final int OCEAN_STEEPNESS_MOD = 8;
    private static final int CALDERA_CUTOFF = 110;
    private static final int VOLCANO_TOP = 103;
    private static final int VOLCANO_CRUST = 100;
    private static final int LAVA_LEVEL = 95;
    private static final int CRUST_HOLE_CHANCE = 15;
    private static final Block VOLCANO_BLOCK = TCBlockRegistry.chunkOHead;
    private static final Block LAVA_BLOCK = Blocks.field_150353_l;

    public MapGenVolcano(World worldObj, boolean useArrays) {
        this.worldObj = worldObj;
        this.useArrays = useArrays;
    }

    public Block[] generate(int i, int k, Block[] blocks, byte[] metas) {
        ChunkCoordinates volcanoCoords = this.getVolcanoNear(this.worldObj, i, k);
        if (volcanoCoords == null) {
            return blocks;
        }
        int[] heightmap = new int[256];
        for (int x = 0; x < 16; ++x) {
            block1: for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 127; ++y) {
                    Block blockID = this.getBlock(x, y, z, blocks);
                    if (blockID == Blocks.field_150350_a || blockID == TCBlockRegistry.tropicsWater) {
                        heightmap[x * 16 + z] = y;
                        continue block1;
                    }
                    if (y <= 75) continue;
                    heightmap[x * 16 + z] = y;
                    continue block1;
                }
            }
        }
        i *= 16;
        k *= 16;
        int volcCenterX = volcanoCoords.field_71574_a;
        int volcCenterZ = volcanoCoords.field_71573_c;
        int steepnessMod = volcanoCoords.field_71572_b == 1 ? 4 : 8;
        long seed = (long)volcCenterX * 341873128712L + (long)volcCenterZ * 132897987541L + this.worldObj.func_72912_H().func_76063_b() + 4291726L;
        Random rand = new Random(seed);
        int radiusX = rand.nextInt(20) + 45;
        int radiusZ = rand.nextInt(20) + 45;
        Billowed volcNoise = new Billowed(seed, 1, 1.0);
        volcNoise.amplitude = 0.45;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                float relativeX = x + i - volcCenterX;
                float relativeZ = z + k - volcCenterZ;
                float distanceSquared = relativeX / (float)radiusX * (relativeX / (float)radiusX) + relativeZ / (float)radiusZ * (relativeZ / (float)radiusZ);
                float perlin = (float)((NoiseModule)volcNoise).getNoise((double)relativeX * 0.05 + 1.0E-4, (double)relativeZ * 0.05 + 1.0E-4) + 1.0f;
                double volcanoHeight = (float)steepnessMod / distanceSquared * perlin - (float)steepnessMod - 2.0f;
                int groundHeight = heightmap[x * 16 + z];
                if (!(distanceSquared < 1.0f)) continue;
                for (int y = 256; y > 0; --y) {
                    if (volcanoHeight + (double)groundHeight < 110.0) {
                        if (volcanoHeight + (double)groundHeight <= 103.0) {
                            if (!((double)y <= volcanoHeight + (double)groundHeight) || y < groundHeight) continue;
                            this.placeBlock(x, y, z, VOLCANO_BLOCK, blocks);
                            continue;
                        }
                        if (y > 103) continue;
                        this.placeBlock(x, y, z, VOLCANO_BLOCK, blocks);
                        continue;
                    }
                    if (y == 100 && rand.nextInt(15) != 0) {
                        this.placeBlock(x, y, z, VOLCANO_BLOCK, blocks);
                    }
                    if (y > 95) continue;
                    this.placeBlock(x, y, z, LAVA_BLOCK, blocks);
                }
            }
        }
        return blocks;
    }

    public void placeBlock(int x, int y, int z, Block block, Block[] blocks) {
        blocks[x * 256 * 16 | z * 256 | y] = block;
    }

    public Block getBlock(int x, int y, int z, Block[] blocks) {
        return blocks[x * 256 * 16 | z * 256 | y];
    }

    protected int canGenVolcanoAtCoords(World worldObj, int i, int j) {
        int numChunks = 32;
        int offsetChunks = 8;
        int oldi = i;
        int oldj = j;
        if (i < 0) {
            i -= numChunks - 1;
        }
        if (j < 0) {
            j -= numChunks - 1;
        }
        int randX = i / numChunks;
        int randZ = j / numChunks;
        long seed = (long)randX * 341873128712L + (long)randZ * 132897987541L + worldObj.func_72912_H().func_76063_b() + 4291726L;
        Random rand = new Random(seed);
        randX *= numChunks;
        randZ *= numChunks;
        if (oldi == (randX += rand.nextInt(numChunks - offsetChunks)) && oldj == (randZ += rand.nextInt(numChunks - offsetChunks))) {
            if (worldObj.func_72959_q().func_76940_a(oldi * 16 + 8, oldj * 16 + 8, 0, volcanoSpawnBiomesLand)) {
                return 1;
            }
            if (worldObj.func_72959_q().func_76940_a(oldi * 16 + 8, oldj * 16 + 8, 0, volcanoSpawnBiomesOcean)) {
                return 2;
            }
        }
        return 0;
    }

    public ChunkCoordinates getVolcanoNear(World worldObj, int i, int j) {
        int range = 4;
        for (int x = i - range; x <= i + range; ++x) {
            for (int z = j - range; z <= j + range; ++z) {
                int biome = this.canGenVolcanoAtCoords(worldObj, x, z);
                if (biome == 0) continue;
                return new ChunkCoordinates(x * 16 + 8, biome, z * 16 + 8);
            }
        }
        return null;
    }
}

