/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.world.mapgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.MapGenBase;

public class MapGenTropicsCaves
extends MapGenBase {
    private static final int CHUNK_SIZE_Y = 256;

    public void generate(IChunkProvider chunkProvider, World world, int x, int z, Block[] blocks) {
        int range = this.field_75040_a;
        this.field_75039_c = world;
        this.field_75038_b.setSeed(world.func_72905_C());
        long l = this.field_75038_b.nextLong();
        long i1 = this.field_75038_b.nextLong();
        for (int j1 = x - range; j1 <= x + range; ++j1) {
            for (int k1 = z - range; k1 <= z + range; ++k1) {
                long l1 = (long)j1 * l;
                long i2 = (long)k1 * i1;
                this.field_75038_b.setSeed(l1 ^ i2 ^ world.func_72905_C());
                this.recursiveGenerate(world, j1, k1, x, z, blocks);
            }
        }
    }

    protected void generateLargeCaveNode(long seed, int chunkX, int chunkZ, Block[] blocks, double i, double j, double k) {
        this.generateCaveNode(seed, chunkX, chunkZ, blocks, i, j, k, 1.0f + this.field_75038_b.nextFloat() * 6.0f, 0.0f, 0.0f, -1, -1, 0.5);
    }

    protected void generateCaveNode(long seed, int chunkX, int chunkZ, Block[] blocks, double i, double j, double k, float sizeMod, float headingXZ, float headingY, int currentSection, int length, double sizeModY) {
        boolean flag1;
        double d4 = chunkX * 16 + 8;
        double d5 = chunkZ * 16 + 8;
        float f3 = 0.0f;
        float f4 = 0.0f;
        Random random = new Random(seed);
        if (length <= 0) {
            int j1 = this.field_75040_a * 16 - 16;
            length = j1 - random.nextInt(j1 / 4);
        }
        boolean flag = false;
        if (currentSection == -1) {
            currentSection = length / 2;
            flag = true;
        }
        int k1 = random.nextInt(length / 2) + length / 4;
        boolean bl = flag1 = random.nextInt(6) == 0;
        while (currentSection < length) {
            double d6 = 1.5 + (double)(MathHelper.func_76126_a((float)((float)currentSection * (float)Math.PI / (float)length)) * sizeMod * 1.0f);
            double d7 = d6 * sizeModY;
            float f5 = MathHelper.func_76134_b((float)headingY);
            float f6 = MathHelper.func_76126_a((float)headingY);
            i += (double)(MathHelper.func_76134_b((float)headingXZ) * f5);
            j += (double)f6;
            k += (double)(MathHelper.func_76126_a((float)headingXZ) * f5);
            headingY = flag1 ? (headingY *= 0.92f) : (headingY *= 0.7f);
            headingY += f4 * 0.1f;
            headingXZ += f3 * 0.1f;
            f4 *= 0.9f;
            f3 *= 0.75f;
            f4 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            f3 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (!flag && currentSection == k1 && sizeMod > 1.0f && length > 0) {
                this.generateCaveNode(random.nextLong(), chunkX, chunkZ, blocks, i, j, k, random.nextFloat() * 0.5f + 0.5f, headingXZ - 1.5707964f, headingY / 3.0f, currentSection, length, 1.0);
                this.generateCaveNode(random.nextLong(), chunkX, chunkZ, blocks, i, j, k, random.nextFloat() * 0.5f + 0.5f, headingXZ + 1.5707964f, headingY / 3.0f, currentSection, length, 1.0);
                return;
            }
            if (flag || random.nextInt(4) != 0) {
                double d8 = i - d4;
                double d9 = k - d5;
                double d10 = length - currentSection;
                double d11 = sizeMod + 2.0f + 16.0f;
                if (d8 * d8 + d9 * d9 - d10 * d10 > d11 * d11) {
                    return;
                }
                if (i >= d4 - 16.0 - d6 * 2.0 && k >= d5 - 16.0 - d6 * 2.0 && i <= d4 + 16.0 + d6 * 2.0 && k <= d5 + 16.0 + d6 * 2.0) {
                    int k3;
                    int j3;
                    int l1 = MathHelper.func_76128_c((double)(i - d6)) - chunkX * 16 - 1;
                    int i2 = MathHelper.func_76128_c((double)(i + d6)) - chunkX * 16 + 1;
                    int j2 = MathHelper.func_76128_c((double)(j - d7)) - 1;
                    int k2 = MathHelper.func_76128_c((double)(j + d7)) + 1;
                    int l2 = MathHelper.func_76128_c((double)(k - d6)) - chunkZ * 16 - 1;
                    int i3 = MathHelper.func_76128_c((double)(k + d6)) - chunkZ * 16 + 1;
                    if (l1 < 0) {
                        l1 = 0;
                    }
                    if (i2 > 16) {
                        i2 = 16;
                    }
                    if (j2 < 1) {
                        j2 = 1;
                    }
                    if (k2 > 120) {
                        k2 = 120;
                    }
                    if (l2 < 0) {
                        l2 = 0;
                    }
                    if (i3 > 16) {
                        i3 = 16;
                    }
                    boolean flag2 = false;
                    for (j3 = l1; !flag2 && j3 < i2; ++j3) {
                        for (int l3 = l2; !flag2 && l3 < i3; ++l3) {
                            for (int i4 = k2 + 1; !flag2 && i4 >= j2 - 1; --i4) {
                                k3 = j3 * 256 * 16 | l3 * 256 | i4;
                                if (i4 < 0 || i4 >= 128) continue;
                                if (this.isOceanBlock(blocks, k3, j3, i4, l3, chunkX, chunkZ)) {
                                    flag2 = true;
                                }
                                if (i4 == j2 - 1 || j3 == l1 || j3 == i2 - 1 || l3 == l2 || l3 == i3 - 1) continue;
                                i4 = j2;
                            }
                        }
                    }
                    if (!flag2) {
                        for (j3 = l1; j3 < i2; ++j3) {
                            double d12 = ((double)(j3 + chunkX * 16) + 0.5 - i) / d6;
                            for (k3 = l2; k3 < i3; ++k3) {
                                double d13 = ((double)(k3 + chunkZ * 16) + 0.5 - k) / d6;
                                boolean flag3 = false;
                                if (!(d12 * d12 + d13 * d13 < 1.0)) continue;
                                for (int k4 = k2 - 1; k4 >= j2; --k4) {
                                    int j4 = j3 * 256 * 16 | k3 * 256 | k4;
                                    double d14 = ((double)k4 + 0.5 - j) / d7;
                                    if (!(d14 > -0.7) || !(d12 * d12 + d14 * d14 + d13 * d13 < 1.0)) continue;
                                    if (this.isTopBlock(blocks, j4, j3, k4, k3, chunkX, chunkZ)) {
                                        flag3 = true;
                                    }
                                    this.digBlock(blocks, j4, j3, k4, k3, chunkX, chunkZ, flag3);
                                }
                            }
                        }
                        if (flag) break;
                    }
                }
            }
            ++currentSection;
        }
    }

    protected void recursiveGenerate(World world, int i, int k, int chunkX, int chunkZ, Block[] blocks) {
        int i1 = this.field_75038_b.nextInt(this.field_75038_b.nextInt(this.field_75038_b.nextInt(40) + 1) + 1);
        if (this.field_75038_b.nextInt(15) != 0) {
            i1 = 0;
        }
        for (int j1 = 0; j1 < i1; ++j1) {
            double x = i * 16 + this.field_75038_b.nextInt(16);
            double y = this.field_75038_b.nextInt(this.field_75038_b.nextInt(120) + 8);
            double z = k * 16 + this.field_75038_b.nextInt(16);
            int k1 = 1;
            if (this.field_75038_b.nextInt(4) == 0) {
                this.generateLargeCaveNode(this.field_75038_b.nextLong(), chunkX, chunkZ, blocks, x, y, z);
                k1 += this.field_75038_b.nextInt(4);
            }
            for (int l1 = 0; l1 < k1; ++l1) {
                float f = this.field_75038_b.nextFloat() * (float)Math.PI * 2.0f;
                float f1 = (this.field_75038_b.nextFloat() - 0.5f) * 2.0f / 8.0f;
                float f2 = this.field_75038_b.nextFloat() * 2.0f + this.field_75038_b.nextFloat();
                if (this.field_75038_b.nextInt(10) == 0) {
                    f2 *= this.field_75038_b.nextFloat() * this.field_75038_b.nextFloat() * 3.0f + 1.0f;
                }
                this.generateCaveNode(this.field_75038_b.nextLong(), chunkX, chunkZ, blocks, x, y, z, f2, f, f1, 0, 0, 1.0);
            }
        }
    }

    protected boolean isOceanBlock(Block[] data, int index, int x, int y, int z, int chunkX, int chunkZ) {
        return data[index] == Blocks.field_150355_j;
    }

    private boolean isExceptionBiome(BiomeGenBase biome) {
        if (biome == BiomeGenBase.field_76789_p) {
            return true;
        }
        if (biome == BiomeGenBase.field_76787_r) {
            return true;
        }
        return biome == BiomeGenBase.field_76769_d;
    }

    private boolean isTopBlock(Block[] data, int index, int x, int y, int z, int chunkX, int chunkZ) {
        BiomeGenBase biome = this.field_75039_c.func_72807_a(x + chunkX * 16, z + chunkZ * 16);
        return this.isExceptionBiome(biome) ? data[index] == Blocks.field_150349_c : data[index] == biome.field_76752_A;
    }

    protected void digBlock(Block[] data, int index, int x, int y, int z, int chunkX, int chunkZ, boolean foundTop) {
        BiomeGenBase biome = this.field_75039_c.func_72807_a(x + chunkX * 16, z + chunkZ * 16);
        BlockGrass top = this.isExceptionBiome(biome) ? Blocks.field_150349_c : biome.field_76752_A;
        Block filler = this.isExceptionBiome(biome) ? Blocks.field_150346_d : biome.field_76753_B;
        Block block = data[index];
        if (block == Blocks.field_150348_b || block == filler || block == top) {
            if (y < 10) {
                data[index] = Blocks.field_150353_l;
            } else {
                data[index] = Blocks.field_150350_a;
                if (foundTop && data[index - 1] == filler) {
                    data[index - 1] = top;
                }
            }
        }
    }
}

