/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.world.location;

import CoroUtil.world.WorldDirector;
import CoroUtil.world.WorldDirectorManager;
import CoroUtil.world.location.ManagedLocation;
import build.world.BuildDirectionHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.tropicraft.world.location.TownKoaVillage;

public class TownKoaVillageGenHelper {
    public static int areaLength = 76;
    public static int areaWidth = 86;
    public static int areaHeight = 16;

    public static boolean hookTryGenVillage(ChunkCoordinates parCoords, World parWorld) {
        int directionTry = TownKoaVillageGenHelper.getBestGenDirection(parCoords, parWorld);
        if (directionTry != -1) {
            System.out.println("test success! dir: " + directionTry);
            ChunkCoordinates centerCoords = TownKoaVillageGenHelper.getCoordsFromAdjustedDirection(parCoords, directionTry);
            System.out.println("centerCoords: " + centerCoords);
            TownKoaVillage village = new TownKoaVillage();
            WorldDirector wd = WorldDirectorManager.instance().getCoroUtilWorldDirector(parWorld);
            int minDistBetweenVillages = 128;
            for (ManagedLocation town : wd.lookupTickingManagedLocations.values()) {
                if (!(Math.sqrt(town.spawn.func_82371_e(parCoords)) < (double)minDistBetweenVillages)) continue;
                return false;
            }
            int newID = wd.lookupTickingManagedLocations.size();
            village.initData(newID, parWorld.field_73011_w.field_76574_g, centerCoords);
            village.direction = directionTry;
            village.initFirstTime();
            wd.addTickingLocation((ManagedLocation)village);
            return true;
        }
        return false;
    }

    public static int getBestGenDirection(ChunkCoordinates parCoords, World parWorld) {
        if (TownKoaVillageGenHelper.isClear(parCoords, parWorld, 1, 0)) {
            return 0;
        }
        if (TownKoaVillageGenHelper.isClear(parCoords, parWorld, 0, -1)) {
            return 1;
        }
        if (TownKoaVillageGenHelper.isClear(parCoords, parWorld, -1, 0)) {
            return 2;
        }
        if (TownKoaVillageGenHelper.isClear(parCoords, parWorld, 0, 1)) {
            return 3;
        }
        return -1;
    }

    public static boolean isClear(ChunkCoordinates parCoords, World parWorld, int scanX, int scanZ) {
        int sizeHorizMax = areaWidth;
        int sizeMiddle = areaWidth / 2;
        int topYBeach = 62;
        Block blockScanBeach = parWorld.func_147439_a(parCoords.field_71574_a, topYBeach, parCoords.field_71573_c);
        if (blockScanBeach.func_149688_o() == Material.field_151595_p) {
            int topYMiddle = 62;
            Block blockScanMiddle = parWorld.func_147439_a(parCoords.field_71574_a + sizeMiddle * scanX, topYMiddle, parCoords.field_71573_c + sizeMiddle * scanZ);
            System.out.println("testing scanX: " + scanX + " scanZ: " + scanZ);
            if (blockScanMiddle.func_149688_o() == Material.field_151586_h) {
                Block blockScanEnd = parWorld.func_147439_a(parCoords.field_71574_a + sizeHorizMax * scanX, topYMiddle, parCoords.field_71573_c + sizeHorizMax * scanZ);
                System.out.println("testing blockScanEnd x: " + (parCoords.field_71574_a + sizeHorizMax * scanX) + " z: " + (parCoords.field_71573_c + sizeHorizMax * scanZ));
                if (blockScanEnd.func_149688_o() == Material.field_151586_h) {
                    for (int i = 1; i <= 4; ++i) {
                        int sizeStep = sizeHorizMax / 4 * i;
                        Block blockScanFrontLeft = parWorld.func_147439_a(parCoords.field_71574_a + sizeStep * scanZ, topYMiddle, parCoords.field_71573_c + sizeStep * scanX);
                        Block blockScanFrontRight = parWorld.func_147439_a(parCoords.field_71574_a + sizeStep * scanZ * -1, topYMiddle, parCoords.field_71573_c + sizeStep * scanX * -1);
                        System.out.println("testing blockScanFrontLeft x: " + (parCoords.field_71574_a + sizeStep * scanZ) + " z: " + (parCoords.field_71573_c + sizeStep * scanX));
                        System.out.println("testing blockScanFrontRight x: " + (parCoords.field_71574_a + sizeStep * scanZ * -1) + " z: " + (parCoords.field_71573_c + sizeStep * scanX * -1));
                        if (blockScanFrontLeft.func_149688_o() == Material.field_151586_h && blockScanFrontRight.func_149688_o() == Material.field_151586_h) continue;
                        return false;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public static ChunkCoordinates getCoordsFromAdjustedDirection(ChunkCoordinates parCoords, int parDirection) {
        return new ChunkCoordinates(parCoords.field_71574_a + areaWidth / 2 * BuildDirectionHelper.getDirectionToCoords((int)parDirection).field_71574_a, parCoords.field_71572_b, parCoords.field_71573_c + areaWidth / 2 * BuildDirectionHelper.getDirectionToCoords((int)parDirection).field_71573_c);
    }
}

