/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.world.location;

import CoroUtil.util.CoroUtilFile;
import CoroUtil.world.location.ManagedLocation;
import CoroUtil.world.location.SpawnLocationData;
import CoroUtil.world.location.town.TownObject;
import build.BuildServerTicks;
import build.ICustomGen;
import build.world.Build;
import build.world.BuildJob;
import build.world.BuildManager;
import java.io.File;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.tropicraft.entity.koa.EntityKoaBase;
import net.tropicraft.entity.koa.EntityKoaFisher;
import net.tropicraft.entity.koa.EntityKoaHunter;
import net.tropicraft.entity.koa.EntityKoaShaman;
import net.tropicraft.entity.koa.EntityKoaTrader;
import net.tropicraft.world.location.TownKoaVillageGenHelper;

public class TownKoaVillage
extends TownObject
implements ICustomGen {
    public int areaLength = TownKoaVillageGenHelper.areaLength;
    public int areaWidth = TownKoaVillageGenHelper.areaWidth;
    public int areaHeight = TownKoaVillageGenHelper.areaHeight;
    public int direction = 1;

    public void tickUpdate() {
        super.tickUpdate();
        if (this.getWorld().func_82737_E() % 20L == 0L) {
            // empty if block
        }
    }

    public void initFirstTime() {
        super.initFirstTime();
        this.generateSpawnCoords();
        this.genStructure();
    }

    public void genStructure() {
        this.genSchematic();
    }

    public void genSchematic() {
        int yOffset = 0;
        Build mainStructureData = new Build(this.spawn.field_71574_a, this.spawn.field_71572_b + yOffset, this.spawn.field_71573_c, CoroUtilFile.getSaveFolderPath() + "TCSchematics" + File.separator + "koavillage");
        BuildJob bj = new BuildJob(-99, this.spawn.field_71574_a, this.spawn.field_71572_b + yOffset, this.spawn.field_71573_c, mainStructureData);
        bj.build.dim = this.getWorld().field_73011_w.field_76574_g;
        bj.useFirstPass = false;
        bj.useRotationBuild = true;
        bj.build_rate = 100;
        bj.notifyFlag = 0;
        bj.setDirection(this.direction);
        bj.customGenCallback = this;
        this.areaHeight = mainStructureData.map_sizeY;
        BuildServerTicks.buildMan.addBuild(bj);
    }

    public void spawnEntitiesForce() {
        System.out.println("Spawning koa village population for village: " + this.spawn);
        this.tickMonitorPersistantMembers();
    }

    public void generateSpawnCoords() {
        int y = 2;
        this.registerSpawnLocation(new SpawnLocationData(this.getRotatedCoordsWithRelFromCorner(77, 2 + y, 37), "shaman"));
        this.registerSpawnLocation(new SpawnLocationData(this.getRotatedCoordsWithRelFromCorner(25, y, 37), "trader"));
        this.registerSpawnLocation(this.getRotatedCoordsWithRelFromCorner(23, 1 + y, 20), new String[]{"fisher", "hunter"});
        this.registerSpawnLocation(this.getRotatedCoordsWithRelFromCorner(38, 1 + y, 14), new String[]{"fisher", "hunter"});
        this.registerSpawnLocation(this.getRotatedCoordsWithRelFromCorner(57, 1 + y, 3), new String[]{"fisher", "hunter"});
        this.registerSpawnLocation(this.getRotatedCoordsWithRelFromCorner(63, 1 + y, 17), new String[]{"fisher", "hunter"});
        this.registerSpawnLocation(this.getRotatedCoordsWithRelFromCorner(69, 1 + y, 3), new String[]{"fisher", "hunter"});
        this.registerSpawnLocation(this.getRotatedCoordsWithRelFromCorner(23, 1 + y, 54), new String[]{"fisher", "hunter"});
        this.registerSpawnLocation(this.getRotatedCoordsWithRelFromCorner(38, 1 + y, 60), new String[]{"fisher", "hunter"});
        this.registerSpawnLocation(this.getRotatedCoordsWithRelFromCorner(57, 1 + y, 71), new String[]{"fisher", "hunter"});
        this.registerSpawnLocation(this.getRotatedCoordsWithRelFromCorner(63, 1 + y, 57), new String[]{"fisher", "hunter"});
        this.registerSpawnLocation(this.getRotatedCoordsWithRelFromCorner(69, 1 + y, 71), new String[]{"fisher", "hunter"});
    }

    public ChunkCoordinates getRotatedCoordsWithRelFromCorner(int x, int y, int z) {
        ChunkCoordinates coords = new ChunkCoordinates(x, y, z);
        return BuildManager.rotateNew((ChunkCoordinates)coords, (int)this.direction, (Vec3)Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0), (Vec3)Vec3.func_72443_a((double)this.areaWidth, (double)this.areaHeight, (double)this.areaLength));
    }

    public void addEntity(String unitType, EntityLivingBase ent, int parMemberID) {
        super.addEntity(unitType, ent);
    }

    public void spawnMemberAtSpawnLocation(SpawnLocationData parData) {
        super.spawnMemberAtSpawnLocation(parData);
        EntityKoaBase ent = null;
        if (parData.type.equals("fisher")) {
            ent = new EntityKoaFisher(this.getWorld());
        } else if (parData.type.equals("hunter")) {
            ent = new EntityKoaHunter(this.getWorld());
        } else if (parData.type.equals("trader")) {
            ent = new EntityKoaTrader(this.getWorld());
        } else if (parData.type.equals("shaman")) {
            ent = new EntityKoaShaman(this.getWorld());
        }
        if (ent != null) {
            ent.getAIAgent().setManagedLocation((ManagedLocation)this);
            ent.func_70107_b((float)(this.spawn.field_71574_a + parData.coords.field_71574_a) + 0.5f, this.spawn.field_71572_b + parData.coords.field_71572_b, (float)(this.spawn.field_71573_c + parData.coords.field_71573_c) + 0.5f);
            this.getWorld().func_72838_d((Entity)ent);
            this.addEntity(parData.type, (EntityLivingBase)ent);
            parData.entityUUID = ent.getPersistentID();
            ent.func_110161_a(null);
        }
    }

    public void genPassPre(World world, BuildJob parBuildJob, int parPass) {
        if (parPass == -1) {
            this.spawnEntitiesForce();
        }
    }

    public NBTTagCompound getInitNBTTileEntity() {
        return null;
    }

    public void readFromNBT(NBTTagCompound var1) {
        super.readFromNBT(var1);
        this.direction = var1.func_74762_e("direction");
    }

    public void writeToNBT(NBTTagCompound var1) {
        super.writeToNBT(var1);
        var1.func_74768_a("direction", this.direction);
    }
}

