/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.world.chunk;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.tropicraft.block.BlockMineralSands;
import net.tropicraft.registry.TCBlockRegistry;
import net.tropicraft.world.biomes.BiomeGenTropicraft;
import net.tropicraft.world.mapgen.MapGenTropicsCaves;
import net.tropicraft.world.mapgen.MapGenUndergroundGrove;
import net.tropicraft.world.mapgen.MapGenVolcano;

public class ChunkProviderTropicraft
implements IChunkProvider {
    private static final int CHUNK_SIZE_Y = 256;
    private static final int HOME_TREE_RARITY = 350;
    private World worldObj;
    private long seed;
    protected Random rand;
    private BiomeGenBase[] biomesForGeneration;
    private MapGenUndergroundGrove groveGen;
    private MapGenTropicsCaves caveGenerator;
    private MapGenVolcano volcanoGen;
    private NoiseGeneratorOctaves noiseGen1;
    private NoiseGeneratorOctaves noiseGen2;
    private NoiseGeneratorOctaves noiseGen3;
    private NoiseGeneratorOctaves noiseGen4;
    private NoiseGeneratorOctaves noiseGen5;
    private WorldGenerator eudialyteGen;
    private WorldGenerator zirconGen;
    private WorldGenerator azuriteGen;
    private WorldGenerator ironGen;
    private WorldGenerator coalGen;
    private WorldGenerator lapisGen;
    private float[] parabolicField;

    public ChunkProviderTropicraft(World worldObj, long seed, boolean par4) {
        this.worldObj = worldObj;
        this.rand = new Random(seed);
        this.noiseGen1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen3 = new NoiseGeneratorOctaves(this.rand, 8);
        this.noiseGen4 = new NoiseGeneratorOctaves(this.rand, 10);
        this.noiseGen5 = new NoiseGeneratorOctaves(this.rand, 16);
        this.caveGenerator = new MapGenTropicsCaves();
        this.volcanoGen = new MapGenVolcano(worldObj, true);
        this.groveGen = new MapGenUndergroundGrove(worldObj);
        this.coalGen = new WorldGenMinable(Blocks.field_150365_q, 16);
        this.lapisGen = new WorldGenMinable(Blocks.field_150369_x, 6);
        this.ironGen = new WorldGenMinable(Blocks.field_150366_p, 8);
        this.eudialyteGen = new WorldGenMinable(TCBlockRegistry.eudialyteOre, 6);
        this.zirconGen = new WorldGenMinable(TCBlockRegistry.zirconOre, 4);
        this.azuriteGen = new WorldGenMinable(TCBlockRegistry.azuriteOre, 2);
        this.seed = seed;
    }

    public Chunk func_73154_d(int x, int z) {
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        Block[] blocks = new Block[65536];
        byte[] metas = new byte[65536];
        this.generateTerrain(x, z, blocks, metas);
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        this.replaceBlocksForBiome(x, z, blocks, metas, this.biomesForGeneration);
        this.volcanoGen.generate(x, z, blocks, metas);
        this.groveGen.generate(x, z, blocks, metas);
        this.caveGenerator.generate(this, this.worldObj, x, z, blocks);
        Chunk chunk = new Chunk(this.worldObj, blocks, metas, x, z);
        byte[] abyte1 = chunk.func_76605_m();
        for (int k = 0; k < abyte1.length; ++k) {
            abyte1[k] = (byte)this.biomesForGeneration[k].field_76756_M;
        }
        chunk.func_76603_b();
        return chunk;
    }

    private void generateTerrain(int x, int z, Block[] blocks, byte[] metas) {
        int chunkSizeGenXZ = 4;
        int chunkSizeGenY = 16;
        int midHeight = 63;
        int k = chunkSizeGenXZ + 1;
        int b3 = 17;
        int l = chunkSizeGenXZ + 1;
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76937_a(this.biomesForGeneration, x * 4 - 2, z * 4 - 2, k + 5, l + 5);
        double[] noiseArray = null;
        noiseArray = this.initializeNoiseField(noiseArray, x * chunkSizeGenXZ, 0, z * chunkSizeGenXZ, k, b3, l);
        for (int i1 = 0; i1 < chunkSizeGenXZ; ++i1) {
            for (int j1 = 0; j1 < chunkSizeGenXZ; ++j1) {
                for (int k1 = 0; k1 < chunkSizeGenY; ++k1) {
                    double d0 = 0.125;
                    double d1 = noiseArray[((i1 + 0) * l + j1 + 0) * b3 + k1 + 0];
                    double d2 = noiseArray[((i1 + 0) * l + j1 + 1) * b3 + k1 + 0];
                    double d3 = noiseArray[((i1 + 1) * l + j1 + 0) * b3 + k1 + 0];
                    double d4 = noiseArray[((i1 + 1) * l + j1 + 1) * b3 + k1 + 0];
                    double d5 = (noiseArray[((i1 + 0) * l + j1 + 0) * b3 + k1 + 1] - d1) * d0;
                    double d6 = (noiseArray[((i1 + 0) * l + j1 + 1) * b3 + k1 + 1] - d2) * d0;
                    double d7 = (noiseArray[((i1 + 1) * l + j1 + 0) * b3 + k1 + 1] - d3) * d0;
                    double d8 = (noiseArray[((i1 + 1) * l + j1 + 1) * b3 + k1 + 1] - d4) * d0;
                    for (int l1 = 0; l1 < 8; ++l1) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int i2 = 0; i2 < 4; ++i2) {
                            double d14 = 0.25;
                            double d15 = (d11 - d10) * d14;
                            double d16 = d10 - d15;
                            for (int k2 = 0; k2 < 4; ++k2) {
                                double d;
                                int index = (i1 * 4 + i2) * 256 * 16 | (j1 * 4 + k2) * 256 | k1 * 8 + l1;
                                d16 += d15;
                                blocks[index] = d > 0.0 ? Blocks.field_150348_b : (k1 * 8 + l1 < midHeight ? TCBlockRegistry.tropicsWater : Blocks.field_150350_a);
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    private double[] initializeNoiseField(double[] par1ArrayOfDouble, int par2, int par3, int par4, int par5, int par6, int par7) {
        if (par1ArrayOfDouble == null) {
            par1ArrayOfDouble = new double[par5 * par6 * par7];
        }
        if (this.parabolicField == null) {
            this.parabolicField = new float[25];
            for (int k1 = -2; k1 <= 2; ++k1) {
                for (int l1 = -2; l1 <= 2; ++l1) {
                    float f;
                    this.parabolicField[k1 + 2 + (l1 + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(k1 * k1 + l1 * l1) + 0.2f));
                }
            }
        }
        double d0 = 684.412;
        double d1 = 684.412;
        double[] noise1 = null;
        double[] noise2 = null;
        double[] noise3 = null;
        double[] noise4 = null;
        double[] noise5 = null;
        noise1 = this.noiseGen1.func_76304_a(noise1, par2, par3, par4, par5, par6, par7, d0, d1, d0);
        noise2 = this.noiseGen2.func_76304_a(noise2, par2, par3, par4, par5, par6, par7, d0, d1, d0);
        noise3 = this.noiseGen3.func_76304_a(noise3, par2, par3, par4, par5, par6, par7, d0 / 80.0, d1 / 160.0, d0 / 80.0);
        noise4 = this.noiseGen4.func_76305_a(noise4, par2, par4, par5, par7, 1.121, 1.121, 0.5);
        noise5 = this.noiseGen5.func_76305_a(noise5, par2, par4, par5, par7, 200.0, 200.0, 0.5);
        boolean flag = false;
        boolean flag1 = false;
        int i2 = 0;
        int j2 = 0;
        for (int k2 = 0; k2 < par5; ++k2) {
            for (int l2 = 0; l2 < par7; ++l2) {
                float f1 = 0.0f;
                float f2 = 0.0f;
                float f3 = 0.0f;
                int b0 = 2;
                BiomeGenBase biomegenbase = this.biomesForGeneration[k2 + 2 + (l2 + 2) * (par5 + 5)];
                for (int i3 = -b0; i3 <= b0; ++i3) {
                    for (int j3 = -b0; j3 <= b0; ++j3) {
                        BiomeGenBase biomegenbase1 = this.biomesForGeneration[k2 + i3 + 2 + (l2 + j3 + 2) * (par5 + 5)];
                        float f4 = this.parabolicField[i3 + 2 + (j3 + 2) * 5] / (biomegenbase1.field_76748_D + 2.0f);
                        if (biomegenbase1.field_76748_D > biomegenbase.field_76748_D) {
                            f4 /= 2.0f;
                        }
                        f1 += biomegenbase1.field_76749_E * f4;
                        f2 += biomegenbase1.field_76748_D * f4;
                        f3 += f4;
                    }
                }
                f1 /= f3;
                f2 /= f3;
                f1 = f1 * 0.9f + 0.1f;
                f2 = (f2 * 4.0f - 1.0f) / 8.0f;
                double d2 = noise5[j2] / 8000.0;
                if (d2 < 0.0) {
                    d2 = -d2 * 0.3;
                }
                if ((d2 = d2 * 3.0 - 2.0) < 0.0) {
                    if ((d2 /= 2.0) < -1.0) {
                        d2 = -1.0;
                    }
                    d2 /= 1.4;
                    d2 /= 2.0;
                } else {
                    if (d2 > 1.0) {
                        d2 = 1.0;
                    }
                    d2 /= 8.0;
                }
                ++j2;
                for (int k3 = 0; k3 < par6; ++k3) {
                    double d3 = f2;
                    double d4 = f1;
                    d3 += d2 * 0.2;
                    d3 = d3 * (double)par6 / 16.0;
                    double d5 = (double)par6 / 2.0 + d3 * 4.0;
                    double d6 = 0.0;
                    double d7 = ((double)k3 - d5) * 12.0 * 128.0 / 128.0 / d4;
                    if (d7 < 0.0) {
                        d7 *= 4.0;
                    }
                    double d8 = noise1[i2] / 512.0;
                    double d9 = noise2[i2] / 512.0;
                    double d10 = (noise3[i2] / 10.0 + 1.0) / 2.0;
                    d6 = d10 < 0.0 ? d8 : (d10 > 1.0 ? d9 : d8 + (d9 - d8) * d10);
                    d6 -= d7;
                    if (k3 > par6 - 4) {
                        double d11 = (float)(k3 - (par6 - 4)) / 3.0f;
                        d6 = d6 * (1.0 - d11) + -10.0 * d11;
                    }
                    par1ArrayOfDouble[i2] = d6;
                    ++i2;
                }
            }
        }
        return par1ArrayOfDouble;
    }

    public void replaceBlocksForBiome(int x, int z, Block[] blocks, byte[] metas, BiomeGenBase[] biomes) {
        int sandMetadata;
        BlockMineralSands sandBlock;
        int sandType = this.rand.nextInt(200);
        switch (sandType) {
            case 0: {
                sandBlock = TCBlockRegistry.mineralSands;
                sandMetadata = 0;
                break;
            }
            case 1: {
                sandBlock = TCBlockRegistry.mineralSands;
                sandMetadata = 1;
                break;
            }
            case 2: {
                sandBlock = TCBlockRegistry.mineralSands;
                sandMetadata = 2;
                break;
            }
            case 3: {
                sandBlock = TCBlockRegistry.mineralSands;
                sandMetadata = 3;
                break;
            }
            default: {
                sandBlock = Blocks.field_150354_m;
                sandMetadata = 0;
            }
        }
        int a = -1;
        boolean flag = false;
        int k = 63;
        double d = 0.03125;
        for (int l = 0; l < 16; ++l) {
            for (int i1 = 0; i1 < 16; ++i1) {
                BlockMineralSands btop;
                BiomeGenTropicraft biome = (BiomeGenTropicraft)biomes[i1 + l * 16];
                Block top = biome.field_76752_A;
                Block filler = biome.field_76753_B;
                BlockMineralSands bfiller = btop = sandBlock;
                if (biome == BiomeGenTropicraft.tropicsOcean) {
                    btop = biome.sandBlock;
                    sandMetadata = 0;
                }
                for (int l1 = 127; l1 >= 0; --l1) {
                    int i2 = i1 * 256 * 16 | l * 256 | l1;
                    Block block = blocks[i2];
                    if (l1 <= 0) {
                        blocks[i2] = Blocks.field_150357_h;
                        continue;
                    }
                    if (block == Blocks.field_150350_a || block == TCBlockRegistry.tropicsWater) {
                        a = 0;
                        continue;
                    }
                    if (a >= 0 && a < 5) {
                        Object blockUsed = Blocks.field_150348_b;
                        if (a == 0 && l1 < 66) {
                            flag = true;
                        }
                        if (flag) {
                            if (a < 5) {
                                blockUsed = btop;
                            }
                        } else if (top != Blocks.field_150354_m) {
                            if (a == 0) {
                                blockUsed = top;
                            } else if (a < 5) {
                                blockUsed = filler;
                            }
                        }
                        blocks[i2] = blockUsed;
                        metas[i2] = (byte)sandMetadata;
                        ++a;
                        continue;
                    }
                    flag = false;
                    a = -1;
                }
                a = -1;
            }
        }
    }

    public void func_73153_a(IChunkProvider par1IChunkProvider, int i, int j) {
        BlockSand.field_149832_M = true;
        int x = i * 16;
        int z = j * 16;
        BiomeGenTropicraft biome = (BiomeGenTropicraft)this.worldObj.func_72959_q().func_76935_a(x, z);
        this.rand.setSeed(this.worldObj.func_72905_C());
        long l1 = this.rand.nextLong() / 2L * 2L + 1L;
        long l2 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)i * l1 + (long)j * l2 ^ this.worldObj.func_72905_C());
        biome.func_76728_a(this.worldObj, this.rand, x, z);
        this.generateOres(x, z);
        SpawnerAnimals.func_77191_a((World)this.worldObj, (BiomeGenBase)biome, (int)(x + 8), (int)(z + 8), (int)16, (int)16, (Random)this.rand);
        BlockSand.field_149832_M = false;
    }

    public void generateOres(int x, int z) {
        this.genStandardOre1(19, this.coalGen, 0, 128, x, z);
        this.genStandardOre1(10, this.ironGen, 0, 64, x, z);
        this.genStandardOre1(15, this.zirconGen, 0, 32, x, z);
        this.genStandardOre1(20, this.eudialyteGen, 0, 64, x, z);
        this.genStandardOre1(10, this.azuriteGen, 0, 128, x, z);
        this.genStandardOre2(1, this.lapisGen, 16, 16, x, z);
    }

    public void genStandardOre1(int i, WorldGenerator worldgenerator, int j, int k, int x, int z) {
        for (int l = 0; l < i; ++l) {
            int i1 = x + this.rand.nextInt(16);
            int j1 = this.rand.nextInt(k - j) + j;
            int k1 = z + this.rand.nextInt(16);
            worldgenerator.func_76484_a(this.worldObj, this.rand, i1, j1, k1);
        }
    }

    public void genStandardOre2(int i, WorldGenerator worldgenerator, int j, int k, int x, int z) {
        for (int l = 0; l < i; ++l) {
            int i1 = x + this.rand.nextInt(16);
            int j1 = this.rand.nextInt(k) + this.rand.nextInt(k) + (j - k);
            int k1 = z + this.rand.nextInt(16);
            worldgenerator.func_76484_a(this.worldObj, this.rand, i1, j1, k1);
        }
    }

    int getTerrainHeightAt(int x, int z) {
        for (int y = 256; y > 0; --y) {
            Block block = this.worldObj.func_147439_a(x, y, z);
            if (block != Blocks.field_150346_d && block != Blocks.field_150349_c && block != Blocks.field_150354_m && block != Blocks.field_150348_b) continue;
            return y + 1;
        }
        return 0;
    }

    public String func_73148_d() {
        return "TropiLevelSource";
    }

    public boolean func_73149_a(int x, int z) {
        return true;
    }

    public Chunk func_73158_c(int x, int z) {
        return this.func_73154_d(x, z);
    }

    public boolean func_73151_a(boolean flag, IProgressUpdate iprogressupdate) {
        return true;
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public List func_73155_a(EnumCreatureType par1EnumCreatureType, int par2, int par3, int par4) {
        BiomeGenBase biomegenbase = this.worldObj.func_72807_a(par2, par4);
        return biomegenbase == null ? null : biomegenbase.func_76747_a(par1EnumCreatureType);
    }

    public ChunkPosition func_147416_a(World world, String s, int i, int j, int k) {
        return null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int i, int j) {
    }

    public void func_104112_b() {
    }
}

