/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.world;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.LongHashMap;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;
import net.tropicraft.block.tileentity.TileEntityBambooChest;
import net.tropicraft.registry.TCBlockRegistry;
import net.tropicraft.registry.TCItemRegistry;
import net.tropicraft.world.WorldProviderTropicraft;

public class TeleporterTropics
extends Teleporter {
    private static Block PORTAL_WALL_BLOCK;
    private static Block PORTAL_BLOCK;
    private final WorldServer world;
    private final Random random;
    private final LongHashMap destinationCoordinateCache = new LongHashMap();
    private final List destinationCoordinateKeys = new ArrayList();

    public TeleporterTropics(WorldServer world) {
        super(world);
        PORTAL_BLOCK = TCBlockRegistry.tropicsPortal;
        PORTAL_WALL_BLOCK = TCBlockRegistry.tropicsPortalWall;
        this.world = world;
        this.random = new Random(world.func_72905_C());
    }

    public void func_77185_a(Entity entity, double d, double d2, double d3, float f) {
        long startTime = System.currentTimeMillis();
        if (!this.func_77184_b(entity, d, d2, d3, f)) {
            this.func_85188_a(entity);
            this.func_77184_b(entity, d, d2, d3, f);
        }
        long finishTime = System.currentTimeMillis();
        System.out.printf("It took %f seconds for TeleporterTropics.placeInPortal to complete\n", Float.valueOf((float)(finishTime - startTime) / 1000.0f));
    }

    public boolean func_77184_b(Entity entity, double d, double d2, double d3, float f) {
        int searchArea = 148;
        double closestPortal = -1.0;
        int foundX = 0;
        int foundY = 0;
        int foundZ = 0;
        int entityX = MathHelper.func_76128_c((double)entity.field_70165_t);
        int entityZ = MathHelper.func_76128_c((double)entity.field_70161_v);
        boolean notInCache = true;
        long j1 = ChunkCoordIntPair.func_77272_a((int)entityX, (int)entityZ);
        if (this.destinationCoordinateCache.func_76161_b(j1)) {
            Teleporter.PortalPosition portalposition = (Teleporter.PortalPosition)this.destinationCoordinateCache.func_76164_a(j1);
            closestPortal = 0.0;
            foundX = portalposition.field_71574_a;
            foundY = portalposition.field_71572_b;
            foundZ = portalposition.field_71573_c;
            portalposition.field_85087_d = this.world.func_82737_E();
            notInCache = false;
        } else {
            for (int x = entityX - searchArea; x <= entityX + searchArea; ++x) {
                double distX = (double)x + 0.5 - entity.field_70165_t;
                for (int z = entityZ - searchArea; z <= entityZ + searchArea; ++z) {
                    double distZ = (double)z + 0.5 - entity.field_70161_v;
                    for (int y = this.world.func_72940_L() - 1; y >= 0; --y) {
                        if (this.world.func_147439_a(x, y, z) != PORTAL_BLOCK) continue;
                        while (this.world.func_147439_a(x, y - 1, z) == PORTAL_BLOCK) {
                            --y;
                        }
                        double distY = (double)y + 0.5 - entity.field_70163_u;
                        double distance = distX * distX + distY * distY + distZ * distZ;
                        if (!(closestPortal < 0.0) && !(distance < closestPortal)) continue;
                        closestPortal = distance;
                        foundX = x;
                        foundY = y;
                        foundZ = z;
                    }
                }
            }
        }
        if (closestPortal >= 0.0) {
            if (notInCache) {
                this.destinationCoordinateCache.func_76163_a(j1, (Object)new Teleporter.PortalPosition((Teleporter)this, foundX, foundY, foundZ, this.world.func_82737_E()));
                this.destinationCoordinateKeys.add(j1);
            }
            int x = foundX;
            int y = foundY;
            int z = foundZ;
            double newLocX = (double)x + 0.5;
            double newLocY = (double)y + 0.5;
            double newLocZ = (double)z + 0.5;
            if (this.world.func_147439_a(x - 1, y, z) == PORTAL_BLOCK) {
                newLocX -= 0.5;
            }
            if (this.world.func_147439_a(x + 1, y, z) == PORTAL_BLOCK) {
                newLocX += 0.5;
            }
            if (this.world.func_147439_a(x, y, z - 1) == PORTAL_BLOCK) {
                newLocZ -= 0.5;
            }
            if (this.world.func_147439_a(x, y, z + 1) == PORTAL_BLOCK) {
                newLocZ += 0.5;
            }
            entity.func_70012_b(newLocX, newLocY + 2.0, newLocZ, entity.field_70177_z, 0.0f);
            int worldSpawnX = MathHelper.func_76128_c((double)newLocX);
            int worldSpawnZ = MathHelper.func_76128_c((double)newLocZ);
            int worldSpawnY = this.world.func_72976_f(worldSpawnX, worldSpawnZ) + 3;
            entity.field_70179_y = 0.0;
            entity.field_70181_x = 0.0;
            entity.field_70159_w = 0.0;
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                if (this.world.field_73011_w instanceof WorldProviderTropicraft && !player.field_71071_by.func_146028_b(TCItemRegistry.encTropica)) {
                    TileEntityBambooChest chest = null;
                    int chestX = MathHelper.func_76128_c((double)newLocX);
                    int chestZ = MathHelper.func_76128_c((double)newLocZ);
                    block4: for (int searchX = -3; searchX < 4; ++searchX) {
                        for (int searchZ = -3; searchZ < 4; ++searchZ) {
                            for (int searchY = -4; searchY < 5; ++searchY) {
                                if (this.world.func_147439_a(chestX + searchX, worldSpawnY + searchY, chestZ + searchZ) == TCBlockRegistry.bambooChest && (chest = (TileEntityBambooChest)this.world.func_147438_o(chestX + searchX, worldSpawnY + searchY, chestZ + searchZ)) != null && chest.isUnbreakable()) break block4;
                            }
                        }
                    }
                    if (chest != null && chest.isUnbreakable()) {
                        int inv;
                        boolean hasEncyclopedia = false;
                        for (inv = 0; inv < chest.func_70302_i_(); ++inv) {
                            ItemStack stack = chest.func_70301_a(inv);
                            if (stack == null || stack.func_77973_b() != TCItemRegistry.encTropica) continue;
                            hasEncyclopedia = true;
                        }
                        if (!hasEncyclopedia) {
                            for (inv = 0; inv < chest.func_70302_i_(); ++inv) {
                                ItemStack stack = chest.func_70301_a(inv);
                                if (stack != null) continue;
                                chest.func_70299_a(inv, new ItemStack(TCItemRegistry.encTropica, 1));
                                break;
                            }
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_85188_a(Entity entity) {
        int searchArea = 16;
        double closestSpot = -1.0;
        int entityX = MathHelper.func_76128_c((double)entity.field_70165_t);
        int entityY = MathHelper.func_76128_c((double)entity.field_70163_u);
        int entityZ = MathHelper.func_76128_c((double)entity.field_70161_v);
        int foundX = entityX;
        int foundY = entityY;
        int foundZ = entityZ;
        for (int x = entityX - searchArea; x <= entityX + searchArea; ++x) {
            double distX = (double)x + 0.5 - entity.field_70165_t;
            block1: for (int z = entityZ - searchArea; z <= entityZ + searchArea; ++z) {
                int y;
                double distZ = (double)z + 0.5 - entity.field_70161_v;
                for (y = this.world.func_72800_K() - 1; !(y < 62 || this.world.func_147439_a(x, y, z) != Blocks.field_150350_a && this.world.func_147439_a(x, y, z).func_149662_c()); --y) {
                }
                if (y > 83 || y < 63 || !this.getValidBuildBlocks().contains(this.world.func_147439_a(x, y, z))) continue;
                for (int xOffset = -2; xOffset <= 2; ++xOffset) {
                    for (int zOffset = -2; zOffset <= 2; ++zOffset) {
                        int otherY;
                        for (otherY = this.world.func_72800_K() - 1; !(otherY < 63 || this.world.func_147439_a(x + xOffset, otherY, z + zOffset) != Blocks.field_150350_a && this.world.func_147439_a(x, y, z).func_149662_c()); --otherY) {
                        }
                        if (Math.abs(y - otherY) >= 3 || !this.getValidBuildBlocks().contains(this.world.func_147439_a(x + xOffset, otherY, z + zOffset))) continue block1;
                    }
                }
                double distY = (double)y + 0.5 - entity.field_70163_u;
                double distance = distX * distX + distY * distY + distZ * distZ;
                if (!(closestSpot < 0.0) && !(distance < closestSpot)) continue;
                closestSpot = distance;
                foundX = x;
                foundY = y;
                foundZ = z;
            }
        }
        int worldSpawnX = MathHelper.func_76128_c((double)foundX);
        int worldSpawnZ = MathHelper.func_76128_c((double)foundZ);
        int worldSpawnY = this.getTerrainHeightAt(worldSpawnX, worldSpawnZ);
        if (closestSpot < 0.0) {
            foundY = worldSpawnY - 2;
        }
        entity.func_70012_b((double)foundX, (double)(foundY + 2), (double)foundZ, entity.field_70177_z, 0.0f);
        this.buildTeleporterAt(worldSpawnX, worldSpawnY + 1, worldSpawnZ, entity);
        return true;
    }

    public int getTerrainHeightAt(int x, int z) {
        for (int y = 100; y > 0; --y) {
            Block block = this.world.func_147439_a(x, y, z);
            if (block != Blocks.field_150346_d && block != Blocks.field_150349_c && block != Blocks.field_150354_m && block != Blocks.field_150348_b && block != TCBlockRegistry.tropicsWater && block != TCBlockRegistry.purifiedSand) continue;
            return y;
        }
        return 0;
    }

    public void buildTeleporterAt(int x, int y, int z, Entity entity) {
        int blockZ;
        int blockY;
        int blockX;
        int xOffset;
        int zOffset;
        int yOffset;
        y = y < 9 ? 9 : y;
        for (yOffset = 4; yOffset >= -7; --yOffset) {
            for (zOffset = -2; zOffset <= 2; ++zOffset) {
                for (xOffset = -2; xOffset <= 2; ++xOffset) {
                    boolean isCorner;
                    blockX = x + xOffset;
                    blockY = y + yOffset;
                    blockZ = z + zOffset;
                    if (yOffset == -7) {
                        this.world.func_147449_b(blockX, blockY, blockZ, PORTAL_WALL_BLOCK);
                    } else if (yOffset > 0) {
                        this.world.func_147449_b(blockX, blockY, blockZ, Blocks.field_150350_a);
                    } else {
                        boolean isWall;
                        boolean bl = isWall = xOffset == -2 || xOffset == 2 || zOffset == -2 || zOffset == 2;
                        if (isWall) {
                            this.world.func_147449_b(blockX, blockY, blockZ, PORTAL_WALL_BLOCK);
                        } else {
                            int metadata = yOffset <= -5 ? 8 : 0;
                            this.world.func_147465_d(blockX, blockY, blockZ, PORTAL_BLOCK, metadata, 3);
                        }
                    }
                    boolean bl = isCorner = !(xOffset != -2 && xOffset != 2 || zOffset != -2 && zOffset != 2);
                    if (yOffset != 0 || !isCorner) continue;
                    this.world.func_147465_d(blockX, blockY + 1, blockZ, (Block)TCBlockRegistry.tikiTorch, 1, 3);
                    this.world.func_147465_d(blockX, blockY + 2, blockZ, (Block)TCBlockRegistry.tikiTorch, 1, 3);
                    this.world.func_147465_d(blockX, blockY + 3, blockZ, (Block)TCBlockRegistry.tikiTorch, 0, 3);
                }
            }
        }
        if (this.world.field_73011_w instanceof WorldProviderTropicraft) {
            this.world.func_147465_d(x + 2, y + 1, z, (Block)TCBlockRegistry.bambooChest, 1, 3);
            TileEntityBambooChest tile = (TileEntityBambooChest)this.world.func_147438_o(x + 2, y + 1, z);
            if (tile != null) {
                tile.setIsUnbreakable(true);
            }
        }
        for (yOffset = 5; yOffset >= -7; --yOffset) {
            for (zOffset = -2; zOffset <= 2; ++zOffset) {
                for (xOffset = -2; xOffset <= 2; ++xOffset) {
                    blockX = x + xOffset;
                    blockY = y + yOffset;
                    blockZ = z + zOffset;
                    this.world.func_147459_d(blockX, blockY, blockZ, this.world.func_147439_a(blockX, blockY, blockZ));
                }
            }
        }
    }

    public void func_85189_a(long par1) {
        if (par1 % 100L == 0L) {
            Iterator iterator = this.destinationCoordinateKeys.iterator();
            long j = par1 - 600L;
            while (iterator.hasNext()) {
                Long olong = (Long)iterator.next();
                Teleporter.PortalPosition portalposition = (Teleporter.PortalPosition)this.destinationCoordinateCache.func_76164_a(olong.longValue());
                if (portalposition != null && portalposition.field_85087_d >= j) continue;
                iterator.remove();
                this.destinationCoordinateCache.func_76159_d(olong.longValue());
            }
        }
    }

    private List<Block> getValidBuildBlocks() {
        return Arrays.asList(Blocks.field_150354_m, Blocks.field_150349_c, Blocks.field_150346_d, TCBlockRegistry.purifiedSand);
    }
}

