/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.tropicraft.block.BlockBambooMug;
import net.tropicraft.block.tileentity.TileEntityBambooMug;
import net.tropicraft.drinks.ColorMixer;
import net.tropicraft.drinks.Drink;
import net.tropicraft.drinks.Ingredient;
import net.tropicraft.drinks.MixerRecipe;
import net.tropicraft.item.ItemTropicraft;
import net.tropicraft.registry.TCBlockRegistry;
import net.tropicraft.registry.TCCreativeTabRegistry;
import net.tropicraft.registry.TCDrinkMixerRegistry;
import net.tropicraft.registry.TCItemRegistry;

public class ItemCocktail
extends ItemTropicraft {
    private static final int DEFAULT_COLOR = 15973942;
    private IIcon contentsIcon;

    public ItemCocktail(CreativeTabs tabs) {
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77637_a(TCCreativeTabRegistry.tabFood);
        this.func_77642_a(TCItemRegistry.bambooMug);
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        if (par1ItemStack.field_77990_d == null) {
            return;
        }
        NBTTagList ingredients = par1ItemStack.field_77990_d.func_150295_c("Ingredients", 10);
        for (int i = 0; i < ingredients.func_74745_c(); ++i) {
            NBTTagCompound ingredient = ingredients.func_150305_b(i);
            byte id = ingredient.func_74771_c("IngredientID");
            String ingredientName = Ingredient.ingredientsList[id].getIngredient().func_82833_r();
            int ingredientColor = Ingredient.ingredientsList[id].getColor();
            par3List.add(ingredientName);
        }
        Drink drink = Drink.drinkList[par1ItemStack.field_77990_d.func_74771_c("DrinkID")];
        if (drink != null) {
            par3List.add("\u00a7o" + drink.displayName);
        }
    }

    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List list) {
        for (MixerRecipe recipe : TCDrinkMixerRegistry.getInstance().getRecipes()) {
            list.add(ItemCocktail.makeCocktail(recipe));
        }
    }

    public boolean func_77651_p() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int par1, int par2) {
        return par2 == 0 ? this.field_77791_bV : this.contentsIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack par1ItemStack, int par2) {
        if (par2 == 0) {
            return 0xFFFFFF;
        }
        return ItemCocktail.getCocktailColor(par1ItemStack);
    }

    public static int getCocktailColor(ItemStack stack) {
        if (stack.field_77990_d != null) {
            if (stack.field_77990_d.func_74764_b("Color")) {
                return stack.field_77990_d.func_74762_e("Color");
            }
            return 15973942;
        }
        return 15973942;
    }

    public static ItemStack makeCocktail(MixerRecipe recipe) {
        ItemStack stack = new ItemStack(TCItemRegistry.cocktail);
        NBTTagCompound nbt = new NBTTagCompound();
        Drink drink = recipe.getCraftingResult();
        nbt.func_74774_a("DrinkID", (byte)drink.drinkId);
        NBTTagList tagList = new NBTTagList();
        Ingredient primary = null;
        LinkedList<Ingredient> additives = new LinkedList<Ingredient>();
        for (Ingredient ingredient : recipe.getIngredients()) {
            NBTTagCompound ingredientNbt = new NBTTagCompound();
            ingredientNbt.func_74774_a("IngredientID", (byte)ingredient.ingredientId);
            tagList.func_74742_a((NBTBase)ingredientNbt);
            if (ingredient.isPrimary()) {
                primary = ingredient;
                continue;
            }
            additives.add(ingredient);
        }
        nbt.func_74782_a("Ingredients", (NBTBase)tagList);
        int color = primary == null ? 15973942 : primary.getColor();
        for (Ingredient additive : additives) {
            color = ColorMixer.getInstance().alphaBlendRGBA(color, additive.getColor(), additive.getAlpha());
        }
        nbt.func_74768_a("Color", color);
        stack.field_77990_d = nbt;
        return stack;
    }

    public static ItemStack makeCocktail(Ingredient[] ingredients) {
        ItemStack stack = new ItemStack(TCItemRegistry.cocktail);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("DrinkID", (byte)0);
        NBTTagList tagList = new NBTTagList();
        Ingredient primary = null;
        LinkedList<Ingredient> additives = new LinkedList<Ingredient>();
        for (Ingredient ingredient : ingredients) {
            NBTTagCompound ingredientNbt = new NBTTagCompound();
            ingredientNbt.func_74774_a("IngredientID", (byte)ingredient.ingredientId);
            tagList.func_74742_a((NBTBase)ingredientNbt);
            if (ingredient.isPrimary()) {
                primary = ingredient;
                continue;
            }
            additives.add(ingredient);
        }
        nbt.func_74782_a("Ingredients", (NBTBase)tagList);
        int color = primary == null ? 15973942 : primary.getColor();
        for (Ingredient additive : additives) {
            color = ColorMixer.getInstance().alphaBlendRGBA(color, additive.getColor(), additive.getAlpha());
        }
        nbt.func_74768_a("Color", color);
        stack.field_77990_d = nbt;
        return stack;
    }

    public static Ingredient[] getIngredients(ItemStack stack) {
        if (stack.func_77973_b() != TCItemRegistry.cocktail || !stack.func_77942_o()) {
            return new Ingredient[0];
        }
        NBTTagCompound nbt = stack.func_77978_p();
        NBTTagList tagList = nbt.func_150295_c("Ingredients", 10);
        Ingredient[] ingredients = new Ingredient[tagList.func_74745_c()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            byte id = tagList.func_150305_b(i).func_74771_c("IngredientID");
            ingredients[i] = Ingredient.ingredientsList[id];
        }
        return ingredients;
    }

    public static Drink getDrink(ItemStack stack) {
        if (stack.func_77973_b() != TCItemRegistry.cocktail || !stack.func_77942_o()) {
            return null;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        return Drink.drinkList[nbt.func_74771_c("DrinkID")];
    }

    public boolean func_77648_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int par4, int par5, int par6, int par7, float par8, float par9, float par10) {
        Block var11 = par3World.func_147439_a(par4, par5, par6);
        if (var11 == Blocks.field_150433_aE) {
            par7 = 1;
        } else if (!(var11 == Blocks.field_150395_bd || var11 == Blocks.field_150329_H || var11 == Blocks.field_150330_I || var11 != null && var11.isReplaceable((IBlockAccess)par3World, par4, par5, par6))) {
            if (par7 == 0) {
                --par5;
            } else if (par7 == 1) {
                ++par5;
            } else if (par7 == 2) {
                --par6;
            } else if (par7 == 3) {
                ++par6;
            } else if (par7 == 4) {
                --par4;
            } else if (par7 == 5) {
                ++par4;
            }
        }
        if (!par2EntityPlayer.func_82247_a(par4, par5, par6, par7, par1ItemStack)) {
            return false;
        }
        if (par3World.func_147472_a((Block)TCBlockRegistry.bambooMug, par4, par5, par6, false, par7, (Entity)par2EntityPlayer, null)) {
            BlockBambooMug var12 = TCBlockRegistry.bambooMug;
            int var13 = this.func_77647_b(par1ItemStack.func_77960_j());
            int var14 = var12.func_149660_a(par3World, par4, par5, par6, par7, par8, par9, par10, var13);
            if (this.placeBlockAt(par1ItemStack, par2EntityPlayer, par3World, par4, par5, par6, par7, par8, par9, par10, var14)) {
                par3World.func_72908_a((double)((float)par4 + 0.5f), (double)((float)par5 + 0.5f), (double)((float)par6 + 0.5f), ((Block)var12).field_149762_H.func_150496_b(), (((Block)var12).field_149762_H.func_150497_c() + 1.0f) / 2.0f, ((Block)var12).field_149762_H.func_150494_d() * 0.8f);
                --par1ItemStack.field_77994_a;
            }
            return true;
        }
        return false;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        if (!world.func_147465_d(x, y, z, (Block)TCBlockRegistry.bambooMug, metadata, 2)) {
            return false;
        }
        if (world.func_147439_a(x, y, z) == TCBlockRegistry.bambooMug) {
            TCBlockRegistry.bambooMug.func_149689_a(world, x, y, z, (EntityLivingBase)player, null);
            TCBlockRegistry.bambooMug.func_149714_e(world, x, y, z, metadata);
            TileEntityBambooMug mug = (TileEntityBambooMug)world.func_147438_o(x, y, z);
            mug.setCocktail(stack.func_77946_l());
            int var6 = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            int meta = 2;
            if (var6 == 0) {
                meta = 2;
            } else if (var6 == 1) {
                meta = 5;
            } else if (var6 == 2) {
                meta = 3;
            } else if (var6 == 3) {
                meta = 4;
            }
            world.func_72921_c(x, y, z, meta, 2);
        }
        return true;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.drink;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        Drink drink = ItemCocktail.getDrink(par1ItemStack);
        if (drink != null ? !par3EntityPlayer.func_71043_e(drink.alwaysEdible) : !par3EntityPlayer.func_71043_e(false)) {
            return par1ItemStack;
        }
        par3EntityPlayer.func_71008_a(par1ItemStack, this.func_77626_a(par1ItemStack));
        return par1ItemStack;
    }

    public ItemStack func_77654_b(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        par2World.func_72956_a((Entity)par3EntityPlayer, "random.burp", 0.5f, par2World.field_73012_v.nextFloat() * 0.1f + 0.9f);
        for (Ingredient ingredient : ItemCocktail.getIngredients(par1ItemStack)) {
            ingredient.onDrink(par3EntityPlayer);
        }
        Drink drink = ItemCocktail.getDrink(par1ItemStack);
        if (drink != null) {
            drink.onDrink(par3EntityPlayer);
        }
        return new ItemStack(TCItemRegistry.bambooMug);
    }

    @Override
    public void func_94581_a(IIconRegister iconRegistry) {
        super.func_94581_a(iconRegistry);
        this.contentsIcon = iconRegistry.func_94245_a(this.func_77658_a().substring(this.func_77658_a().indexOf(".") + 1) + "contents");
    }
}

