/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.event;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.tropicraft.item.tool.IUnderwaterTool;
import net.tropicraft.item.tool.ItemUnderwaterShovel;
import net.tropicraft.registry.TCBlockRegistry;
import net.tropicraft.registry.TCFluidRegistry;
import net.tropicraft.registry.TCItemRegistry;

public class TCItemEvents {
    @SubscribeEvent
    public void handleBucketFillEvent(FillBucketEvent event) {
        ItemStack iHazBucket = new ItemStack((Item)TCItemRegistry.bucketTropicsWater);
        World world = event.world;
        int x = event.target.field_72311_b;
        int y = event.target.field_72312_c;
        int z = event.target.field_72309_d;
        int meta = world.func_72805_g(x, y, z);
        Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)world.func_147439_a(x, y, z));
        if (fluid != null && fluid == TCFluidRegistry.tropicsWater && meta == 0) {
            TCItemRegistry.bucketTropicsWater.fill(iHazBucket, new FluidStack(fluid, 1000), true);
            world.func_147468_f(x, y, z);
            event.result = iHazBucket;
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void changeTropicsWaterFogDensity(EntityViewRenderEvent.FogDensity event) {
        int x = MathHelper.func_76128_c((double)event.entity.field_70165_t);
        int y = MathHelper.func_76143_f((double)(event.entity.field_70163_u + (double)event.entity.field_70131_O - 0.5));
        int z = MathHelper.func_76128_c((double)event.entity.field_70161_v);
        if (event.block.func_149688_o().func_76224_d() && event.block.func_149739_a().equals(TCBlockRegistry.tropicsWater.func_149739_a())) {
            event.density = 0.0115f;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void changeTropicsWaterFogColor(EntityViewRenderEvent.FogColors event) {
        int x = MathHelper.func_76128_c((double)event.entity.field_70165_t);
        int y = MathHelper.func_76143_f((double)(event.entity.field_70163_u + (double)event.entity.field_70131_O - 0.5));
        int z = MathHelper.func_76128_c((double)event.entity.field_70161_v);
        if (event.block.func_149688_o().func_76224_d() && event.block.func_149739_a().equals(TCBlockRegistry.tropicsWater.func_149739_a())) {
            event.red = 0.2f;
            event.green = 0.8f;
            event.blue = 0.5f;
        }
    }

    @SubscribeEvent
    public void handleUnderwaterTools(PlayerEvent.BreakSpeed event) {
        EntityPlayer player = event.entityPlayer;
        ItemStack itemstack = player.func_70694_bm();
        if (itemstack != null && itemstack.func_77973_b() != null && itemstack.func_77973_b() instanceof IUnderwaterTool) {
            if (this.isFullyUnderwater(player.field_70170_p, player)) {
                event.newSpeed = event.originalSpeed * (player.field_70122_E ? 5.0f : 10.0f);
            } else {
                event.newSpeed = event.originalSpeed / 14.0f;
                if (itemstack.func_77973_b() instanceof ItemUnderwaterShovel) {
                    event.newSpeed /= 5.0f;
                }
            }
        }
    }

    private boolean isFullyUnderwater(World world, EntityPlayer player) {
        return player.func_70055_a(Material.field_151586_h);
    }
}

