/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.entity.hostile;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.tropicraft.entity.hostile.AIAshenChaseAndPickupLostMask;
import net.tropicraft.entity.hostile.EntityAIMeleeAndRangedAttack;
import net.tropicraft.entity.hostile.EntityLostMask;

public abstract class EntityAshen
extends EntityMob
implements IRangedAttackMob {
    public static final int DATAWATCHER_MASK_TYPE = 16;
    public static final int DATAWATCHER_ACTION_STATE = 17;
    public float bobber;
    public int bobberHelper;
    public int actionPicker;
    public EntityLostMask maskToTrack;
    public Entity itemToTrack;

    public EntityAshen(World par1World) {
        super(par1World);
        this.func_70105_a(0.5f, 1.3f);
        this.setMaskType(new Random().nextInt(7));
        this.actionPicker = 0;
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIAshenChaseAndPickupLostMask(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMeleeAndRangedAttack(this, 1.0, 60, 5.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(17, (Object)new Integer(0));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.getAttackStrength());
    }

    protected abstract double getAttackStrength();

    public boolean func_70650_aV() {
        return true;
    }

    public void setMaskType(int type) {
        this.field_70180_af.func_75692_b(16, (Object)new Integer(type));
    }

    public int getMaskType() {
        return this.field_70180_af.func_75679_c(16);
    }

    public void setActionState(int state) {
        this.field_70180_af.func_75692_b(17, (Object)new Integer(state));
    }

    public int getActionState() {
        return this.field_70180_af.func_75679_c(17);
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74777_a("MaskType", (short)this.getMaskType());
        nbttagcompound.func_74777_a("ActionState", (short)this.getActionState());
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setMaskType(nbttagcompound.func_74765_d("MaskType"));
        this.setActionState(nbttagcompound.func_74765_d("ActionState"));
    }

    public boolean hasMask() {
        int ac = this.getActionState();
        return this.getActionState() != 1;
    }

    public void dropMask() {
        this.setActionState(1);
        this.maskToTrack = new EntityLostMask(this.field_70170_p, this.getMaskType(), this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z);
        this.field_70170_p.func_72838_d((Entity)this.maskToTrack);
    }

    public void pickupMask(EntityLostMask mask) {
        this.setActionState(2);
        this.maskToTrack = null;
        this.setMaskType(mask.type);
        mask.func_70106_y();
    }

    protected String tcSound(String postfix) {
        return String.format("%s:%s", "tropicraft", postfix);
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        boolean wasHit = super.func_70097_a(p_70097_1_, p_70097_2_);
        if (!this.field_70170_p.field_72995_K && this.hasMask() && wasHit) {
            this.dropMask();
        }
        return wasHit;
    }
}

