/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.client.entity.model;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.tropicraft.entity.underdasea.EntityEagleRay;
import org.lwjgl.opengl.GL11;

public class ModelEagleRay
extends ModelBase {
    private float[] interpolatedWingAmplitudes = new float[10];
    private ModelRenderer body;

    public ModelEagleRay() {
        this.field_78090_t = 128;
        this.field_78089_u = 64;
        this.body = new ModelRenderer((ModelBase)this, 32, 0);
        this.body.func_78789_a(-2.0f, 0.0f, 0.0f, 5, 3, 32);
        this.body.func_78793_a(0.0f, 0.0f, -8.0f);
        this.body.func_78787_b(128, 64);
        this.body.field_78809_i = true;
    }

    public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
        this.func_78087_a(f, f1, f2, f3, f4, f5, entity);
        this.body.func_78785_a(f5);
        this.renderWings();
        this.renderTailSimple();
    }

    private void renderTailSimple() {
        Tessellator tessellator = Tessellator.field_78398_a;
        float minU = 0.75f;
        float maxU = 1.0f;
        float minV = 0.0f;
        float maxV = 0.5f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.55f, (float)0.0f, (float)1.5f);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glScalef((float)1.5f, (float)1.0f, (float)1.0f);
        tessellator.func_78382_b();
        tessellator.func_78374_a(0.0, 0.0, 0.0, (double)minU, (double)minV);
        tessellator.func_78374_a(0.0, 0.0, 1.0, (double)minU, (double)maxV);
        tessellator.func_78374_a(1.0, 0.0, 1.0, (double)maxU, (double)maxV);
        tessellator.func_78374_a(1.0, 0.0, 0.0, (double)maxU, (double)minV);
        tessellator.func_78381_a();
        GL11.glPopMatrix();
    }

    private void renderWings() {
        GL11.glDisable((int)2896);
        GL11.glPushMatrix();
        GL11.glScalef((float)2.0f, (float)0.5f, (float)2.0f);
        GL11.glTranslatef((float)0.1f, (float)0.0f, (float)-0.25f);
        this.renderWing(false);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.1f, (float)0.0f, (float)-1.0f);
        this.renderWing(true);
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
    }

    private void renderWing(boolean reverse) {
        Tessellator tessellator = Tessellator.field_78398_a;
        float minUFront = 0.0f;
        float maxUFront = 0.25f;
        float minVFront = 0.0f;
        float maxVFront = 0.5f;
        float minUBack = 0.0f;
        float maxUBack = 0.25f;
        float minVBack = 0.5f;
        float maxVBack = 1.0f;
        for (int i = 1; i < 10; ++i) {
            float prevAmplitude = this.interpolatedWingAmplitudes[i - 1];
            float amplitude = this.interpolatedWingAmplitudes[i];
            float prevX = (float)(i - 1) / 9.0f;
            float x = (float)i / 9.0f;
            float prevUFront = minUFront + (maxUFront - minUFront) * prevX;
            float uFront = minUFront + (maxUFront - minUFront) * x;
            float prevUBack = minUBack + (maxUBack - minUBack) * prevX;
            float uBack = minUBack + (maxUBack - minUBack) * x;
            float offset = -0.001f;
            tessellator.func_78382_b();
            tessellator.func_78374_a((double)x, (double)(amplitude - offset), 0.0, (double)uBack, reverse ? (double)maxVBack : (double)minVBack);
            tessellator.func_78374_a((double)x, (double)(amplitude - offset), 1.0, (double)uBack, reverse ? (double)minVBack : (double)maxVBack);
            tessellator.func_78374_a((double)prevX, (double)(prevAmplitude - offset), 1.0, (double)prevUBack, reverse ? (double)minVBack : (double)maxVBack);
            tessellator.func_78374_a((double)prevX, (double)(prevAmplitude - offset), 0.0, (double)prevUBack, reverse ? (double)maxVBack : (double)minVBack);
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78374_a((double)prevX, (double)prevAmplitude, 0.0, (double)prevUFront, reverse ? (double)maxVFront : (double)minVFront);
            tessellator.func_78374_a((double)prevX, (double)prevAmplitude, 1.0, (double)prevUFront, reverse ? (double)minVFront : (double)maxVFront);
            tessellator.func_78374_a((double)x, (double)amplitude, 1.0, (double)uFront, reverse ? (double)minVFront : (double)maxVFront);
            tessellator.func_78374_a((double)x, (double)amplitude, 0.0, (double)uFront, reverse ? (double)maxVFront : (double)minVFront);
            tessellator.func_78381_a();
        }
    }

    private float lerp(float start, float end, float partialTicks) {
        return start + (end - start) * partialTicks;
    }

    public void func_78086_a(EntityLivingBase entityLiving, float par2, float par3, float partialTicks) {
        EntityEagleRay ray = (EntityEagleRay)entityLiving;
        float[] prevWingAmplitudes = ray.getPrevWingAmplitudes();
        float[] wingAmplitudes = ray.getWingAmplitudes();
        for (int i = 1; i < 10; ++i) {
            float prevWingAmplitude = prevWingAmplitudes[i];
            float wingAmplitude = wingAmplitudes[i];
            this.interpolatedWingAmplitudes[i] = prevWingAmplitude + partialTicks * (wingAmplitude - prevWingAmplitude);
        }
    }

    private void setRotation(ModelRenderer model, float x, float y, float z) {
        model.field_78795_f = x;
        model.field_78796_g = y;
        model.field_78808_h = z;
    }
}

