/*
 * Decompiled with CFR 0.152.
 */
package es.razzleberri.hamsterrific;

import com.google.common.reflect.ClassPath;
import es.razzleberri.hamsterrific.Hamsterrific;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.potion.Potion;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;

public class EntityHamster
extends EntityTameable {
    public ItemStack heldItem;
    private int stackCount;
    private int eatCount;
    private int foodStackCount;
    private int standCount;
    private EntityItem targetFood;
    private boolean looksWithInterest;
    private boolean isStanding;
    private float field_25048_b;
    private float field_25054_c;
    private static List<String> hamsterColorList;
    private EntityPlayer givemeEntity;
    private int inLove;
    private int breeding;
    private ResourceLocation resourceLocation;

    public EntityHamster(World world) {
        super(world);
        this.func_70606_j(10.0f);
        this.field_70129_M = 0.2f;
        this.func_70105_a(0.3f, 0.3f);
        this.looksWithInterest = false;
        this.heldItem = null;
        this.stackCount = 20;
        this.eatCount = 5000;
        this.standCount = 30;
        this.isStanding = false;
        this.inLove = 0;
        this.breeding = 0;
        String texture = null;
        if (this.getHamsterColor() == "") {
            this.setHamsterColor(this.getRandomHamsterColor());
            texture = this.getHamsterColor();
            this.resourceLocation = new ResourceLocation(texture);
        }
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    private String getRandomHamsterColor() {
        this.hamsterColorInitialize();
        Collections.shuffle(hamsterColorList);
        return hamsterColorList.get(0);
    }

    private void hamsterColorInitialize() {
        if (hamsterColorList == null) {
            hamsterColorList = new ArrayList<String>();
            try {
                Pattern p = Pattern.compile("assets/minecraft/(mob/hamster/hamster_.*)");
                for (ClassPath.ResourceInfo i : ClassPath.from((ClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getResources()) {
                    Matcher m = p.matcher(i.getResourceName());
                    if (!m.matches()) continue;
                    String s = m.group(1);
                    hamsterColorList.add(s);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)"");
        this.field_70180_af.func_75682_a(19, (Object)0);
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("Angry", this.isHamsterAngry());
        nbttagcompound.func_74757_a("Sitting", this.isHamsterSitting());
        nbttagcompound.func_74757_a("InBall", this.isInBall());
        if (this.getHamsterOwner() == null) {
            nbttagcompound.func_74778_a("Owner", "");
        } else {
            nbttagcompound.func_74778_a("Owner", this.getHamsterOwner());
        }
        nbttagcompound.func_74778_a("Color", this.getHamsterColor());
        nbttagcompound.func_74768_a("foodStackCount", this.getFoodStackCount());
        nbttagcompound.func_74768_a("InLove", this.inLove);
        nbttagcompound.func_74768_a("BallColor", this.getBallColor());
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setHamsterAngry(nbttagcompound.func_74767_n("Angry"));
        this.setHamsterSitting(nbttagcompound.func_74767_n("Sitting"));
        this.setInBall(nbttagcompound.func_74767_n("InBall"));
        String s = nbttagcompound.func_74779_i("Owner");
        String s1 = nbttagcompound.func_74779_i("Color");
        if (s.length() > 0) {
            this.setHamsterOwner(s);
            this.setHamsterTamed(true);
        }
        this.hamsterColorInitialize();
        if (s1.length() > 0) {
            if (hamsterColorList.contains(s1)) {
                this.setHamsterColor(s1);
                this.resourceLocation = new ResourceLocation(s1);
            } else {
                this.func_70106_y();
            }
        }
        this.setFoodStackCount(nbttagcompound.func_74762_e("foodStackCount"));
        this.inLove = nbttagcompound.func_74762_e("InLove");
        this.setBallColor(nbttagcompound.func_74762_e("BallColor"));
    }

    protected boolean func_70692_ba() {
        return !this.isHamsterTamed();
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    public double func_70033_W() {
        return this.field_70129_M;
    }

    public boolean func_70085_c(EntityPlayer entityplayer) {
        ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
        if (itemstack != null && this.func_70877_b(itemstack) && this.func_70874_b() == 0) {
            if (this.field_70170_p.func_72912_H().func_76077_q() != WorldSettings.GameType.CREATIVE) {
                --itemstack.field_77994_a;
                if (itemstack.field_77994_a <= 0) {
                    entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, null);
                }
            }
            this.func_70624_b(null);
            this.setHamsterAngry(false);
            this.inLove = 600;
            this.field_70789_a = null;
            for (int i = 0; i < 7; ++i) {
                double d = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_72869_a("heart", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d, d1, d2);
            }
            return true;
        }
        if (!this.isHamsterTamed()) {
            if (itemstack != null && Item.func_150891_b((Item)itemstack.func_77973_b()) == Item.func_150891_b((Item)Hamsterrific.hamsterFood)) {
                this.addFoodStack();
                return this.interactSeedsNotTamed(itemstack, entityplayer);
            }
            return false;
        }
        if (itemstack != null && Item.func_150891_b((Item)itemstack.func_77973_b()) == Item.func_150891_b((Item)Hamsterrific.hamsterBall) && !this.isInBall()) {
            this.setInBall(true);
            this.setBallColor(itemstack.func_77960_j());
            itemstack.func_77972_a(1, (EntityLivingBase)entityplayer);
        }
        if (itemstack != null && Item.func_150891_b((Item)itemstack.func_77973_b()) == Item.func_150891_b((Item)Hamsterrific.hamsterFood)) {
            this.addFoodStack();
            return this.interactSeedsTamed(itemstack, entityplayer);
        }
        if (itemstack != null && Item.func_150891_b((Item)itemstack.func_77973_b()) == Item.func_150891_b((Item)Items.field_151121_aF)) {
            if (this.isInBall()) {
                this.setInBall(false);
                return true;
            }
            return this.interactPaperTamed(entityplayer);
        }
        return this.interactOthersTamed();
    }

    private boolean interactSeedsNotTamed(ItemStack itemstack, EntityPlayer entityplayer) {
        --itemstack.field_77994_a;
        if (itemstack.field_77994_a <= 0) {
            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, null);
        }
        if (!this.isHamsterAngry()) {
            if (this.field_70146_Z.nextInt(3) == 0) {
                this.setHamsterTamed(true);
                this.func_70778_a(null);
                this.setHamsterStanding(false);
                this.setHamsterSitting(true);
                this.func_70624_b(null);
                this.field_70703_bu = false;
                this.func_70606_j(10.0f);
                this.setHamsterOwner(entityplayer.getDisplayName());
                this.showHeartsOrSmokeFX("heart", 7, true);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            } else {
                this.showHeartsOrSmokeFX("smoke", 7, true);
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            }
        } else {
            if (this.field_70146_Z.nextInt(3) == 0) {
                this.setHamsterAngry(false);
                this.func_70778_a(null);
                this.field_70703_bu = false;
                this.func_70624_b(null);
                this.field_70789_a = null;
                this.showHeartsOrSmokeFX("note", 1, false);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            } else {
                this.showHeartsOrSmokeFX("smoke", 1, true);
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            }
            this.func_70691_i(1.0f);
        }
        return true;
    }

    private boolean interactSeedsTamed(ItemStack itemstack, EntityPlayer entityplayer) {
        --itemstack.field_77994_a;
        if (itemstack.field_77994_a <= 0) {
            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, null);
        }
        this.showHeartsOrSmokeFX("note", 1, false);
        this.func_70691_i(1.0f);
        return true;
    }

    private boolean interactPaperTamed(EntityPlayer entityplayer) {
        this.isRemoteMountEntity((Entity)entityplayer);
        return true;
    }

    private void isRemoteMountEntity(Entity par1Entity) {
        if (this.field_70154_o == par1Entity) {
            this.func_70012_b(this.field_70154_o.field_70165_t, this.field_70154_o.field_70121_D.field_72338_b + (double)this.field_70154_o.field_70131_O, this.field_70154_o.field_70161_v, this.field_70177_z, this.field_70125_A);
            this.field_70154_o = null;
        } else if (this.field_70154_o == null) {
            this.func_70078_a(par1Entity);
            this.field_70165_t = par1Entity.field_70165_t;
            this.field_70163_u = par1Entity.field_70121_D.field_72338_b + (double)this.field_70131_O;
            this.field_70161_v = par1Entity.field_70161_v;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        }
    }

    private boolean interactOthersTamed() {
        if (this.isHamsterStanding() || !this.isHamsterSitting()) {
            this.setHamsterSitting(true);
        } else if (this.isHamsterSitting()) {
            this.setHamsterSitting(false);
        }
        this.field_70703_bu = false;
        this.func_70778_a(null);
        this.func_70624_b(null);
        this.field_70789_a = null;
        return true;
    }

    protected void func_70626_be() {
        super.func_70626_be();
        if (this.targetFood != null) {
            this.actionToTargetFood();
        }
        if (this.func_70090_H()) {
            this.setHamsterSitting(false);
            this.setHamsterStanding(false);
        }
        if (this.isHamsterStanding() || this.isHamsterSitting()) {
            this.field_70787_b = false;
            this.field_70703_bu = false;
            this.func_70778_a(null);
            this.func_70624_b(null);
            this.field_70789_a = null;
        }
    }

    private void actionToTargetFood() {
        if (!this.field_70787_b && !this.func_70781_l() && !this.isHamsterAngry() && this.field_70154_o == null && this.targetFood.func_70089_S()) {
            float f = this.targetFood.func_70032_d((Entity)this);
            if (f > 1.0f) {
                PathEntity pathentity = this.field_70170_p.func_72865_a((Entity)this, (Entity)this.targetFood, 16.0f, true, false, false, true);
                this.func_70778_a(pathentity);
            } else if (f < 0.8f) {
                if (this.stackCount == 0) {
                    this.func_70778_a(null);
                    this.targetFood.func_70106_y();
                    this.targetFood = null;
                    this.addFoodStack();
                    this.showHeartsOrSmokeFX("heart", 1, false);
                    this.stackCount = 20;
                } else {
                    --this.stackCount;
                }
            }
        } else if (!this.targetFood.func_70089_S()) {
            this.targetFood = null;
            this.stackCount = 20;
        }
    }

    public void func_70691_i(float f) {
        super.func_70691_i(f);
        this.field_70172_ad = this.field_70771_an / 2;
    }

    public boolean func_70067_L() {
        ItemStack itemstack;
        if (this.field_70154_o != null && this.field_70154_o instanceof EntityPlayer && ((itemstack = ((EntityPlayer)this.field_70154_o).field_71071_by.func_70448_g()) == null || itemstack != null && Item.func_150891_b((Item)itemstack.func_77973_b()) != Item.func_150891_b((Item)Items.field_151121_aF))) {
            return false;
        }
        return super.func_70067_L();
    }

    public boolean func_70094_T() {
        if (this.field_70154_o != null) {
            return false;
        }
        return super.func_70094_T();
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        Entity var3 = par1DamageSource.func_76346_g();
        if (this.field_70154_o != null) {
            return false;
        }
        this.inLove = 0;
        this.setHamsterSitting(false);
        this.setHamsterStanding(false);
        if (var3 != null && !(var3 instanceof EntityPlayer) && !(var3 instanceof EntityArrow)) {
            par2 = (par2 + 1.0f) / 2.0f;
        }
        Entity entity = var3;
        try {
            Field field = null;
            try {
                field = EntityLiving.class.getDeclaredField("bu");
            }
            catch (Exception exception1) {
                field = EntityLiving.class.getDeclaredField("currentTarget");
            }
            if (field != null) {
                field.setAccessible(true);
                entity = (Entity)field.get((Object)this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (entity != null && entity instanceof EntityPlayer && this.givemeEntity == null) {
            this.givemeEntity = (EntityPlayer)entity;
        }
        if (!this.isHamsterTamed() && !this.isHamsterAngry()) {
            if (entity instanceof EntityPlayer) {
                this.setHamsterAngry(true);
                this.field_70789_a = entity;
            }
            if (entity instanceof EntityArrow && ((EntityArrow)entity).field_70250_c != null) {
                entity = ((EntityArrow)entity).field_70250_c;
            }
            if (entity instanceof EntityLiving) {
                List list = this.field_70170_p.func_72872_a(EntityHamster.class, AxisAlignedBB.func_72330_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)(this.field_70165_t + 1.0), (double)(this.field_70163_u + 1.0), (double)(this.field_70161_v + 1.0)).func_72314_b(16.0, 4.0, 16.0));
                for (Entity entity1 : list) {
                    EntityHamster entityhamster = (EntityHamster)entity1;
                    if (entityhamster.isHamsterTamed() || entityhamster.field_70789_a != null) continue;
                    entityhamster.field_70789_a = entity;
                    if (!(entity instanceof EntityPlayer)) continue;
                    entityhamster.setHamsterAngry(true);
                }
            }
        } else if (entity != this && entity != null) {
            if (this.isHamsterTamed() && entity instanceof EntityPlayer && ((EntityPlayer)entity).getDisplayName().equalsIgnoreCase(this.getHamsterOwner())) {
                this.func_70624_b(null);
                this.setHamsterAngry(false);
                this.field_70789_a = null;
            } else {
                this.field_70789_a = entity;
            }
        }
        return this.entityLivingBaseAttackEntityFrom(par1DamageSource, par2);
    }

    public boolean entityLivingBaseAttackEntityFrom(DamageSource par1DamageSource, float par2) {
        if (this.func_85032_ar()) {
            return false;
        }
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        this.field_70708_bq = 0;
        if (this.func_110143_aJ() <= 0.0f) {
            return false;
        }
        if (par1DamageSource.func_76347_k() && this.func_70644_a(Potion.field_76426_n)) {
            return false;
        }
        if (par1DamageSource == DamageSource.field_82728_o || par1DamageSource == DamageSource.field_82729_p) {
            par2 *= 0.75f;
        }
        this.field_70721_aZ = 1.5f;
        boolean var3 = true;
        if ((float)this.field_70172_ad > (float)this.field_70771_an / 2.0f) {
            if (par2 <= this.field_110153_bc) {
                return false;
            }
            this.func_70665_d(par1DamageSource, par2 - this.field_110153_bc);
            this.field_110153_bc = par2;
            var3 = false;
        } else {
            this.field_110153_bc = par2;
            this.field_70735_aL = this.func_110143_aJ();
            this.field_70172_ad = this.field_70771_an;
            this.func_70665_d(par1DamageSource, par2);
            this.field_70738_aO = 10;
            this.field_70737_aN = 10;
        }
        this.field_70739_aP = 0.0f;
        Entity var4 = par1DamageSource.func_76346_g();
        if (var4 != null) {
            EntityWolf var5;
            if (var4 instanceof EntityLivingBase) {
                this.func_70604_c((EntityLivingBase)var4);
            }
            if (var4 instanceof EntityPlayer) {
                this.field_70718_bc = 100;
                this.field_70717_bb = (EntityPlayer)var4;
            } else if (var4 instanceof EntityWolf && (var5 = (EntityWolf)var4).func_70909_n()) {
                this.field_70718_bc = 100;
                this.field_70717_bb = null;
            }
        }
        if (var3) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)2);
            if (par1DamageSource != DamageSource.field_76369_e) {
                this.func_70018_K();
            }
            if (var4 != null) {
                double var9 = var4.field_70165_t - this.field_70165_t;
                double var7 = var4.field_70161_v - this.field_70161_v;
                while (var9 * var9 + var7 * var7 < 1.0E-4) {
                    var9 = (Math.random() - Math.random()) * 0.01;
                    var7 = (Math.random() - Math.random()) * 0.01;
                }
                this.field_70739_aP = (float)(Math.atan2(var7, var9) * 180.0 / Math.PI) - this.field_70177_z;
                this.func_70653_a(var4, par2, var9, var7);
            } else {
                this.field_70739_aP = (int)(Math.random() * 2.0) * 180;
            }
        }
        if (this.func_110143_aJ() <= 0.0f) {
            if (var3) {
                this.func_85030_a(this.func_70673_aS(), this.func_70599_aP(), this.func_70647_i());
            }
            this.func_70645_a(par1DamageSource);
        } else if (var3) {
            this.func_85030_a(this.func_70621_aR(), this.func_70599_aP(), this.func_70647_i());
        }
        return true;
    }

    protected Entity func_70782_k() {
        AxisAlignedBB expandedBoundingBox = this.field_70121_D.func_72314_b(8.0, 8.0, 8.0);
        if (this.inLove > 0) {
            List hamstersInVincinity = this.field_70170_p.func_72872_a(((Object)((Object)this)).getClass(), expandedBoundingBox);
            for (EntityHamster hamsterCandidate : hamstersInVincinity) {
                if (hamsterCandidate == this || hamsterCandidate.inLove <= 0) continue;
                this.func_70624_b(null);
                return hamsterCandidate;
            }
        } else if (this.func_70874_b() == 0 && !this.isHamsterStanding() && !this.isHamsterSitting()) {
            List playersInVincinity = this.field_70170_p.func_72872_a(EntityPlayer.class, expandedBoundingBox);
            for (EntityPlayer playerCandidate : playersInVincinity) {
                if (playerCandidate.func_71045_bC() == null || !this.func_70877_b(playerCandidate.func_71045_bC())) continue;
                this.func_70624_b((EntityLivingBase)playerCandidate);
                this.setHamsterAngry(false);
                return playerCandidate;
            }
        } else if (this.func_70874_b() > 0 && !this.isHamsterStanding() && !this.isHamsterSitting()) {
            List hamstersInVincinity = this.field_70170_p.func_72872_a(((Object)((Object)this)).getClass(), expandedBoundingBox);
            for (EntityHamster hamsterCandidate : hamstersInVincinity) {
                if (hamsterCandidate == this || hamsterCandidate.func_70874_b() >= 0) continue;
                this.func_70624_b(null);
                this.setHamsterAngry(false);
                this.field_70789_a = null;
                return hamsterCandidate;
            }
        }
        if (this.isHamsterAngry()) {
            return this.field_70170_p.func_72890_a((Entity)this, 16.0);
        }
        return null;
    }

    protected void func_70785_a(Entity entity, float f) {
        double d1;
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityplayer;
            if (f < 3.0f) {
                double d = entity.field_70165_t - this.field_70165_t;
                d1 = entity.field_70161_v - this.field_70161_v;
                this.field_70177_z = (float)(Math.atan2(d1, d) * 180.0 / Math.PI) - 90.0f;
                this.field_70787_b = true;
                this.isStanding = true;
                this.func_70664_aZ();
            }
            if ((entityplayer = (EntityPlayer)entity).func_71045_bC() == null || !this.func_70877_b(entityplayer.func_71045_bC())) {
                this.field_70789_a = null;
            }
        } else if (entity instanceof EntityHamster) {
            EntityHamster entityhamster = (EntityHamster)entity;
            if (this.func_70874_b() > 0 && entityhamster.func_70874_b() < 0) {
                if ((double)f < 2.5) {
                    this.field_70787_b = true;
                }
            } else if (this.inLove > 0 && entityhamster.inLove > 0) {
                if (entityhamster.field_70789_a == null) {
                    entityhamster.field_70789_a = this;
                }
                if (entityhamster.field_70789_a == this && (double)f < 3.5) {
                    ++entityhamster.inLove;
                    ++this.inLove;
                    ++this.breeding;
                    if (this.breeding % 4 == 0) {
                        this.field_70170_p.func_72869_a("heart", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, 0.0, 0.0, 0.0);
                    }
                    if (this.breeding == 10) {
                        this.procreate((EntityHamster)entity);
                    }
                } else {
                    this.breeding = 0;
                }
            } else {
                this.breeding = 0;
                this.field_70789_a = null;
            }
        }
        if (f > 2.0f && f < 6.0f && this.field_70146_Z.nextInt(10) == 0) {
            if (this.field_70122_E) {
                double d = entity.field_70165_t - this.field_70165_t;
                d1 = entity.field_70161_v - this.field_70161_v;
                float f1 = MathHelper.func_76133_a((double)(d * d + d1 * d1));
                this.field_70159_w = d / (double)f1 * 0.5 * (double)0.8f + this.field_70159_w * (double)0.2f;
                this.field_70179_y = d1 / (double)f1 * 0.5 * (double)0.8f + this.field_70179_y * (double)0.2f;
                this.field_70181_x = 0.4f;
            }
        } else if (!(entity instanceof EntityHamster) && (!(entity instanceof EntityPlayer) || !((EntityPlayer)entity).getDisplayName().equalsIgnoreCase(this.getHamsterOwner())) && (double)f < 1.5 && entity.field_70121_D.field_72337_e > this.field_70121_D.field_72338_b && entity.field_70121_D.field_72338_b < this.field_70121_D.field_72337_e) {
            this.field_70724_aR = 20;
            boolean i = true;
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)i);
        }
    }

    protected void func_70664_aZ() {
        this.field_70181_x = 0.3;
    }

    public void func_70636_d() {
        EntityLivingBase entity;
        if (this.isHamsterAngry()) {
            this.inLove = 0;
        }
        super.func_70636_d();
        if (this.func_110143_aJ() < 10.0f) {
            this.eatFood();
            this.eatCount = 5000;
        }
        if (!this.isHamsterStanding() && !this.isHamsterSitting()) {
            if (this.field_70146_Z.nextInt(20) == 0 && this.field_70146_Z.nextInt(20) == 0) {
                this.setHamsterStanding(true);
                this.standCount = 30;
                this.func_70778_a(null);
                this.field_70703_bu = false;
            }
        } else if (this.isHamsterStanding() && this.standCount-- <= 0 && this.field_70146_Z.nextInt(10) == 0) {
            this.setHamsterStanding(false);
        }
        if (this.getFoodStackCount() > 0) {
            if (this.eatCount == 0) {
                if (this.field_70146_Z.nextInt(30) == 0 && this.field_70146_Z.nextInt(30) == 0) {
                    this.eatFood();
                    this.eatCount = 5000;
                }
            } else {
                --this.eatCount;
            }
        }
        this.looksWithInterest = false;
        if (!this.func_70781_l() && !this.isHamsterAngry() && (entity = this.func_70643_av()) instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
            if (itemstack != null && Item.func_150891_b((Item)itemstack.func_77973_b()) == Item.func_150891_b((Item)Items.field_151014_N)) {
                this.looksWithInterest = true;
            }
        }
        if (this.targetFood == null) {
            List loadedEntities = this.field_70170_p.field_72996_f;
            for (Entity entity2 : loadedEntities) {
                EntityItem entityitem;
                ItemStack item;
                if (!(entity2 instanceof EntityItem) || (item = (entityitem = (EntityItem)entity2).func_70096_w().func_82710_f(10)) == null || Item.func_150891_b((Item)item.func_77973_b()) != Item.func_150891_b((Item)Items.field_151014_N) || !(entityitem.func_70032_d((Entity)this) < 5.0f)) continue;
                this.targetFood = entityitem;
            }
        }
        if (this.isHamsterSitting() | this.isHamsterStanding() && this.func_70661_as() != null) {
            this.func_70661_as().func_75499_g();
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_25054_c = this.field_25048_b;
        this.field_25048_b = this.looksWithInterest ? (this.field_25048_b += (1.0f - this.field_25048_b) * 0.4f) : (this.field_25048_b += (0.0f - this.field_25048_b) * 0.4f);
        if (this.looksWithInterest) {
            this.field_70700_bx = 10;
        }
        if (this.field_70146_Z.nextInt(10) == 5) {
            ++this.field_70173_aa;
        }
    }

    public float getInterestedAngle(float f) {
        return (this.field_25054_c + (this.field_25048_b - this.field_25054_c) * f) * 0.15f * 3.141593f;
    }

    protected boolean func_70780_i() {
        return this.isHamsterSitting() || this.isHamsterStanding();
    }

    public String getHamsterOwner() {
        return this.field_70180_af.func_75681_e(17);
    }

    public void setHamsterOwner(String s) {
        this.field_70180_af.func_75692_b(17, (Object)s);
    }

    public boolean isInBall() {
        return this.field_70180_af.func_75683_a(20) == 1;
    }

    public void setInBall(boolean b) {
        this.field_70180_af.func_75692_b(20, (Object)((byte)(b ? 1 : 0)));
    }

    public int getBallColor() {
        return this.field_70180_af.func_75683_a(21);
    }

    public void setBallColor(int b) {
        this.field_70180_af.func_75692_b(21, (Object)((byte)b));
    }

    public boolean isHamsterSitting() {
        return (this.field_70180_af.func_75683_a(16) & 1) != 0;
    }

    public void setHamsterSitting(boolean flag) {
        byte byte0 = this.field_70180_af.func_75683_a(16);
        if (flag) {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(byte0 | 1)));
        } else {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(byte0 & 0xFFFFFFFE)));
        }
    }

    void showHeartsOrSmokeFX(String s, int i, boolean flag) {
        for (int j = 0; j < i; ++j) {
            double d = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            if (flag) {
                this.field_70170_p.func_72869_a(s, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d, d1, d2);
                this.field_70170_p.func_72908_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, "hamsterrific:eatSound", 3.0f, 1.0f);
                continue;
            }
            this.field_70170_p.func_72869_a(s, this.field_70165_t, this.field_70163_u + 0.8, this.field_70161_v, d, d1, d2);
            this.field_70170_p.func_72908_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, "hamsterrific:eatSound", 3.0f, 1.0f);
        }
    }

    public boolean isHamsterTamed() {
        return (this.field_70180_af.func_75683_a(16) & 4) != 0;
    }

    public void setHamsterTamed(boolean flag) {
        byte byte0 = this.field_70180_af.func_75683_a(16);
        if (flag) {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(byte0 | 4)));
        } else {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(byte0 & 0xFFFFFFFB)));
        }
    }

    public String getHamsterColor() {
        return this.field_70180_af.func_75681_e(18);
    }

    public void setHamsterColor(String s) {
        this.field_70180_af.func_75692_b(18, (Object)s);
    }

    public boolean isHamsterAngry() {
        return (this.field_70180_af.func_75683_a(16) & 8) != 0;
    }

    public void setHamsterAngry(boolean flag) {
        byte byte0 = this.field_70180_af.func_75683_a(16);
        if (flag) {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(byte0 | 8)));
        } else {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(byte0 & 0xFFFFFFF7)));
        }
    }

    public boolean isHamsterStanding() {
        return this.isStanding;
    }

    public void setHamsterStanding(boolean flag) {
        this.isStanding = flag;
    }

    protected Item func_146068_u() {
        return Items.field_151014_N;
    }

    public ItemStack func_70694_bm() {
        return this.heldItem;
    }

    public int getFoodStackCount() {
        return this.foodStackCount;
    }

    public void setFoodStackCount(int i) {
        this.foodStackCount = i;
    }

    private boolean addFoodStack() {
        if (this.foodStackCount != 5) {
            ++this.foodStackCount;
            return true;
        }
        this.func_70691_i(1.0f);
        return false;
    }

    private boolean eatFood() {
        if (this.foodStackCount != 0) {
            --this.foodStackCount;
            this.func_70691_i(1.0f);
            return true;
        }
        return false;
    }

    public EntityAgeable func_90011_a(EntityAgeable entityanimal) {
        EntityHamster entityhamster = (EntityHamster)entityanimal;
        EntityHamster entityhamster1 = new EntityHamster(this.field_70170_p);
        if (entityhamster.isHamsterTamed()) {
            entityhamster1.setHamsterTamed(true);
            entityhamster1.setHamsterOwner(entityhamster.getHamsterOwner());
        }
        entityhamster1.setHamsterColor(entityhamster.getHamsterColor());
        entityhamster1.resourceLocation = entityhamster.resourceLocation;
        return entityhamster1;
    }

    public boolean func_70115_ae() {
        return this.field_70154_o != null;
    }

    public boolean isRidingPlayer() {
        if (this.field_70154_o != null) {
            if (this.field_70154_o instanceof EntityPlayerSP) {
                return true;
            }
            if (this.field_70154_o.field_70154_o != null) {
                Entity e = this.field_70154_o.field_70154_o;
                while (e != null) {
                    if (e instanceof EntityPlayerSP) {
                        return true;
                    }
                    e = e.field_70154_o;
                }
            }
        }
        return false;
    }

    public float isRidingSpecial() {
        float f = -1.0f;
        if (this.field_70154_o != null) {
            Entity e = this.field_70154_o;
            while (e != null) {
                f = e.field_70131_O;
                e = e.field_70154_o;
            }
        }
        return f;
    }

    public boolean isRidingCreature() {
        if (this.field_70154_o != null && this.field_70154_o instanceof EntityCreature) {
            return false;
        }
        return false;
    }

    public boolean isRidingHamster() {
        return this.field_70154_o != null && this.field_70154_o instanceof EntityHamster;
    }

    public double func_70042_X() {
        return this.field_70131_O;
    }

    public void func_70624_b(EntityLivingBase par1EntityLiving) {
        super.func_70624_b(par1EntityLiving);
        if (!this.isHamsterTamed() && par1EntityLiving instanceof EntityPlayer) {
            this.setHamsterAngry(true);
        }
    }

    public boolean func_70877_b(ItemStack par1ItemStack) {
        return Item.func_150891_b((Item)par1ItemStack.func_77973_b()) == Item.func_150891_b((Item)Items.field_151080_bb);
    }

    private void procreate(EntityHamster par1EntityAnimal) {
        EntityHamster entityhamster = (EntityHamster)this.func_90011_a((EntityAgeable)par1EntityAnimal);
        if (entityhamster != null) {
            this.func_70873_a(6000);
            par1EntityAnimal.func_70873_a(6000);
            this.inLove = 0;
            this.breeding = 0;
            this.field_70789_a = null;
            par1EntityAnimal.field_70789_a = null;
            par1EntityAnimal.breeding = 0;
            par1EntityAnimal.inLove = 0;
            entityhamster.func_70873_a(-24000);
            entityhamster.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            for (int i = 0; i < 7; ++i) {
                double d = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_72869_a("heart", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d, d1, d2);
            }
            this.field_70170_p.func_72838_d((Entity)entityhamster);
        }
    }

    public boolean func_70880_s() {
        return this.inLove > 0;
    }

    public void func_70875_t() {
        this.inLove = 0;
    }

    protected void func_70908_e(boolean par1) {
    }

    public void func_70103_a(byte par1) {
    }

    public String func_70621_aR() {
        return "Hamsterrific:hurtSound";
    }

    public String func_70639_aQ() {
        return "Hamsterrific:livingSound";
    }

    public String func_70673_aS() {
        return "Hamsterrific:deathSound";
    }
}

