/*
 * Decompiled with CFR 0.152.
 */
package tmechworks.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mantle.world.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tmechworks.blocks.logic.SignalBusLogic;
import tmechworks.client.block.SignalBusRender;
import tmechworks.common.MechContent;
import tmechworks.lib.TMechworksRegistry;
import tmechworks.lib.multiblock.IMultiblockMember;

public class SignalBus
extends Block
implements ITileEntityProvider {
    public static int HITBOXES = 6;
    public IIcon[] icons;
    public String[] textureNames = new String[]{"signalbus"};

    public SignalBus() {
        super(Material.field_151594_q);
        this.func_149711_c(0.1f);
        this.func_149752_b(1.0f);
        this.func_149672_a(field_149777_j);
        this.func_149647_a(TMechworksRegistry.Mechworks);
    }

    public void onNeighborChange(IBlockAccess world, int x, int y, int z, int tileX, int tileY, int tileZ) {
        TileEntity te = world.func_147438_o(tileX, tileY, tileZ);
        if (te instanceof SignalBusLogic && ((SignalBusLogic)te).getMultiblockMaster() != null) {
            ((SignalBusLogic)te).getMultiblockMaster().detachBlock((IMultiblockMember)te, false);
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (block == this) {
            return;
        }
        super.func_149695_a(world, x, y, z, block);
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof SignalBusLogic) {
            Random rand = new Random();
            int dropBus = ((SignalBusLogic)te).checkUnsupportedSides();
            if (dropBus > 0) {
                if (((SignalBusLogic)te).checkShouldDestroy()) {
                    WorldHelper.setBlockToAir((World)world, (int)x, (int)y, (int)z);
                }
                ItemStack tempStack = new ItemStack(MechContent.signalBus, dropBus, 0);
                float jumpX = rand.nextFloat() * 0.8f + 0.1f;
                float jumpY = rand.nextFloat() * 0.8f + 0.1f;
                float jumpZ = rand.nextFloat() * 0.8f + 0.1f;
                EntityItem entityitem = new EntityItem(world, (double)((float)x + jumpX), (double)((float)y + jumpY), (double)((float)z + jumpZ), tempStack);
                float offset = 0.05f;
                entityitem.field_70159_w = (float)rand.nextGaussian() * offset;
                entityitem.field_70181_x = (float)rand.nextGaussian() * offset + 0.2f;
                entityitem.field_70179_y = (float)rand.nextGaussian() * offset;
                world.func_72838_d((Entity)entityitem);
                world.func_147471_g(x, y, z);
            }
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof SignalBusLogic) {
            ((SignalBusLogic)te).onBlockAdded(world, x, y, z);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return this.icons[0];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.icons = new IIcon[this.textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("tmechworks:" + this.textureNames[i]);
        }
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return SignalBusRender.renderID;
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB collisionTest, List collisionBoxList, Entity entity) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof SignalBusLogic) {
            for (AxisAlignedBB aabb : SignalBus.getBoxes((SignalBusLogic)te)) {
                if (aabb == null) continue;
                aabb = AxisAlignedBB.func_72330_a((double)aabb.field_72340_a, (double)aabb.field_72338_b, (double)aabb.field_72339_c, (double)aabb.field_72336_d, (double)aabb.field_72337_e, (double)aabb.field_72334_f);
                aabb.field_72340_a += (double)x;
                aabb.field_72338_b += (double)y;
                aabb.field_72339_c += (double)z;
                aabb.field_72336_d += (double)x;
                aabb.field_72337_e += (double)y;
                aabb.field_72334_f += (double)z;
                if (!collisionTest.func_72326_a(aabb)) continue;
                collisionBoxList.add(aabb);
            }
        } else {
            super.func_149743_a(world, x, y, z, collisionTest, collisionBoxList, entity);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess par1iBlockAccess, int par2, int par3, int par4, int par5) {
        return true;
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 start, Vec3 end) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof SignalBusLogic) {
            MovingObjectPosition closest = null;
            AxisAlignedBB[] boxes = SignalBus.getBoxes((SignalBusLogic)te);
            double closestCalc = Double.MAX_VALUE;
            double hitDistance = 0.0;
            for (int i = 0; i < boxes.length; ++i) {
                if (boxes[i] == null) continue;
                this.func_149676_a((float)boxes[i].field_72340_a, (float)boxes[i].field_72338_b, (float)boxes[i].field_72339_c, (float)boxes[i].field_72336_d, (float)boxes[i].field_72337_e, (float)boxes[i].field_72334_f);
                MovingObjectPosition hit = super.func_149731_a(world, x, y, z, start, end);
                if (hit == null || !((hitDistance = start.func_72438_d(hit.field_72307_f)) < closestCalc)) continue;
                closestCalc = hitDistance;
                closest = hit;
            }
            return closest;
        }
        return null;
    }

    private static AxisAlignedBB[] getBoxes(SignalBusLogic logic) {
        double maxZ;
        double maxY;
        double maxX;
        double minZ;
        double minY;
        double minX;
        boolean[] renderDir;
        boolean[] corners;
        boolean[] connected;
        boolean[] placed = logic.placedSides();
        AxisAlignedBB[] parts = new AxisAlignedBB[HITBOXES];
        boolean didRender = false;
        if (placed[ForgeDirection.DOWN.ordinal()]) {
            connected = logic.connectedSides(ForgeDirection.DOWN);
            corners = logic.getRenderCorners(ForgeDirection.DOWN);
            renderDir = new boolean[]{connected[0] || placed[0] || corners[0], connected[1] || placed[1] || corners[1], connected[2] || placed[2] || corners[2], connected[3] || placed[3] || corners[3], connected[4] || placed[4] || corners[4], connected[5] || placed[5] || corners[5]};
            minX = renderDir[ForgeDirection.WEST.ordinal()] ? BusGeometry.cable_extend_min : BusGeometry.cable_width_min;
            minY = BusGeometry.cable_low_offset;
            minZ = renderDir[ForgeDirection.NORTH.ordinal()] ? BusGeometry.cable_extend_min : BusGeometry.cable_width_min;
            maxX = renderDir[ForgeDirection.EAST.ordinal()] ? BusGeometry.cable_extend_max : BusGeometry.cable_width_max;
            maxY = BusGeometry.cable_low_height;
            maxZ = renderDir[ForgeDirection.SOUTH.ordinal()] ? BusGeometry.cable_extend_max : BusGeometry.cable_width_max;
            parts[0] = AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
            didRender = true;
        }
        if (placed[ForgeDirection.UP.ordinal()]) {
            connected = logic.connectedSides(ForgeDirection.UP);
            corners = logic.getRenderCorners(ForgeDirection.UP);
            renderDir = new boolean[]{connected[0] || placed[0] || corners[0], connected[1] || placed[1] || corners[1], connected[2] || placed[2] || corners[2], connected[3] || placed[3] || corners[3], connected[4] || placed[4] || corners[4], connected[5] || placed[5] || corners[5]};
            minX = renderDir[ForgeDirection.WEST.ordinal()] ? BusGeometry.cable_extend_min : BusGeometry.cable_width_min;
            minY = BusGeometry.cable_high_offset;
            minZ = renderDir[ForgeDirection.NORTH.ordinal()] ? BusGeometry.cable_extend_min : BusGeometry.cable_width_min;
            maxX = renderDir[ForgeDirection.EAST.ordinal()] ? BusGeometry.cable_extend_max : BusGeometry.cable_width_max;
            maxY = BusGeometry.cable_high_height;
            maxZ = renderDir[ForgeDirection.SOUTH.ordinal()] ? BusGeometry.cable_extend_max : BusGeometry.cable_width_max;
            parts[1] = AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
            didRender = true;
        }
        if (placed[ForgeDirection.NORTH.ordinal()]) {
            connected = logic.connectedSides(ForgeDirection.NORTH);
            corners = logic.getRenderCorners(ForgeDirection.NORTH);
            renderDir = new boolean[]{connected[0] || placed[0] || corners[0], connected[1] || placed[1] || corners[1], connected[2] || placed[2] || corners[2], connected[3] || placed[3] || corners[3], connected[4] || placed[4] || corners[4], connected[5] || placed[5] || corners[5]};
            minX = renderDir[ForgeDirection.WEST.ordinal()] ? BusGeometry.cable_extend_min : BusGeometry.cable_width_min;
            minY = renderDir[ForgeDirection.DOWN.ordinal()] ? BusGeometry.cable_extend_min : BusGeometry.cable_width_min;
            minZ = BusGeometry.cable_low_offset;
            maxX = renderDir[ForgeDirection.EAST.ordinal()] ? BusGeometry.cable_extend_max : BusGeometry.cable_width_max;
            maxY = renderDir[ForgeDirection.UP.ordinal()] ? BusGeometry.cable_extend_max : BusGeometry.cable_width_max;
            maxZ = BusGeometry.cable_low_height;
            parts[2] = AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
            didRender = true;
        }
        if (placed[ForgeDirection.SOUTH.ordinal()]) {
            connected = logic.connectedSides(ForgeDirection.SOUTH);
            corners = logic.getRenderCorners(ForgeDirection.SOUTH);
            renderDir = new boolean[]{connected[0] || placed[0] || corners[0], connected[1] || placed[1] || corners[1], connected[2] || placed[2] || corners[2], connected[3] || placed[3] || corners[3], connected[4] || placed[4] || corners[4], connected[5] || placed[5] || corners[5]};
            minX = renderDir[ForgeDirection.WEST.ordinal()] ? BusGeometry.cable_extend_min : BusGeometry.cable_width_min;
            minY = renderDir[ForgeDirection.DOWN.ordinal()] ? BusGeometry.cable_extend_min : BusGeometry.cable_width_min;
            minZ = BusGeometry.cable_high_offset;
            maxX = renderDir[ForgeDirection.EAST.ordinal()] ? BusGeometry.cable_extend_max : BusGeometry.cable_width_max;
            maxY = renderDir[ForgeDirection.UP.ordinal()] ? BusGeometry.cable_extend_max : BusGeometry.cable_width_max;
            maxZ = BusGeometry.cable_high_height;
            parts[3] = AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
            didRender = true;
        }
        if (placed[ForgeDirection.WEST.ordinal()]) {
            connected = logic.connectedSides(ForgeDirection.WEST);
            corners = logic.getRenderCorners(ForgeDirection.WEST);
            renderDir = new boolean[]{connected[0] || placed[0] || corners[0], connected[1] || placed[1] || corners[1], connected[2] || placed[2] || corners[2], connected[3] || placed[3] || corners[3], connected[4] || placed[4] || corners[4], connected[5] || placed[5] || corners[5]};
            minX = BusGeometry.cable_low_offset;
            minY = renderDir[ForgeDirection.DOWN.ordinal()] ? BusGeometry.cable_extend_min : BusGeometry.cable_width_min;
            minZ = renderDir[ForgeDirection.NORTH.ordinal()] ? BusGeometry.cable_extend_min : BusGeometry.cable_width_min;
            maxX = BusGeometry.cable_low_height;
            maxY = renderDir[ForgeDirection.UP.ordinal()] ? BusGeometry.cable_extend_max : BusGeometry.cable_width_max;
            maxZ = renderDir[ForgeDirection.SOUTH.ordinal()] ? BusGeometry.cable_extend_max : BusGeometry.cable_width_max;
            parts[4] = AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
            didRender = true;
        }
        if (placed[ForgeDirection.EAST.ordinal()]) {
            connected = logic.connectedSides(ForgeDirection.EAST);
            corners = logic.getRenderCorners(ForgeDirection.EAST);
            renderDir = new boolean[]{connected[0] || placed[0] || corners[0], connected[1] || placed[1] || corners[1], connected[2] || placed[2] || corners[2], connected[3] || placed[3] || corners[3], connected[4] || placed[4] || corners[4], connected[5] || placed[5] || corners[5]};
            minX = BusGeometry.cable_high_offset;
            minY = renderDir[ForgeDirection.DOWN.ordinal()] ? BusGeometry.cable_extend_min : BusGeometry.cable_width_min;
            minZ = renderDir[ForgeDirection.NORTH.ordinal()] ? BusGeometry.cable_extend_min : BusGeometry.cable_width_min;
            maxX = BusGeometry.cable_high_height;
            maxY = renderDir[ForgeDirection.UP.ordinal()] ? BusGeometry.cable_extend_max : BusGeometry.cable_width_max;
            maxZ = renderDir[ForgeDirection.SOUTH.ordinal()] ? BusGeometry.cable_extend_max : BusGeometry.cable_width_max;
            parts[5] = AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
            didRender = true;
        }
        if (!didRender) {
            minX = BusGeometry.cable_width_min;
            minY = BusGeometry.cable_low_offset;
            minZ = BusGeometry.cable_width_min;
            maxX = BusGeometry.cable_width_max;
            maxY = BusGeometry.cable_low_height;
            maxZ = BusGeometry.cable_width_max;
            parts[0] = AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
        }
        return parts;
    }

    private static int closestClicked(EntityPlayer player, double reachDistance, SignalBusLogic terminal, AxisAlignedBB[] parts) {
        int closest = -1;
        Vec3 playerPosition = Vec3.func_72443_a((double)(player.field_70165_t - (double)terminal.field_145851_c), (double)(player.field_70163_u - (double)terminal.field_145848_d + (double)player.func_70047_e()), (double)(player.field_70161_v - (double)terminal.field_145849_e));
        Vec3 playerLook = player.func_70040_Z();
        Vec3 playerViewOffset = Vec3.func_72443_a((double)(playerPosition.field_72450_a + playerLook.field_72450_a * reachDistance), (double)(playerPosition.field_72448_b + playerLook.field_72448_b * reachDistance), (double)(playerPosition.field_72449_c + playerLook.field_72449_c * reachDistance));
        double closestCalc = Double.MAX_VALUE;
        double hitDistance = 0.0;
        for (int i = 0; i < parts.length; ++i) {
            MovingObjectPosition hit;
            if (parts[i] == null || (hit = parts[i].func_72327_a(playerPosition, playerViewOffset)) == null || !((hitDistance = playerPosition.func_72438_d(hit.field_72307_f)) < closestCalc)) continue;
            closestCalc = hitDistance;
            closest = i;
        }
        return closest;
    }

    private static void drawOutlinedBoundingBox(AxisAlignedBB par1AxisAlignedBB) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78371_b(3);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78381_a();
        tessellator.func_78371_b(3);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78381_a();
        tessellator.func_78371_b(1);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78381_a();
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new SignalBusLogic();
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        NBTTagCompound data;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof SignalBusLogic && (data = itemStack.field_77990_d) != null && data.func_74764_b("connectedSide")) {
            ((SignalBusLogic)te).addPlacedSide(data.func_74762_e("connectedSide"));
            itemStack.field_77990_d = null;
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        int dropWire = 0;
        Random rand = new Random();
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof SignalBusLogic) {
            float offset;
            EntityItem entityitem;
            float jumpZ;
            float jumpY;
            float jumpX;
            ItemStack tempStack;
            int dropBus = ((SignalBusLogic)te).getDroppedBuses();
            dropWire = ((SignalBusLogic)te).getDroppedWire();
            if (dropBus > 0) {
                tempStack = new ItemStack(MechContent.signalBus, dropBus, 0);
                jumpX = rand.nextFloat() * 0.8f + 0.1f;
                jumpY = rand.nextFloat() * 0.8f + 0.1f;
                jumpZ = rand.nextFloat() * 0.8f + 0.1f;
                entityitem = new EntityItem(world, (double)((float)x + jumpX), (double)((float)y + jumpY), (double)((float)z + jumpZ), tempStack);
                offset = 0.05f;
                entityitem.field_70159_w = (float)rand.nextGaussian() * offset;
                entityitem.field_70181_x = (float)rand.nextGaussian() * offset + 0.2f;
                entityitem.field_70179_y = (float)rand.nextGaussian() * offset;
                world.func_72838_d((Entity)entityitem);
            }
            if (dropWire > 0) {
                tempStack = new ItemStack(MechContent.lengthWire, dropWire);
                jumpX = rand.nextFloat() * 0.8f + 0.1f;
                jumpY = rand.nextFloat() * 0.8f + 0.1f;
                jumpZ = rand.nextFloat() * 0.8f + 0.1f;
                entityitem = new EntityItem(world, (double)((float)x + jumpX), (double)((float)y + jumpY), (double)((float)z + jumpZ), tempStack);
                offset = 0.05f;
                entityitem.field_70159_w = (float)rand.nextGaussian() * offset;
                entityitem.field_70181_x = (float)rand.nextGaussian() * offset + 0.2f;
                entityitem.field_70179_y = (float)rand.nextGaussian() * offset;
                world.func_72838_d((Entity)entityitem);
            }
            ((SignalBusLogic)te).notifyBreak();
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public boolean func_149707_d(World par1World, int par2, int par3, int par4, int par5) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)par5);
        boolean solid = dir == ForgeDirection.DOWN && par1World.isSideSolid(par2, par3 + 1, par4, ForgeDirection.DOWN) || dir == ForgeDirection.UP && par1World.isSideSolid(par2, par3 - 1, par4, ForgeDirection.UP) || dir == ForgeDirection.NORTH && par1World.isSideSolid(par2, par3, par4 + 1, ForgeDirection.NORTH) || dir == ForgeDirection.SOUTH && par1World.isSideSolid(par2, par3, par4 - 1, ForgeDirection.SOUTH) || dir == ForgeDirection.WEST && par1World.isSideSolid(par2 + 1, par3, par4, ForgeDirection.WEST) || dir == ForgeDirection.EAST && par1World.isSideSolid(par2 - 1, par3, par4, ForgeDirection.EAST);
        return solid;
    }

    public boolean func_149742_c(World par1World, int par2, int par3, int par4) {
        return par1World.isSideSolid(par2 - 1, par3, par4, ForgeDirection.EAST) || par1World.isSideSolid(par2 + 1, par3, par4, ForgeDirection.WEST) || par1World.isSideSolid(par2, par3, par4 - 1, ForgeDirection.SOUTH) || par1World.isSideSolid(par2, par3, par4 + 1, ForgeDirection.NORTH) || par1World.isSideSolid(par2, par3 - 1, par4, ForgeDirection.UP) || par1World.isSideSolid(par2, par3 + 1, par4, ForgeDirection.DOWN);
    }

    public boolean func_149718_j(World par1World, int par2, int par3, int par4) {
        return par1World.isSideSolid(par2 - 1, par3, par4, ForgeDirection.EAST) || par1World.isSideSolid(par2 + 1, par3, par4, ForgeDirection.WEST) || par1World.isSideSolid(par2, par3, par4 - 1, ForgeDirection.SOUTH) || par1World.isSideSolid(par2, par3, par4 + 1, ForgeDirection.NORTH) || par1World.isSideSolid(par2, par3 - 1, par4, ForgeDirection.UP) || par1World.isSideSolid(par2, par3 + 1, par4, ForgeDirection.DOWN);
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new SignalBusLogic();
    }

    public static class BusGeometry {
        public static double cable_width_min = 0.375;
        public static double cable_width_max = 1.0 - cable_width_min;
        public static double cable_low_height = 0.2;
        public static double cable_low_offset = 0.0;
        public static double cable_high_height = 1.0;
        public static double cable_high_offset = 1.0 - cable_low_height;
        public static double cable_extend_min = 0.0;
        public static double cable_extend_max = 1.0;
        public static double cable_corner_min = cable_high_offset - 1.0;
        public static double cable_corner_max = cable_low_height + 1.0;
        public static double zfight = 1.0E-5;
    }
}

