/*
 * Decompiled with CFR 0.152.
 */
package morph.common.core;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import morph.client.model.ModelHelper;
import morph.client.render.RenderMorph;
import morph.common.Morph;
import morph.common.core.EntityHelper;
import morph.common.morph.MorphInfo;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;

public class ApiHandler {
    public static boolean hasMorph(String playerName, boolean isClient) {
        if (isClient) {
            return Morph.proxy.tickHandlerClient.playerMorphInfo.containsKey(playerName);
        }
        return Morph.proxy.tickHandlerServer.getPlayerMorphInfo(playerName) != null;
    }

    public static float morphProgress(String playerName, boolean isClient) {
        MorphInfo info = isClient ? (MorphInfo)Morph.proxy.tickHandlerClient.playerMorphInfo.get(playerName) : Morph.proxy.tickHandlerServer.getPlayerMorphInfo(playerName);
        if (info != null) {
            float prog = (float)info.morphProgress / 80.0f;
            if (prog > 1.0f) {
                prog = 1.0f;
            }
            return prog;
        }
        return 1.0f;
    }

    public static EntityLivingBase getPrevMorphEntity(String playerName, boolean isClient) {
        MorphInfo info = isClient ? (MorphInfo)Morph.proxy.tickHandlerClient.playerMorphInfo.get(playerName) : Morph.proxy.tickHandlerServer.getPlayerMorphInfo(playerName);
        if (info != null && info.prevState != null) {
            return info.prevState.entInstance;
        }
        return null;
    }

    public static EntityLivingBase getMorphEntity(String playerName, boolean isClient) {
        MorphInfo info = isClient ? (MorphInfo)Morph.proxy.tickHandlerClient.playerMorphInfo.get(playerName) : Morph.proxy.tickHandlerServer.getPlayerMorphInfo(playerName);
        if (info != null) {
            return info.nextState.entInstance;
        }
        return null;
    }

    public static void blacklistEntity(Class<? extends EntityLivingBase> clz) {
        if (!Morph.blacklistedClasses.contains(clz)) {
            Morph.blacklistedClasses.add(clz);
        }
    }

    public static boolean forceMorph(EntityPlayerMP player, EntityLivingBase living) {
        return EntityHelper.morphPlayer(player, living, false, true);
    }

    public static void forceDemorph(EntityPlayerMP player) {
        EntityHelper.demorphPlayer(player);
    }

    public static String isEntityAMorph(EntityLivingBase living, boolean isClient) {
        HashMap<String, MorphInfo> infoMap = isClient ? Morph.proxy.tickHandlerClient.playerMorphInfo : Morph.proxy.tickHandlerServer.playerMorphInfo;
        for (Map.Entry<String, MorphInfo> e : infoMap.entrySet()) {
            if (e.getValue().nextState.entInstance != living && (e.getValue().prevState == null || e.getValue().prevState.entInstance != living)) continue;
            return e.getKey();
        }
        return null;
    }

    public static void allowNextPlayerRender() {
        Morph.proxy.tickHandlerClient.allowRender = true;
    }

    @SideOnly(value=Side.CLIENT)
    public static ResourceLocation getMorphSkinTexture() {
        return RenderMorph.morphSkin;
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerArmForModel(ModelBase model, ModelRenderer arm) {
        ModelHelper.armMappings.put(model.getClass(), arm);
    }
}

