/*
 * Decompiled with CFR 0.152.
 */
package morph.common.ability;

import java.util.ArrayList;
import java.util.HashMap;
import morph.api.Ability;
import morph.common.Morph;
import morph.common.ability.AbilityClimb;
import morph.common.ability.AbilityFallNegate;
import morph.common.ability.AbilityFear;
import morph.common.ability.AbilityFireImmunity;
import morph.common.ability.AbilityFloat;
import morph.common.ability.AbilityFly;
import morph.common.ability.AbilityHostile;
import morph.common.ability.AbilityPoisonResistance;
import morph.common.ability.AbilityPotionEffect;
import morph.common.ability.AbilitySink;
import morph.common.ability.AbilityStep;
import morph.common.ability.AbilitySunburn;
import morph.common.ability.AbilitySwim;
import morph.common.ability.AbilityWaterAllergy;
import morph.common.ability.AbilityWitherResistance;
import net.minecraft.entity.EntityLivingBase;

public class AbilityHandler {
    public static final HashMap<Class<? extends EntityLivingBase>, ArrayList<Ability>> abilityMap = new HashMap();
    public static final HashMap<String, Class<? extends Ability>> stringToClassMap = new HashMap();
    public static final ArrayList<Class<? extends EntityLivingBase>> abilityClassList = new ArrayList();

    public static void registerAbility(String name, Class<? extends Ability> clz) {
        stringToClassMap.put(name, clz);
    }

    public static void mapAbilities(Class<? extends EntityLivingBase> entClass, Ability ... abilities) {
        ArrayList<Ability> abilityList = abilityMap.get(entClass);
        if (abilityList == null) {
            abilityList = new ArrayList();
            abilityMap.put(entClass, abilityList);
            if (!abilityClassList.contains(entClass)) {
                abilityClassList.add(entClass);
            }
        }
        for (Ability ability : abilities) {
            if (ability == null) continue;
            boolean added = false;
            if (!stringToClassMap.containsKey(ability.getType())) {
                AbilityHandler.registerAbility(ability.getType(), ability.getClass());
                Morph.console("Ability type \"" + ability.getType() + "\" is not registered! Registering.", true);
            }
            for (int i = 0; i < abilityList.size(); ++i) {
                Ability ab = abilityList.get(i);
                if (!ab.getType().equals(ability.getType())) continue;
                abilityList.remove(i);
                abilityList.add(i, ability);
                added = true;
            }
            if (added) continue;
            abilityList.add(ability);
        }
    }

    public static void removeAbility(Class<? extends EntityLivingBase> entClass, String type) {
        ArrayList<Ability> abilityList = abilityMap.get(entClass);
        if (abilityList != null) {
            for (int i = abilityList.size() - 1; i >= 0; --i) {
                Ability ability = abilityList.get(i);
                if (!ability.getType().equalsIgnoreCase(type)) continue;
                abilityList.remove(i);
            }
        }
    }

    public static boolean hasAbility(Class<? extends EntityLivingBase> entClass, String type) {
        ArrayList<Ability> abilities = AbilityHandler.getEntityAbilities(entClass);
        for (Ability ability : abilities) {
            if (!ability.getType().equalsIgnoreCase(type)) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<Ability> getEntityAbilities(Class<? extends EntityLivingBase> entClass) {
        if (Morph.config.getSessionInt("abilities") == 1) {
            ArrayList<Ability> abilities = abilityMap.get(entClass);
            if (abilities == null) {
                Class<? extends EntityLivingBase> superClz = entClass.getSuperclass();
                if (superClz != EntityLivingBase.class) {
                    abilityMap.put(entClass, AbilityHandler.getEntityAbilities(superClz));
                    return AbilityHandler.getEntityAbilities(entClass);
                }
            } else {
                String[] disabledAbilities = Morph.config.getSessionString("disabledAbilities").split(",");
                block0: for (int i = abilities.size() - 1; i >= 0; --i) {
                    Ability ab = abilities.get(i);
                    for (String s : disabledAbilities) {
                        if (s.isEmpty() || !ab.getType().equals(s)) continue;
                        abilities.remove(i);
                        continue block0;
                    }
                }
                return abilities;
            }
        }
        return new ArrayList<Ability>();
    }

    public static Ability createNewAbilityByType(String type, String[] arguments) {
        try {
            Class<? extends Ability> abilityClass = stringToClassMap.get(type);
            if (abilityClass != null) {
                Ability ab = abilityClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                try {
                    ab.parse(arguments);
                }
                catch (Exception e2) {
                    Morph.console("Arguments are erroring when trying to create ability by type: " + abilityClass.getName() + ", " + type + ", args: " + arguments == null ? "none" : "arg list of size " + arguments.length, true);
                    e2.printStackTrace();
                }
                return ab;
            }
            Morph.console("Ability type \"" + type + "\" does not exist!", true);
        }
        catch (Exception e) {
            Morph.console("Error creating ability by type: " + type, true);
            e.printStackTrace();
        }
        return null;
    }

    static {
        AbilityHandler.registerAbility("climb", AbilityClimb.class);
        AbilityHandler.registerAbility("fallNegate", AbilityFallNegate.class);
        AbilityHandler.registerAbility("fear", AbilityFear.class);
        AbilityHandler.registerAbility("fly", AbilityFly.class);
        AbilityHandler.registerAbility("float", AbilityFloat.class);
        AbilityHandler.registerAbility("fireImmunity", AbilityFireImmunity.class);
        AbilityHandler.registerAbility("hostile", AbilityHostile.class);
        AbilityHandler.registerAbility("poisonResistance", AbilityPoisonResistance.class);
        AbilityHandler.registerAbility("potionEffect", AbilityPotionEffect.class);
        AbilityHandler.registerAbility("sink", AbilitySink.class);
        AbilityHandler.registerAbility("step", AbilityStep.class);
        AbilityHandler.registerAbility("sunburn", AbilitySunburn.class);
        AbilityHandler.registerAbility("swim", AbilitySwim.class);
        AbilityHandler.registerAbility("waterAllergy", AbilityWaterAllergy.class);
        AbilityHandler.registerAbility("witherResistance", AbilityWitherResistance.class);
    }
}

