/*
 * Decompiled with CFR 0.152.
 */
package morph.common.ability;

import java.util.ArrayList;
import java.util.List;
import morph.api.Ability;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;

public class AbilityFear
extends Ability {
    public ArrayList<Class<?>> classList = new ArrayList();
    public int radius;
    public double runSpeed;
    public static final ResourceLocation iconResource = new ResourceLocation("morph", "textures/icon/fear.png");

    public AbilityFear() {
    }

    public AbilityFear(int radius, double speed, Class<?> ... entityClass) {
        this.radius = radius;
        this.runSpeed = speed;
        for (Class<?> clazz : entityClass) {
            if (!EntityCreature.class.isAssignableFrom(clazz)) continue;
            this.classList.add(clazz);
        }
    }

    @Override
    public Ability parse(String[] args) {
        this.radius = Integer.parseInt(args[0]);
        this.runSpeed = Double.parseDouble(args[1]);
        for (int i = 2; i < args.length; ++i) {
            try {
                Class<?> clz = Class.forName(args[i]);
                if (!EntityCreature.class.isAssignableFrom(clz)) continue;
                this.classList.add(clz);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this;
    }

    @Override
    public String getType() {
        return "fear";
    }

    @Override
    public void tick() {
        List entityList;
        if (this.getParent().field_70170_p.func_72820_D() % 22L == 0L && !(entityList = ((EntityPlayer)this.getParent()).func_130014_f_().func_72839_b((Entity)this.getParent(), this.getParent().field_70121_D.func_72314_b((double)this.radius, (double)this.radius, (double)this.radius))).isEmpty()) {
            for (Entity entity : entityList) {
                if (!(entity instanceof EntityCreature)) continue;
                EntityCreature creature = (EntityCreature)entity;
                for (Class<?> clz : this.classList) {
                    if (!clz.isInstance(creature)) continue;
                    boolean canRun = false;
                    Vec3 vec3 = RandomPositionGenerator.func_75461_b((EntityCreature)creature, (int)16, (int)7, (Vec3)Vec3.func_72443_a((double)this.getParent().field_70165_t, (double)this.getParent().field_70163_u, (double)this.getParent().field_70161_v));
                    if (vec3 != null && !(this.getParent().func_70092_e(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c) < this.getParent().func_70068_e((Entity)creature))) {
                        PathEntity newPath = new PathEntity(new PathPoint[]{new PathPoint((int)vec3.field_72450_a, (int)vec3.field_72448_b, (int)vec3.field_72449_c)});
                        creature.func_70661_as().func_75484_a(newPath, 1.0);
                        canRun = true;
                    }
                    if (!canRun) continue;
                    creature.func_70661_as().func_75489_a(this.runSpeed);
                }
            }
        }
    }

    @Override
    public void kill() {
    }

    @Override
    public Ability clone() {
        if (this.classList.isEmpty()) {
            return new AbilityFear();
        }
        Class[] classArray = new Class[this.classList.size()];
        for (int i = 0; i < classArray.length; ++i) {
            classArray[i] = this.classList.get(i);
        }
        return new AbilityFear(this.radius, this.runSpeed, classArray);
    }

    @Override
    public void save(NBTTagCompound tag) {
    }

    @Override
    public void load(NBTTagCompound tag) {
    }

    @Override
    public void postRender() {
    }

    @Override
    public ResourceLocation getIcon() {
        return iconResource;
    }
}

