/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.FolderName;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BYGDataGenerator {
    public static void dataGenBiome(String filePath, String modId, CommandContext<CommandSource> source) throws IOException {
        OptionParser optionParser = new OptionParser();
        AbstractOptionSpec optionSpec = optionParser.accepts("help", "Show the help menu").forHelp();
        OptionSpecBuilder optionSpec7 = optionParser.accepts("all", "Include all generators");
        ArgumentAcceptingOptionSpec optionSpec9 = optionParser.accepts("input", "Input folder").withRequiredArg();
        OptionSet optionSet = optionParser.parse(new String[]{"-all"});
        if (!optionSet.has((OptionSpec)optionSpec) && optionSet.hasOptions()) {
            Path path = Paths.get(filePath, new String[0]);
            boolean bl = optionSet.has((OptionSpec)optionSpec7);
            DataGenerator dataGenerator = BYGDataGenerator.create(path, optionSet.valuesOf((OptionSpec)optionSpec9).stream().map(string -> Paths.get(string, new String[0])).collect(Collectors.toList()), modId, source);
            dataGenerator.func_200392_c();
        } else {
            optionParser.printHelpOn((OutputStream)System.out);
        }
    }

    public static DataGenerator create(Path output, Collection<Path> inputs, String modId, CommandContext<CommandSource> source) {
        DataGenerator dataGenerator = new DataGenerator(output, inputs);
        dataGenerator.func_200390_a((IDataProvider)new BiomeDataProvider(dataGenerator, modId, source));
        return dataGenerator;
    }

    public static void dataGenCommand(CommandDispatcher<CommandSource> dispatcher) {
        String commandString = "gendata";
        ArrayList modIdList = new ArrayList();
        ModList.get().getMods().forEach(modContainer -> {
            String modId = modContainer.getModId();
            if (!modId.contains("forge")) {
                modIdList.add(modId);
            }
        });
        LiteralCommandNode source = dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)commandString).then(Commands.func_197056_a((String)"modid", (ArgumentType)StringArgumentType.string()).suggests((ctx, sb) -> ISuggestionProvider.func_197013_a(modIdList.stream(), (SuggestionsBuilder)sb)).executes(cs -> {
            try {
                BYGDataGenerator.dataGenBiome(((CommandSource)cs.getSource()).func_197023_e().func_73046_m().func_240776_a_(FolderName.field_237251_g_).toString(), (String)cs.getArgument("modid", String.class), (CommandContext<CommandSource>)cs);
            }
            catch (IOException e) {
                ((CommandSource)cs.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.gendata.failed", new Object[]{cs.getArgument("modid", String.class)}).func_240700_a_(text -> text.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.RED))), false);
            }
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)commandString).redirect((CommandNode)source));
    }

    public static class BiomeDataProvider
    implements IDataProvider {
        private static final Logger logger = LogManager.getLogger();
        private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
        private final DataGenerator dataGen;
        private final String modId;
        private final CommandContext<CommandSource> commandSource;
        private static final List<Biome> biomeList = new ArrayList<Biome>();

        public BiomeDataProvider(DataGenerator dataGenerator, String modId, CommandContext<CommandSource> source) {
            this.dataGen = dataGenerator;
            this.modId = modId;
            this.commandSource = source;
        }

        public void func_200398_a(DirectoryCache cache) {
            Path path = this.dataGen.func_200391_b();
            for (Map.Entry entry : ForgeRegistries.BIOMES.getEntries()) {
                if (!Objects.requireNonNull(ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)entry.getValue())).toString().contains(this.modId)) continue;
                biomeList.add((Biome)entry.getValue());
            }
            if (biomeList.size() > 0) {
                for (Biome biome : biomeList) {
                    Path path2 = BiomeDataProvider.filePath(path, ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome), this.modId);
                    Function function1 = JsonOps.INSTANCE.withEncoder((Encoder)Biome.field_235051_b_);
                    try {
                        Optional optional = ((DataResult)function1.apply(() -> biome)).result();
                        if (optional.isPresent()) {
                            IDataProvider.func_218426_a((Gson)gson, (DirectoryCache)cache, (JsonElement)((JsonElement)optional.get()), (Path)path2);
                            continue;
                        }
                        logger.error("Couldn't serialize biome {}", (Object)path2);
                    }
                    catch (IOException var9) {
                        logger.error("Couldn't save biome {}", (Object)path2, (Object)var9);
                    }
                }
                ((CommandSource)this.commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.gendata.success", new Object[]{this.commandSource.getArgument("modid", String.class), ((CommandSource)this.commandSource.getSource()).func_197023_e().func_73046_m().func_240776_a_(FolderName.field_237251_g_).toString().replace("\\", "/").replace("/./", "/") + "/data/" + this.modId + "/worldgen/biome/"}).func_240700_a_(text -> text.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.GREEN))), false);
                biomeList.clear();
            } else {
                ((CommandSource)this.commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.gendata.listisempty", new Object[]{this.modId}).func_240700_a_(text -> text.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.RED))), false);
            }
        }

        public String func_200397_b() {
            return "Byg Biomes";
        }

        private static Path filePath(Path path, ResourceLocation identifier, String modId) {
            return path.resolve("data/" + modId + "/worldgen/biome/" + identifier.func_110623_a() + ".json");
        }
    }
}

