/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.world.worldtype116;

import java.util.function.LongFunction;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.layer.AddBambooForestLayer;
import net.minecraft.world.gen.layer.AddIslandLayer;
import net.minecraft.world.gen.layer.AddMushroomIslandLayer;
import net.minecraft.world.gen.layer.AddSnowLayer;
import net.minecraft.world.gen.layer.BiomeLayer;
import net.minecraft.world.gen.layer.DeepOceanLayer;
import net.minecraft.world.gen.layer.EdgeBiomeLayer;
import net.minecraft.world.gen.layer.EdgeLayer;
import net.minecraft.world.gen.layer.IslandLayer;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.MixOceansLayer;
import net.minecraft.world.gen.layer.MixRiverLayer;
import net.minecraft.world.gen.layer.OceanLayer;
import net.minecraft.world.gen.layer.RareBiomeLayer;
import net.minecraft.world.gen.layer.RemoveTooMuchOceanLayer;
import net.minecraft.world.gen.layer.RiverLayer;
import net.minecraft.world.gen.layer.ShoreLayer;
import net.minecraft.world.gen.layer.SmoothLayer;
import net.minecraft.world.gen.layer.StartRiverLayer;
import net.minecraft.world.gen.layer.ZoomLayer;
import net.minecraft.world.gen.layer.traits.IAreaTransformer1;
import voronoiaoc.byg.common.world.worldtype116.ModdedHillsLayer;
import voronoiaoc.byg.config.BYGWorldConfig;

public class BYGWorldLayerProvider {
    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> repeat(long seed, IAreaTransformer1 parent, IAreaFactory<T> factory, int count, LongFunction<C> contextFactory) {
        IAreaFactory iareafactory = factory;
        for (int i = 0; i < count; ++i) {
            iareafactory = parent.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(seed + (long)i), iareafactory);
        }
        return iareafactory;
    }

    public static Layer stackLayers(long seed) {
        LongFunction<IExtendedNoiseRandom> randomProvider = salt -> new LazyAreaLayerContext(1, seed, salt);
        IAreaFactory primaryFactory = IslandLayer.INSTANCE.func_202823_a(randomProvider.apply(1L));
        primaryFactory = ZoomLayer.FUZZY.func_202713_a(randomProvider.apply(2000L), primaryFactory);
        primaryFactory = AddIslandLayer.INSTANCE.func_202713_a(randomProvider.apply(1L), primaryFactory);
        primaryFactory = ZoomLayer.NORMAL.func_202713_a(randomProvider.apply(2001L), primaryFactory);
        primaryFactory = AddIslandLayer.INSTANCE.func_202713_a(randomProvider.apply(2L), primaryFactory);
        primaryFactory = AddIslandLayer.INSTANCE.func_202713_a(randomProvider.apply(50L), primaryFactory);
        primaryFactory = AddIslandLayer.INSTANCE.func_202713_a(randomProvider.apply(70L), primaryFactory);
        primaryFactory = RemoveTooMuchOceanLayer.INSTANCE.func_202713_a(randomProvider.apply(2L), primaryFactory);
        IAreaFactory oceanFactory = OceanLayer.INSTANCE.func_202823_a(randomProvider.apply(2L));
        oceanFactory = BYGWorldLayerProvider.repeat(2001L, (IAreaTransformer1)ZoomLayer.NORMAL, oceanFactory, 6, randomProvider);
        primaryFactory = AddSnowLayer.INSTANCE.func_202713_a(randomProvider.apply(2L), primaryFactory);
        primaryFactory = AddIslandLayer.INSTANCE.func_202713_a(randomProvider.apply(3L), primaryFactory);
        primaryFactory = EdgeLayer.CoolWarm.INSTANCE.func_202713_a(randomProvider.apply(2L), primaryFactory);
        primaryFactory = EdgeLayer.HeatIce.INSTANCE.func_202713_a(randomProvider.apply(2L), primaryFactory);
        primaryFactory = EdgeLayer.Special.INSTANCE.func_202713_a(randomProvider.apply(3L), primaryFactory);
        primaryFactory = ZoomLayer.NORMAL.func_202713_a(randomProvider.apply(2002L), primaryFactory);
        primaryFactory = ZoomLayer.NORMAL.func_202713_a(randomProvider.apply(2003L), primaryFactory);
        primaryFactory = AddIslandLayer.INSTANCE.func_202713_a(randomProvider.apply(4L), primaryFactory);
        primaryFactory = AddMushroomIslandLayer.INSTANCE.func_202713_a(randomProvider.apply(5L), primaryFactory);
        primaryFactory = DeepOceanLayer.INSTANCE.func_202713_a(randomProvider.apply(4L), primaryFactory);
        primaryFactory = BYGWorldLayerProvider.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, primaryFactory, 0, randomProvider);
        IAreaFactory zoomFactory = BYGWorldLayerProvider.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, primaryFactory, 0, randomProvider);
        zoomFactory = StartRiverLayer.INSTANCE.func_202713_a(randomProvider.apply(100L), zoomFactory);
        IAreaFactory addBiomeFactory = new BiomeLayer(true).func_202713_a(randomProvider.apply(200L), primaryFactory);
        addBiomeFactory = AddBambooForestLayer.INSTANCE.func_202713_a(randomProvider.apply(1001L), addBiomeFactory);
        addBiomeFactory = BYGWorldLayerProvider.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, addBiomeFactory, 2, randomProvider);
        addBiomeFactory = EdgeBiomeLayer.INSTANCE.func_202713_a(randomProvider.apply(1000L), addBiomeFactory);
        IAreaFactory lvt_8_1_ = BYGWorldLayerProvider.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, zoomFactory, 2, randomProvider);
        addBiomeFactory = ModdedHillsLayer.INSTANCE.func_202707_a(randomProvider.apply(1000L), addBiomeFactory, lvt_8_1_);
        zoomFactory = BYGWorldLayerProvider.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, zoomFactory, 2, randomProvider);
        zoomFactory = BYGWorldLayerProvider.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, zoomFactory, 4, randomProvider);
        zoomFactory = RiverLayer.INSTANCE.func_202713_a(randomProvider.apply(1L), zoomFactory);
        zoomFactory = SmoothLayer.INSTANCE.func_202713_a(randomProvider.apply(1000L), zoomFactory);
        addBiomeFactory = RareBiomeLayer.INSTANCE.func_202713_a(randomProvider.apply(1001L), addBiomeFactory);
        for (int i = 0; i < (Integer)BYGWorldConfig.biomeSize.get(); ++i) {
            addBiomeFactory = ZoomLayer.NORMAL.func_202713_a(randomProvider.apply(1000 + i), addBiomeFactory);
            if (i == 0) {
                addBiomeFactory = AddIslandLayer.INSTANCE.func_202713_a(randomProvider.apply(3L), addBiomeFactory);
            }
            if (i != 1) continue;
            addBiomeFactory = ShoreLayer.INSTANCE.func_202713_a(randomProvider.apply(1000L), addBiomeFactory);
        }
        addBiomeFactory = SmoothLayer.INSTANCE.func_202713_a(randomProvider.apply(1000L), addBiomeFactory);
        addBiomeFactory = MixRiverLayer.INSTANCE.func_202707_a(randomProvider.apply(100L), addBiomeFactory, zoomFactory);
        IAreaFactory finalFactory = MixOceansLayer.INSTANCE.func_202707_a(randomProvider.apply(100L), addBiomeFactory, oceanFactory);
        return new Layer(finalFactory);
    }
}

