/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.world.surfacebuilders;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import voronoiaoc.byg.common.world.worldtype.noise.simplex.chunkgen.ChunkFastSimplexStyleNoise;
import voronoiaoc.byg.core.byglists.BYGSBList;

public class VolcanoSB
extends SurfaceBuilder<SurfaceBuilderConfig> {
    protected long seed;
    protected ChunkFastSimplexStyleNoise simplex;
    protected ChunkFastSimplexStyleNoise simplex2;

    public VolcanoSB(Codec<SurfaceBuilderConfig> config) {
        super(config);
    }

    public void buildSurface(Random random, IChunk chunkIn, Biome biomeIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
        BlockPos.Mutable block = new BlockPos.Mutable();
        int xPos = x & 0xF;
        int zPos = z & 0xF;
        double rawSimplexNoiseSample = this.octavedSimplex(x, z, 1.0f, 0.001f, 2, 0.5f);
        double simplexNoiseSample = rawSimplexNoiseSample * 65.0;
        double ridgedNoiseSample = 1.0 - 2.0 * Math.abs(simplexNoiseSample);
        if (ridgedNoiseSample > -4.0) {
            for (int yPos = startHeight - 20; yPos >= 170; --yPos) {
                block.func_181079_c(x, yPos, z);
                if (chunkIn.func_180495_p((BlockPos)block).func_177230_c() == Blocks.field_150350_a) continue;
                if (yPos >= 175) {
                    chunkIn.func_177436_a((BlockPos)block, Blocks.field_150350_a.func_176223_P(), false);
                    continue;
                }
                if (!(ridgedNoiseSample > -2.0) || !(-ridgedNoiseSample < 3.0)) continue;
                chunkIn.func_177436_a((BlockPos)block, Blocks.field_150353_l.func_176223_P(), false);
                chunkIn.func_212247_j().func_205360_a((BlockPos)block, (Object)Fluids.field_204547_b, 0);
            }
        }
        if (noise < 1.0) {
            SurfaceBuilder.field_215396_G.func_205610_a_(random, chunkIn, biomeIn, x, z, startHeight, noise, defaultBlock, defaultFluid, seaLevel, seed, (ISurfaceBuilderConfig)BYGSBList.BYGSBConfigList.BLACKSAND);
        } else {
            SurfaceBuilder.field_215396_G.func_205610_a_(random, chunkIn, biomeIn, x, z, startHeight, noise, defaultBlock, defaultFluid, seaLevel, seed, (ISurfaceBuilderConfig)VolcanoSB.randomSurfaceConfig(random));
        }
    }

    public void func_205548_a(long seed) {
        SharedSeedRandom sharedseedrandom;
        if (this.seed != seed || this.simplex == null) {
            sharedseedrandom = new SharedSeedRandom(seed);
            this.simplex = new ChunkFastSimplexStyleNoise((Random)sharedseedrandom);
        }
        if (this.seed != seed || this.simplex2 == null) {
            sharedseedrandom = new SharedSeedRandom(1999L + seed);
            this.simplex2 = new ChunkFastSimplexStyleNoise((Random)sharedseedrandom);
        }
        this.seed = seed;
    }

    public double octavedSimplex(int x, int y, float amp, float scale, int octaves, float change) {
        double height = 0.0;
        for (int i = 0; i < octaves; ++i) {
            height += (double)amp * this.simplex.sample2D((float)x * scale, (float)y * scale);
            scale /= change;
            amp *= change;
        }
        return height;
    }

    public static SurfaceBuilderConfig randomSurfaceConfig(Random random) {
        int randomizer = random.nextInt(3);
        if (randomizer == 1) {
            return BYGSBList.BYGSBConfigList.ROCKY;
        }
        return BYGSBList.BYGSBConfigList.STONEBLACKSAND;
    }
}

