/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.world.surfacebuilders;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import voronoiaoc.byg.common.world.worldtype.noise.simplex.chunkgen.ChunkFastSimplexStyleNoise;
import voronoiaoc.byg.core.byglists.BYGSBList;

public class SubterraneanCave
extends SurfaceBuilder<SurfaceBuilderConfig> {
    protected long seed;
    protected ChunkFastSimplexStyleNoise simplex;
    protected ChunkFastSimplexStyleNoise simplex2;

    public SubterraneanCave(Codec<SurfaceBuilderConfig> config) {
        super(config);
    }

    public void buildSurface(Random random, IChunk chunkIn, Biome biomeIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
        int randomer = random.nextInt(25);
        BlockPos.Mutable block = new BlockPos.Mutable();
        int xPos = x & 0xF;
        int zPos = z & 0xF;
        double rawSimplexNoiseSample = this.octavedSimplex(x, z, 1.0f, 0.01f, 4, 0.7f);
        double simplexNoiseSample = rawSimplexNoiseSample * 55.0;
        double simplexNoiseSample2 = rawSimplexNoiseSample * 2.0;
        if (randomer == 0) {
            int yPos = 256;
            while ((double)yPos >= simplexNoiseSample + 15.0) {
                block.func_181079_c(xPos, yPos, zPos);
                if (yPos > 5 && chunkIn.func_180495_p((BlockPos)block).func_177230_c() == Blocks.field_150348_b) {
                    chunkIn.func_177436_a((BlockPos)block, Blocks.field_150359_w.func_176223_P(), false);
                }
                --yPos;
            }
            SurfaceBuilder.field_215396_G.func_205610_a_(random, chunkIn, biomeIn, x, z, startHeight, noise, defaultBlock, defaultFluid, seaLevel, seed, (ISurfaceBuilderConfig)BYGSBList.BYGSBConfigList.TERRACOTTA_CF);
        } else {
            SurfaceBuilder.field_215396_G.func_205610_a_(random, chunkIn, biomeIn, x, z, startHeight, noise, defaultBlock, defaultFluid, seaLevel, seed, (ISurfaceBuilderConfig)BYGSBList.BYGSBConfigList.COARSE);
        }
    }

    public void func_205548_a(long seed) {
        SharedSeedRandom sharedseedrandom;
        if (this.seed != seed || this.simplex == null) {
            sharedseedrandom = new SharedSeedRandom(seed);
            this.simplex = new ChunkFastSimplexStyleNoise((Random)sharedseedrandom);
        }
        if (this.seed != seed || this.simplex2 == null) {
            sharedseedrandom = new SharedSeedRandom(1999L + seed);
            this.simplex2 = new ChunkFastSimplexStyleNoise((Random)sharedseedrandom);
        }
        this.seed = seed;
    }

    public double octavedSimplex(int x, int y, float amp, float scale, int octaves, float change) {
        double height = 0.0;
        for (int i = 0; i < octaves; ++i) {
            height += (double)amp * this.simplex.sample2D((float)x * scale, (float)y * scale);
            scale /= change;
            amp *= change;
        }
        return height;
    }
}

