/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.world.feature.features.overworld.trees.willow;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import voronoiaoc.byg.common.world.feature.features.overworld.trees.util.BYGAbstractTreeFeature;
import voronoiaoc.byg.core.byglists.BYGBlockList;

public class WillowTree1
extends BYGAbstractTreeFeature<NoFeatureConfig> {
    public WillowTree1(Codec<NoFeatureConfig> configIn) {
        super(configIn);
    }

    @Override
    protected boolean place(Set<BlockPos> changedBlocks, ISeedReader worldIn, Random rand, BlockPos pos, MutableBoundingBox boundsIn, boolean isSapling) {
        int randChance = rand.nextInt(2);
        int randTreeHeight = rand.nextInt(6) + 8;
        BlockPos blockPos = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        BlockPos.Mutable block = new BlockPos.Mutable().func_189533_g((Vector3i)blockPos);
        BlockPos.Mutable mainMutable = new BlockPos.Mutable().func_189533_g((Vector3i)block);
        if (pos.func_177956_o() + randTreeHeight + 1 < worldIn.func_217301_I()) {
            BlockPos.Mutable mutable;
            if (!WillowTree1.isDesiredGroundwDirtTag((IWorldGenerationBaseReader)worldIn, pos.func_177977_b(), Blocks.field_196658_i)) {
                return false;
            }
            if (!this.isAnotherTreeNearby((IWorldGenerationBaseReader)worldIn, pos, randTreeHeight, 0, isSapling)) {
                return false;
            }
            if (!this.doesSaplingHaveSpaceToGrow((IWorldGenerationBaseReader)worldIn, pos, randTreeHeight, 5, 5, 5, isSapling, new BlockPos[0])) {
                return false;
            }
            for (int i = 3; i <= randTreeHeight; ++i) {
                mutable = new BlockPos.Mutable().func_189533_g((Vector3i)block);
                this.setWillowLog(changedBlocks, worldIn, (BlockPos)mutable.func_189534_c(Direction.UP, i), boundsIn);
            }
            for (int baseSize = 0; baseSize < 4; ++baseSize) {
                mutable = new BlockPos.Mutable().func_189533_g((Vector3i)block.func_177981_b(3));
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    mutable.func_189533_g((Vector3i)block.func_177981_b(3).func_177967_a(direction, baseSize));
                    if (worldIn.func_180495_p((BlockPos)mutable).func_177230_c() == Blocks.field_150346_d) continue;
                    this.setWillowLog(changedBlocks, worldIn, (BlockPos)mutable.func_189534_c(Direction.DOWN, baseSize), boundsIn);
                }
            }
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189534_c(Direction.UP, randTreeHeight - 1).func_189536_c(Direction.SOUTH).func_189536_c(Direction.EAST), boundsIn);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189536_c(Direction.DOWN), boundsIn);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189534_c(Direction.UP, 2).func_189536_c(Direction.EAST), boundsIn);
            mainMutable.func_189533_g((Vector3i)block);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189534_c(Direction.UP, randTreeHeight - 1).func_189536_c(Direction.WEST), boundsIn);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189536_c(Direction.WEST).func_189536_c(Direction.UP).func_189536_c(Direction.NORTH), boundsIn);
            mainMutable.func_189533_g((Vector3i)block);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189534_c(Direction.UP, randTreeHeight - 2).func_189536_c(Direction.NORTH), boundsIn);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189536_c(Direction.UP).func_189536_c(Direction.NORTH), boundsIn);
            mainMutable.func_189533_g((Vector3i)block);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189534_c(Direction.UP, randTreeHeight - 2).func_189534_c(Direction.NORTH, 2).func_189536_c(Direction.WEST), boundsIn);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189536_c(Direction.WEST).func_189536_c(Direction.NORTH), boundsIn);
            mainMutable.func_189533_g((Vector3i)block);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189534_c(Direction.UP, randTreeHeight - 2).func_189534_c(Direction.NORTH, 2).func_189536_c(Direction.EAST), boundsIn);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189536_c(Direction.NORTH), boundsIn);
            mainMutable.func_189533_g((Vector3i)block);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189534_c(Direction.UP, randTreeHeight - 2).func_189536_c(Direction.NORTH).func_189534_c(Direction.EAST, 2), boundsIn);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189536_c(Direction.EAST), boundsIn);
            mainMutable.func_189533_g((Vector3i)block);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189534_c(Direction.UP, randTreeHeight - 2).func_189536_c(Direction.EAST), boundsIn);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189536_c(Direction.SOUTH), boundsIn);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189536_c(Direction.SOUTH), boundsIn);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189536_c(Direction.EAST).func_189536_c(Direction.SOUTH), boundsIn);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189534_c(Direction.WEST, 2), boundsIn);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189536_c(Direction.UP).func_189536_c(Direction.EAST), boundsIn);
            mainMutable.func_189533_g((Vector3i)block);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189534_c(Direction.UP, randTreeHeight - 2).func_189536_c(Direction.WEST), boundsIn);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189536_c(Direction.WEST), boundsIn);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189536_c(Direction.WEST).func_189536_c(Direction.UP), boundsIn);
            this.setWillowLog(changedBlocks, worldIn, (BlockPos)mainMutable.func_189534_c(Direction.EAST, 2).func_189536_c(Direction.NORTH).func_189536_c(Direction.DOWN), boundsIn);
            mainMutable.func_189533_g((Vector3i)block);
            this.setWillowLeaves(changedBlocks, worldIn, (BlockPos)mainMutable.func_189534_c(Direction.UP, randTreeHeight), boundsIn);
            for (int placeX = -3; placeX <= 3; ++placeX) {
                for (int placeZ = -3; placeZ <= 3; ++placeZ) {
                    if (placeX <= 2 && placeX >= -2 && placeZ <= 2 && placeZ >= -2) {
                        this.setWillowLeaves(changedBlocks, worldIn, mainMutable.func_177982_a(placeX, 0, placeZ), boundsIn);
                        this.setWillowLeaves(changedBlocks, worldIn, mainMutable.func_177982_a(3, 0, placeZ), boundsIn);
                        this.setWillowLeaves(changedBlocks, worldIn, mainMutable.func_177982_a(-3, 0, placeZ), boundsIn);
                        this.setWillowLeaves(changedBlocks, worldIn, mainMutable.func_177982_a(placeX, 0, 3), boundsIn);
                        this.setWillowLeaves(changedBlocks, worldIn, mainMutable.func_177982_a(placeX, 0, -3), boundsIn);
                        for (int placeY = -1; placeY >= -(rand.nextInt(4) + 2); --placeY) {
                            this.setWillowLeaves(changedBlocks, worldIn, mainMutable.func_177982_a(4, placeY, placeZ), boundsIn);
                            this.setWillowLeaves(changedBlocks, worldIn, mainMutable.func_177982_a(-4, placeY, placeZ), boundsIn);
                            this.setWillowLeaves(changedBlocks, worldIn, mainMutable.func_177982_a(placeX, placeY, 4), boundsIn);
                            this.setWillowLeaves(changedBlocks, worldIn, mainMutable.func_177982_a(placeX, placeY, -4), boundsIn);
                            this.setWillowLeaves(changedBlocks, worldIn, mainMutable.func_177982_a(3, placeY, 3), boundsIn);
                            this.setWillowLeaves(changedBlocks, worldIn, mainMutable.func_177982_a(-3, placeY, 3), boundsIn);
                            this.setWillowLeaves(changedBlocks, worldIn, mainMutable.func_177982_a(3, placeY, -3), boundsIn);
                            this.setWillowLeaves(changedBlocks, worldIn, mainMutable.func_177982_a(-3, placeY, -3), boundsIn);
                        }
                    }
                    if (placeX > 1 || placeX < -1 || placeZ > 1 || placeZ < -1) continue;
                    this.setWillowLeaves(changedBlocks, worldIn, mainMutable.func_177982_a(placeX, 1, placeZ), boundsIn);
                    this.setWillowLeaves(changedBlocks, worldIn, mainMutable.func_177982_a(placeX, 1, 2), boundsIn);
                    this.setWillowLeaves(changedBlocks, worldIn, mainMutable.func_177982_a(placeX, 1, -2), boundsIn);
                    this.setWillowLeaves(changedBlocks, worldIn, mainMutable.func_177982_a(2, 1, placeZ), boundsIn);
                    this.setWillowLeaves(changedBlocks, worldIn, mainMutable.func_177982_a(-2, 1, placeZ), boundsIn);
                }
            }
        }
        return true;
    }

    private void setWillowLog(Set<BlockPos> setlogblock, ISeedReader reader, BlockPos pos, MutableBoundingBox boundingBox) {
        if (this.canLogPlaceHereWater((IWorldGenerationBaseReader)reader, pos)) {
            this.setFinalBlockState(setlogblock, (IWorldWriter)reader, pos, BYGBlockList.WILLOW_LOG.func_176223_P(), boundingBox);
        }
    }

    private void setWillowLeaves(Set<BlockPos> blockPos, ISeedReader reader, BlockPos pos, MutableBoundingBox boundingBox) {
        BlockPos.Mutable blockpos = new BlockPos.Mutable().func_189533_g((Vector3i)pos);
        if (this.isAirOrWater((IWorldGenerationBaseReader)reader, (BlockPos)blockpos)) {
            this.setFinalBlockState(blockPos, (IWorldWriter)reader, (BlockPos)blockpos, BYGBlockList.WILLOW_LEAVES.func_176223_P(), boundingBox);
        }
    }

    private boolean doesTreeFit(IWorldGenerationBaseReader reader, BlockPos blockPos, int height) {
        int x = blockPos.func_177958_n();
        int y = blockPos.func_177956_o();
        int z = blockPos.func_177952_p();
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (int yOffset = 0; yOffset <= height + 1; ++yOffset) {
            int distance = 2;
            for (int xOffset = -distance; xOffset <= distance; ++xOffset) {
                for (int zOffset = -distance; zOffset <= distance; ++zOffset) {
                    if (this.canLogPlaceHereWater(reader, (BlockPos)pos.func_181079_c(x + xOffset, y + yOffset, z + zOffset))) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

