/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.world.feature.features.overworld.trees.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.shapes.BitSetVoxelShapePart;
import net.minecraft.util.math.shapes.VoxelShapePart;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.common.Tags;
import voronoiaoc.byg.core.byglists.BYGBlockList;

public abstract class BYGAbstractTreeFeature<T extends NoFeatureConfig>
extends Feature<T> {
    public static boolean doBlockNotify;

    public BYGAbstractTreeFeature(Codec<T> function) {
        super(function);
    }

    public static boolean canLogPlaceHere(IWorldGenerationBaseReader worldReader, BlockPos blockPos) {
        return worldReader.func_217375_a(blockPos, state -> state.func_196958_f() || state.func_235714_a_((ITag)BlockTags.field_206952_E) || state.func_185904_a() == Material.field_151585_k || state.func_185904_a() == Material.field_151582_l || state.func_185904_a() == Material.field_203243_f);
    }

    public boolean canLogPlaceHereWater(IWorldGenerationBaseReader worldReader, BlockPos blockPos) {
        return worldReader.func_217375_a(blockPos, state -> state.func_196958_f() || state.func_235714_a_((ITag)BlockTags.field_206952_E) || state.func_185904_a() == Material.field_151585_k || state.func_185904_a() == Material.field_151582_l || state.func_185904_a() == Material.field_203243_f || state.func_185904_a() == Material.field_151586_h);
    }

    public boolean isAnotherTreeHere(IWorldGenerationBaseReader worldReader, BlockPos blockPos) {
        return worldReader.func_217375_a(blockPos, state -> {
            Block block = state.func_177230_c();
            return block.func_203417_a((ITag)BlockTags.field_200031_h) || block.func_203417_a((ITag)BlockTags.field_206952_E);
        });
    }

    public boolean isAnotherTreeLikeThisHere(IWorldGenerationBaseReader worldReader, BlockPos blockPos, Block logBlock, Block leafBlock) {
        return worldReader.func_217375_a(blockPos, state -> {
            Block block = state.func_177230_c();
            return block == logBlock || block == leafBlock;
        });
    }

    public boolean canSaplingGrowHere(IWorldGenerationBaseReader reader, BlockPos pos) {
        return reader.func_217375_a(pos, state -> {
            Block block = state.func_177230_c();
            return block.func_203417_a((ITag)BlockTags.field_200031_h) || block.func_203417_a((ITag)BlockTags.field_206952_E) || state.func_196958_f() || state.func_185904_a() == Material.field_151585_k || state.func_185904_a() == Material.field_151582_l || state.func_185904_a() == Material.field_203243_f || state.func_185904_a() == Material.field_151584_j || state.func_185904_a() == Material.field_151578_c;
        });
    }

    public static boolean isAir(IWorldGenerationBaseReader reader, BlockPos pos) {
        return reader.func_217375_a(pos, AbstractBlock.AbstractBlockState::func_196958_f);
    }

    public boolean isAirOrWater(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, state -> state.func_196958_f() || state.func_177230_c() == Blocks.field_150355_j);
    }

    public static boolean isDesiredGroundwDirtTag(IWorldGenerationBaseReader reader, BlockPos pos, Block ... desiredGroundBlock) {
        return reader.func_217375_a(pos, state -> {
            Block block = state.func_177230_c();
            int n = 0;
            Block[] blockArray = desiredGroundBlock;
            int n2 = blockArray.length;
            if (n < n2) {
                Block block1 = blockArray[n];
                return block.func_203417_a((ITag)Tags.Blocks.DIRT) || block == block1;
            }
            return block.func_203417_a((ITag)Tags.Blocks.DIRT);
        });
    }

    public boolean isDesiredGround(IWorldGenerationBaseReader reader, BlockPos pos, Block ... desiredGroundBlock) {
        return reader.func_217375_a(pos, state -> {
            Block block = state.func_177230_c();
            int n = 0;
            Block[] blockArray = desiredGroundBlock;
            int n2 = blockArray.length;
            if (n < n2) {
                Block block1 = blockArray[n];
                return block == block1;
            }
            return false;
        });
    }

    public boolean doesSaplingHaveSpaceToGrow(IWorldGenerationBaseReader reader, BlockPos pos, int treeHeight, int canopyStartHeight, int xDistance, int zDistance, boolean isSapling, BlockPos ... trunkPositions) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        if (isSapling) {
            for (int yOffSet = 0; yOffSet <= treeHeight; ++yOffSet) {
                if (!this.canSaplingGrowHere(reader, (BlockPos)mutable.func_181079_c(x, y + yOffSet, z))) {
                    return false;
                }
                if (trunkPositions.length <= 0) continue;
                for (BlockPos trunkPos : trunkPositions) {
                    if (this.canSaplingGrowHere(reader, (BlockPos)mutable.func_181079_c(trunkPos.func_177958_n(), trunkPos.func_177956_o() + yOffSet, trunkPos.func_177952_p()))) continue;
                    return false;
                }
            }
            for (int yOffset = canopyStartHeight; yOffset <= treeHeight + 1; ++yOffset) {
                for (int xOffset = -xDistance; xOffset <= xDistance; ++xOffset) {
                    for (int zOffset = -zDistance; zOffset <= zDistance; ++zOffset) {
                        if (this.canSaplingGrowHere(reader, (BlockPos)mutable.func_181079_c(x + xOffset, y + yOffset, z + zOffset))) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean doesSaplingHaveSpaceToGrow(IWorldGenerationBaseReader reader, BlockPos pos, int treeHeight, int canopyStartHeight, int xNegativeDistance, int zNegativeDistance, int xPositiveDistance, int zPositiveDistance, boolean isSapling, BlockPos ... trunkPositions) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        if (isSapling) {
            for (int yOffSet = 0; yOffSet <= treeHeight; ++yOffSet) {
                if (!this.canSaplingGrowHere(reader, (BlockPos)mutable.func_181079_c(x, y + yOffSet, z))) {
                    return false;
                }
                if (trunkPositions.length <= 0) continue;
                for (BlockPos trunkPos : trunkPositions) {
                    if (this.canSaplingGrowHere(reader, (BlockPos)mutable.func_181079_c(trunkPos.func_177958_n(), trunkPos.func_177956_o() + yOffSet, trunkPos.func_177952_p()))) continue;
                    return false;
                }
            }
            for (int yOffset = canopyStartHeight; yOffset <= treeHeight + 1; ++yOffset) {
                for (int xOffset = -xNegativeDistance; xOffset <= xPositiveDistance; ++xOffset) {
                    for (int zOffset = -zNegativeDistance; zOffset <= zPositiveDistance; ++zOffset) {
                        if (this.canSaplingGrowHere(reader, (BlockPos)mutable.func_181079_c(x + xOffset, y + yOffset, z + zOffset))) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean isAnotherTreeNearby(IWorldGenerationBaseReader reader, BlockPos pos, int treeHeight, int distance, boolean isSapling) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        if (!isSapling) {
            for (int yOffset = 0; yOffset <= treeHeight + 1; ++yOffset) {
                for (int xOffset = -distance; xOffset <= distance; ++xOffset) {
                    for (int zOffset = -distance; zOffset <= distance; ++zOffset) {
                        if (!this.isAnotherTreeHere(reader, (BlockPos)mutable.func_181079_c(x + xOffset, y + yOffset, z + zOffset))) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean isAnotherTreeLikeThisNearby(IWorldGenerationBaseReader reader, BlockPos pos, int treeHeight, int distance, Block logBlock, Block leafBlock, boolean isSapling) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        if (!isSapling) {
            for (int yOffset = 0; yOffset <= treeHeight + 1; ++yOffset) {
                for (int xOffset = -distance; xOffset <= distance; ++xOffset) {
                    for (int zOffset = -distance; zOffset <= distance; ++zOffset) {
                        if (this.isAnotherTreeLikeThisHere(reader, (BlockPos)mutable.func_181079_c(x + xOffset, y + yOffset, z + zOffset), logBlock, leafBlock)) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public void buildTrunk(Set<BlockPos> treeBlocksSet, IWorldGenerationBaseReader reader, Block fillerBlock, Block earthBlock, MutableBoundingBox boundingBox, BlockPos ... trunkPositions) {
        if (trunkPositions.length > 0) {
            BlockPos.Mutable mutableTrunk = new BlockPos.Mutable();
            for (BlockPos trunkPos : trunkPositions) {
                mutableTrunk.func_189533_g((Vector3i)trunkPos);
                for (int fill = 1; fill <= 15; ++fill) {
                    if (BYGAbstractTreeFeature.canLogPlaceHere(reader, (BlockPos)mutableTrunk)) {
                        if (fill <= 7) {
                            this.setFinalBlockState(treeBlocksSet, (IWorldWriter)reader, (BlockPos)mutableTrunk, fillerBlock.func_176223_P(), boundingBox);
                        } else {
                            this.setFinalBlockState(treeBlocksSet, (IWorldWriter)reader, (BlockPos)mutableTrunk, earthBlock.func_176223_P(), boundingBox);
                        }
                    } else {
                        if (this.isDesiredGround(reader, (BlockPos)mutableTrunk, Blocks.field_196661_l, Blocks.field_150391_bh, BYGBlockList.PODZOL_DACITE, BYGBlockList.OVERGROWN_STONE, BYGBlockList.GLOWCELIUM)) {
                            this.setFinalBlockState(treeBlocksSet, (IWorldWriter)reader, (BlockPos)mutableTrunk, earthBlock.func_176223_P(), boundingBox);
                        }
                        fill = 15;
                    }
                    mutableTrunk.func_189536_c(Direction.DOWN);
                }
            }
        }
    }

    public void buildBase(Set<BlockPos> treeBlocksSet, IWorldGenerationBaseReader reader, int earthBlockThreshold, Block fillerBlock, Block earthBlock, MutableBoundingBox boundingBox, BlockPos ... trunkPositions) {
        if (trunkPositions.length > 0) {
            BlockPos.Mutable mutableTrunk = new BlockPos.Mutable();
            for (BlockPos trunkPos : trunkPositions) {
                mutableTrunk.func_189533_g((Vector3i)trunkPos);
                for (int fill = 1; fill <= 15; ++fill) {
                    if (BYGAbstractTreeFeature.canLogPlaceHere(reader, (BlockPos)mutableTrunk)) {
                        if (fill <= earthBlockThreshold) {
                            this.setFinalBlockState(treeBlocksSet, (IWorldWriter)reader, (BlockPos)mutableTrunk, fillerBlock.func_176223_P(), boundingBox);
                        } else {
                            this.setFinalBlockState(treeBlocksSet, (IWorldWriter)reader, (BlockPos)mutableTrunk, earthBlock.func_176223_P(), boundingBox);
                        }
                    } else if (BYGAbstractTreeFeature.canLogPlaceHere(reader, (BlockPos)mutableTrunk)) {
                        this.setFinalBlockState(treeBlocksSet, (IWorldWriter)reader, (BlockPos)mutableTrunk, fillerBlock.func_176223_P(), boundingBox);
                    } else {
                        if (this.isDesiredGround(reader, (BlockPos)mutableTrunk, Blocks.field_196661_l, Blocks.field_150391_bh, BYGBlockList.PODZOL_DACITE, BYGBlockList.OVERGROWN_STONE, BYGBlockList.GLOWCELIUM)) {
                            this.setFinalBlockState(treeBlocksSet, (IWorldWriter)reader, (BlockPos)mutableTrunk, earthBlock.func_176223_P(), boundingBox);
                        }
                        fill = 15;
                    }
                    mutableTrunk.func_189536_c(Direction.DOWN);
                }
            }
        }
    }

    public void setSoil(Set<BlockPos> treeBlocksSet, IWorldGenerationBaseReader reader, Block soil, MutableBoundingBox boundingBox, BlockPos ... trunkPositions) {
        if (trunkPositions.length > 0) {
            BlockPos.Mutable mutableTrunk = new BlockPos.Mutable();
            for (BlockPos trunkPos : trunkPositions) {
                mutableTrunk.func_189533_g((Vector3i)trunkPos);
                if (!this.isDesiredGround(reader, (BlockPos)mutableTrunk, Blocks.field_196661_l, Blocks.field_150391_bh, BYGBlockList.PODZOL_DACITE, BYGBlockList.OVERGROWN_STONE, BYGBlockList.GLOWCELIUM)) continue;
                this.setFinalBlockState(treeBlocksSet, (IWorldWriter)reader, (BlockPos)mutableTrunk.func_189536_c(Direction.DOWN), soil.func_176223_P(), boundingBox);
            }
        }
    }

    public final void setFinalBlockState(Set<BlockPos> changedBlocks, IWorldWriter worldIn, BlockPos pos, BlockState blockState, MutableBoundingBox boundingBox) {
        this.setBlockStateWithoutUpdates(worldIn, pos, blockState);
        boundingBox.func_78888_b(new MutableBoundingBox((Vector3i)pos, (Vector3i)pos));
        if (BlockTags.field_200031_h.func_230235_a_((Object)blockState.func_177230_c())) {
            changedBlocks.add(pos.func_185334_h());
        }
    }

    public void setBlockStateWithoutUpdates(IWorldWriter worldWriter, BlockPos blockPos, BlockState blockState) {
        worldWriter.func_180501_a(blockPos, blockState, 18);
    }

    public void func_230367_a_(IWorldWriter worldIn, BlockPos pos, BlockState state) {
        this.setBlockStateWithoutUpdates(worldIn, pos, state);
    }

    public boolean func_241855_a(ISeedReader worldIn, ChunkGenerator generator, Random rand, BlockPos pos, T config) {
        return this.placeTree(worldIn, generator, rand, pos, config, false);
    }

    public boolean placeTree(ISeedReader worldIn, ChunkGenerator generator, Random rand, BlockPos pos, T config, boolean isSapling) {
        HashSet set = Sets.newHashSet();
        MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_78887_a();
        boolean flag = this.place(set, worldIn, rand, pos, mutableboundingbox, isSapling);
        if (mutableboundingbox.field_78897_a > mutableboundingbox.field_78893_d) {
            return false;
        }
        ArrayList list = Lists.newArrayList();
        for (int j = 0; j < 6; ++j) {
            list.add(Sets.newHashSet());
        }
        BitSetVoxelShapePart voxelshapepart = new BitSetVoxelShapePart(mutableboundingbox.func_78883_b(), mutableboundingbox.func_78882_c(), mutableboundingbox.func_78880_d());
        try (PooledMutable blockpos$pooledmutableblockpos = PooledMutable.get();){
            if (flag && !set.isEmpty()) {
                for (BlockPos blockpos : Lists.newArrayList((Iterable)set)) {
                    if (mutableboundingbox.func_175898_b((Vector3i)blockpos)) {
                        voxelshapepart.func_199625_a(blockpos.func_177958_n() - mutableboundingbox.field_78897_a, blockpos.func_177956_o() - mutableboundingbox.field_78895_b, blockpos.func_177952_p() - mutableboundingbox.field_78896_c, true, true);
                    }
                    for (Direction direction : Direction.values()) {
                        BlockState blockstate;
                        blockpos$pooledmutableblockpos.func_189533_g((Vector3i)blockpos).func_189536_c(direction);
                        if (set.contains(blockpos$pooledmutableblockpos) || !(blockstate = worldIn.func_180495_p((BlockPos)blockpos$pooledmutableblockpos)).func_235901_b_((Property)BlockStateProperties.field_208514_aa)) continue;
                        ((Set)list.get(0)).add(blockpos$pooledmutableblockpos.func_185334_h());
                        this.setBlockStateWithoutUpdates((IWorldWriter)worldIn, (BlockPos)blockpos$pooledmutableblockpos, (BlockState)blockstate.func_206870_a((Property)BlockStateProperties.field_208514_aa, (Comparable)Integer.valueOf(1)));
                        if (!mutableboundingbox.func_175898_b((Vector3i)blockpos$pooledmutableblockpos)) continue;
                        voxelshapepart.func_199625_a(blockpos$pooledmutableblockpos.func_177958_n() - mutableboundingbox.field_78897_a, blockpos$pooledmutableblockpos.func_177956_o() - mutableboundingbox.field_78895_b, blockpos$pooledmutableblockpos.func_177952_p() - mutableboundingbox.field_78896_c, true, true);
                    }
                }
            }
            for (int l = 1; l < 6; ++l) {
                Set set1 = (Set)list.get(l - 1);
                Set set2 = (Set)list.get(l);
                for (BlockPos blockpos1 : set1) {
                    if (mutableboundingbox.func_175898_b((Vector3i)blockpos1)) {
                        voxelshapepart.func_199625_a(blockpos1.func_177958_n() - mutableboundingbox.field_78897_a, blockpos1.func_177956_o() - mutableboundingbox.field_78895_b, blockpos1.func_177952_p() - mutableboundingbox.field_78896_c, true, true);
                    }
                    for (Direction direction1 : Direction.values()) {
                        int k;
                        BlockState blockstate1;
                        blockpos$pooledmutableblockpos.func_189533_g((Vector3i)blockpos1).func_189536_c(direction1);
                        if (set1.contains(blockpos$pooledmutableblockpos) || set2.contains(blockpos$pooledmutableblockpos) || !(blockstate1 = worldIn.func_180495_p((BlockPos)blockpos$pooledmutableblockpos)).func_235901_b_((Property)BlockStateProperties.field_208514_aa) || (k = ((Integer)blockstate1.func_177229_b((Property)BlockStateProperties.field_208514_aa)).intValue()) <= l + 1) continue;
                        BlockState blockstate2 = (BlockState)blockstate1.func_206870_a((Property)BlockStateProperties.field_208514_aa, (Comparable)Integer.valueOf(l + 1));
                        this.setBlockStateWithoutUpdates((IWorldWriter)worldIn, (BlockPos)blockpos$pooledmutableblockpos, blockstate2);
                        if (mutableboundingbox.func_175898_b((Vector3i)blockpos$pooledmutableblockpos)) {
                            voxelshapepart.func_199625_a(blockpos$pooledmutableblockpos.func_177958_n() - mutableboundingbox.field_78897_a, blockpos$pooledmutableblockpos.func_177956_o() - mutableboundingbox.field_78895_b, blockpos$pooledmutableblockpos.func_177952_p() - mutableboundingbox.field_78896_c, true, true);
                        }
                        set2.add(blockpos$pooledmutableblockpos.func_185334_h());
                    }
                }
            }
        }
        Template.func_222857_a((IWorld)worldIn, (int)3, (VoxelShapePart)voxelshapepart, (int)mutableboundingbox.field_78897_a, (int)mutableboundingbox.field_78895_b, (int)mutableboundingbox.field_78896_c);
        return flag;
    }

    protected abstract boolean place(Set<BlockPos> var1, ISeedReader var2, Random var3, BlockPos var4, MutableBoundingBox var5, boolean var6);

    public static final class PooledMutable
    extends BlockPos.Mutable
    implements AutoCloseable {
        private boolean free;
        private static final List<PooledMutable> POOL = Lists.newArrayList();

        private PooledMutable(int x, int y, int z) {
            super(x, y, z);
        }

        public static PooledMutable get() {
            return PooledMutable.get(0, 0, 0);
        }

        public static PooledMutable get(double x, double y, double z) {
            return PooledMutable.get(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static PooledMutable get(int x, int y, int z) {
            List<PooledMutable> list = POOL;
            synchronized (list) {
                PooledMutable pooledMutable;
                if (!POOL.isEmpty() && (pooledMutable = POOL.remove(POOL.size() - 1)) != null && pooledMutable.free) {
                    pooledMutable.free = false;
                    pooledMutable.set(x, y, z);
                    return pooledMutable;
                }
            }
            return new PooledMutable(x, y, z);
        }

        public PooledMutable set(int i, int j, int k) {
            return (PooledMutable)super.func_181079_c(i, j, k);
        }

        public PooledMutable set(double d, double e, double f) {
            return (PooledMutable)super.func_189532_c(d, e, f);
        }

        public PooledMutable set(Vector3i vec3i) {
            return (PooledMutable)super.func_189533_g(vec3i);
        }

        public PooledMutable setOffset(Direction direction) {
            return this.setOffset(direction, 1);
        }

        public PooledMutable setOffset(Direction direction, int distance) {
            return this.set(this.func_177958_n() + direction.func_82601_c() * distance, this.func_177956_o() + direction.func_96559_d() * distance, this.func_177952_p() + direction.func_82599_e() * distance);
        }

        public BlockPos.Mutable setOffset(int x, int y, int z) {
            return this.set(this.func_177958_n() + x, this.func_177956_o() + y, this.func_177952_p() + z);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            List<PooledMutable> list = POOL;
            synchronized (list) {
                if (POOL.size() < 100) {
                    POOL.add(this);
                }
                this.free = true;
            }
        }
    }
}

