/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.world.feature.features.overworld.trees.tropical;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.VineBlock;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import voronoiaoc.byg.common.world.feature.features.overworld.trees.util.BYGAbstractTreeFeature;
import voronoiaoc.byg.core.byglists.BYGBlockList;

public class TropicalRainForestTree
extends BYGAbstractTreeFeature<NoFeatureConfig> {
    private static final BlockState LOG = BYGBlockList.MAHOGANY_LOG.func_176223_P();
    private static final BlockState LEAVES = BYGBlockList.MAHOGANY_LEAVES.func_176223_P();
    private static final BlockState BEENEST = Blocks.field_226905_ma_.func_176223_P();

    public TropicalRainForestTree(Codec<NoFeatureConfig> configIn) {
        super(configIn);
    }

    protected static boolean canTreePlace(IWorldGenerationBaseReader genBaseReader, BlockPos blockPos) {
        return TropicalRainForestTree.canLogPlaceHere(genBaseReader, blockPos);
    }

    @Override
    public boolean place(Set<BlockPos> changedBlocks, ISeedReader worldIn, Random rand, BlockPos pos, MutableBoundingBox boundsIn, boolean isSapling) {
        int randTreeHeight = rand.nextInt(3) + rand.nextInt(3) + 8;
        int posX = pos.func_177958_n();
        int posY = pos.func_177956_o();
        int posZ = pos.func_177952_p();
        if (posY >= 1 && posY + randTreeHeight + 1 < 256) {
            int posZLeafWidthL0;
            int posXLeafWidth;
            int leavessquarespos;
            BlockPos checkGround = pos.func_177977_b();
            if (!TropicalRainForestTree.isDesiredGroundwDirtTag((IWorldGenerationBaseReader)worldIn, checkGround, Blocks.field_196658_i)) {
                return false;
            }
            Direction direction = Direction.Plane.HORIZONTAL.func_179518_a(rand);
            int randTreeHeight2 = randTreeHeight - rand.nextInt(1);
            int posY1 = 2 - rand.nextInt(1);
            int posX1 = posX;
            int posZ1 = posZ;
            int topTrunkHeight = posY + randTreeHeight - 1;
            for (int buildTrunk = 0; buildTrunk < randTreeHeight; ++buildTrunk) {
                if (buildTrunk >= randTreeHeight2 && posY1 < 0) {
                    posX1 += direction.func_82601_c();
                    posZ1 += direction.func_82599_e();
                    ++posY1;
                }
                int logplacer = posY + buildTrunk;
                int logplacer1 = posY + randTreeHeight;
                int logplacer2 = posY + buildTrunk - rand.nextInt(6);
                BlockPos blockpos1 = new BlockPos(posX1, logplacer, posZ1);
                BlockPos blockpos2 = new BlockPos(posX1, logplacer1, posZ1);
                BlockPos blockpos3 = new BlockPos(posX1, logplacer2, posZ1);
                this.treelog(changedBlocks, worldIn, blockpos1, boundsIn);
                this.treelog(changedBlocks, worldIn, blockpos2.func_177976_e(), boundsIn);
                this.treelog(changedBlocks, worldIn, blockpos2.func_177974_f(), boundsIn);
                this.treelog(changedBlocks, worldIn, blockpos2.func_177978_c(), boundsIn);
                this.treelog(changedBlocks, worldIn, blockpos2.func_177968_d(), boundsIn);
                this.treelog(changedBlocks, worldIn, blockpos2.func_177976_e().func_177984_a(), boundsIn);
                this.treelog(changedBlocks, worldIn, blockpos2.func_177974_f().func_177984_a(), boundsIn);
                this.treelog(changedBlocks, worldIn, blockpos2.func_177978_c().func_177984_a(), boundsIn);
                this.treelog(changedBlocks, worldIn, blockpos2.func_177968_d().func_177984_a(), boundsIn);
                this.treelog(changedBlocks, worldIn, blockpos2.func_177985_f(2).func_177981_b(2), boundsIn);
                this.treelog(changedBlocks, worldIn, blockpos2.func_177965_g(2).func_177981_b(2), boundsIn);
                this.treelog(changedBlocks, worldIn, blockpos2.func_177964_d(2).func_177981_b(2), boundsIn);
                this.treelog(changedBlocks, worldIn, blockpos2.func_177970_e(2).func_177981_b(2), boundsIn);
                this.treelog(changedBlocks, worldIn, blockpos2.func_177985_f(2).func_177981_b(3), boundsIn);
                this.treelog(changedBlocks, worldIn, blockpos2.func_177965_g(2).func_177981_b(3), boundsIn);
                this.treelog(changedBlocks, worldIn, blockpos2.func_177964_d(2).func_177981_b(3), boundsIn);
                this.treelog(changedBlocks, worldIn, blockpos2.func_177970_e(2).func_177981_b(3), boundsIn);
                this.treelog(changedBlocks, worldIn, blockpos2.func_177985_f(2).func_177981_b(4), boundsIn);
                this.treelog(changedBlocks, worldIn, blockpos2.func_177965_g(2).func_177981_b(4), boundsIn);
                this.treelog(changedBlocks, worldIn, blockpos2.func_177964_d(2).func_177981_b(4), boundsIn);
                this.treelog(changedBlocks, worldIn, blockpos2.func_177970_e(2).func_177981_b(4), boundsIn);
                this.treelog(changedBlocks, worldIn, blockpos2.func_177985_f(2).func_177981_b(5), boundsIn);
                this.treelog(changedBlocks, worldIn, blockpos2.func_177965_g(2).func_177981_b(5), boundsIn);
                this.treelog(changedBlocks, worldIn, blockpos2.func_177964_d(2).func_177981_b(5), boundsIn);
                this.treelog(changedBlocks, worldIn, blockpos2.func_177970_e(2).func_177981_b(5), boundsIn);
                if (rand.nextInt(4) == 2) {
                    this.tryPlaceVines(worldIn, rand, blockpos3.func_177976_e(), VineBlock.field_176278_M);
                    continue;
                }
                if (rand.nextInt(2) != 1) continue;
                this.tryPlaceVines(worldIn, rand, blockpos3.func_177974_f(), VineBlock.field_176280_O);
                this.tryPlaceVines(worldIn, rand, blockpos3.func_177978_c(), VineBlock.field_176279_N);
            }
            int leavePreset = 1;
            if (leavePreset == 1) {
                leavessquarespos = 1;
                for (posXLeafWidth = -leavessquarespos; posXLeafWidth <= leavessquarespos; ++posXLeafWidth) {
                    for (posZLeafWidthL0 = -leavessquarespos; posZLeafWidthL0 <= leavessquarespos; ++posZLeafWidthL0) {
                        this.leafs(worldIn, posX1 + posXLeafWidth, topTrunkHeight + 5, posZ1 + posZLeafWidthL0, boundsIn, changedBlocks);
                        this.leafs(worldIn, posX1 + posXLeafWidth - 3, topTrunkHeight + 5, posZ1 + posZLeafWidthL0, boundsIn, changedBlocks);
                        this.leafs(worldIn, posX1 + posXLeafWidth + 3, topTrunkHeight + 5, posZ1 + posZLeafWidthL0, boundsIn, changedBlocks);
                        this.leafs(worldIn, posX1 + posXLeafWidth, topTrunkHeight + 5, posZ1 + posZLeafWidthL0 + 3, boundsIn, changedBlocks);
                        this.leafs(worldIn, posX1 + posXLeafWidth, topTrunkHeight + 5, posZ1 + posZLeafWidthL0 - 3, boundsIn, changedBlocks);
                        this.leafs(worldIn, posX1 + posXLeafWidth - 3, topTrunkHeight + 5, posZ1 + posZLeafWidthL0 - 2, boundsIn, changedBlocks);
                        this.leafs(worldIn, posX1 + posXLeafWidth + 3, topTrunkHeight + 5, posZ1 + posZLeafWidthL0 + 2, boundsIn, changedBlocks);
                        this.leafs(worldIn, posX1 + posXLeafWidth - 2, topTrunkHeight + 5, posZ1 + posZLeafWidthL0 + 3, boundsIn, changedBlocks);
                        this.leafs(worldIn, posX1 + posXLeafWidth + 2, topTrunkHeight + 5, posZ1 + posZLeafWidthL0 - 3, boundsIn, changedBlocks);
                        this.leafs(worldIn, posX1 + posXLeafWidth - 3, topTrunkHeight + 5, posZ1 + posZLeafWidthL0 + 2, boundsIn, changedBlocks);
                        this.leafs(worldIn, posX1 + posXLeafWidth + 3, topTrunkHeight + 5, posZ1 + posZLeafWidthL0 - 2, boundsIn, changedBlocks);
                        this.leafs(worldIn, posX1 + posXLeafWidth + 2, topTrunkHeight + 5, posZ1 + posZLeafWidthL0 + 3, boundsIn, changedBlocks);
                        this.leafs(worldIn, posX1 + posXLeafWidth - 2, topTrunkHeight + 5, posZ1 + posZLeafWidthL0 - 3, boundsIn, changedBlocks);
                        this.leafs(worldIn, posX1 + posXLeafWidth, topTrunkHeight + 6, posZ1 + posZLeafWidthL0, boundsIn, changedBlocks);
                        this.leafs(worldIn, posX1 + posXLeafWidth - 2, topTrunkHeight + 6, posZ1 + posZLeafWidthL0, boundsIn, changedBlocks);
                        this.leafs(worldIn, posX1 + posXLeafWidth + 2, topTrunkHeight + 6, posZ1 + posZLeafWidthL0, boundsIn, changedBlocks);
                        this.leafs(worldIn, posX1 + posXLeafWidth, topTrunkHeight + 6, posZ1 + posZLeafWidthL0 + 2, boundsIn, changedBlocks);
                        this.leafs(worldIn, posX1 + posXLeafWidth, topTrunkHeight + 6, posZ1 + posZLeafWidthL0 - 2, boundsIn, changedBlocks);
                        this.leafs(worldIn, posX1 + posXLeafWidth - 1, topTrunkHeight + 6, posZ1 + posZLeafWidthL0 - 1, boundsIn, changedBlocks);
                        this.leafs(worldIn, posX1 + posXLeafWidth + 1, topTrunkHeight + 6, posZ1 + posZLeafWidthL0 + 1, boundsIn, changedBlocks);
                        this.leafs(worldIn, posX1 + posXLeafWidth - 1, topTrunkHeight + 6, posZ1 + posZLeafWidthL0 + 1, boundsIn, changedBlocks);
                        this.leafs(worldIn, posX1 + posXLeafWidth + 1, topTrunkHeight + 6, posZ1 + posZLeafWidthL0 - 1, boundsIn, changedBlocks);
                        this.leafs(worldIn, posX1 + posXLeafWidth - 1, topTrunkHeight + 6, posZ1 + posZLeafWidthL0 + 1, boundsIn, changedBlocks);
                        this.leafs(worldIn, posX1 + posXLeafWidth + 1, topTrunkHeight + 6, posZ1 + posZLeafWidthL0 - 1, boundsIn, changedBlocks);
                        this.leafs(worldIn, posX1 + posXLeafWidth + 1, topTrunkHeight + 6, posZ1 + posZLeafWidthL0 + 1, boundsIn, changedBlocks);
                        this.leafs(worldIn, posX1 + posXLeafWidth - 1, topTrunkHeight + 6, posZ1 + posZLeafWidthL0 - 1, boundsIn, changedBlocks);
                        this.leafs(worldIn, posX1 + posXLeafWidth, topTrunkHeight + 7, posZ1 + posZLeafWidthL0, boundsIn, changedBlocks);
                        this.leafs(worldIn, posX1 + posXLeafWidth - 1, topTrunkHeight + 7, posZ1 + posZLeafWidthL0, boundsIn, changedBlocks);
                        this.leafs(worldIn, posX1 + posXLeafWidth + 1, topTrunkHeight + 7, posZ1 + posZLeafWidthL0, boundsIn, changedBlocks);
                        this.leafs(worldIn, posX1 + posXLeafWidth, topTrunkHeight + 7, posZ1 + posZLeafWidthL0 + 1, boundsIn, changedBlocks);
                        this.leafs(worldIn, posX1 + posXLeafWidth, topTrunkHeight + 7, posZ1 + posZLeafWidthL0 - 1, boundsIn, changedBlocks);
                        this.leafs(worldIn, posX1 + posXLeafWidth, topTrunkHeight + 8, posZ1 + posZLeafWidthL0, boundsIn, changedBlocks);
                    }
                }
            } else if (leavePreset == 2) {
                leavessquarespos = rand.nextInt(1) + 1;
                for (posXLeafWidth = leavessquarespos * -1; posXLeafWidth <= leavessquarespos; ++posXLeafWidth) {
                    for (posZLeafWidthL0 = leavessquarespos * -1; posZLeafWidthL0 <= leavessquarespos; ++posZLeafWidthL0) {
                        this.leafs(worldIn, posX1 + posXLeafWidth, topTrunkHeight + 6, posZ1 + posZLeafWidthL0, boundsIn, changedBlocks);
                        this.leafs(worldIn, posX1 + 2, topTrunkHeight - 1, posZ1, boundsIn, changedBlocks);
                    }
                }
            } else if (leavePreset == 3) {
                leavessquarespos = rand.nextInt(1) + 1;
                for (posXLeafWidth = -leavessquarespos; posXLeafWidth <= leavessquarespos; ++posXLeafWidth) {
                    for (posZLeafWidthL0 = -leavessquarespos; posZLeafWidthL0 <= leavessquarespos; ++posZLeafWidthL0) {
                    }
                }
            }
            return true;
        }
        return false;
    }

    private boolean doesTreeFit(IWorldGenerationBaseReader reader, BlockPos blockPos, int height) {
        int x = blockPos.func_177958_n();
        int y = blockPos.func_177956_o();
        int z = blockPos.func_177952_p();
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (int yOffset = 0; yOffset <= height + 1; ++yOffset) {
            int distance = 0;
            for (int xOffset = -distance; xOffset <= distance; ++xOffset) {
                for (int zOffset = -distance; zOffset <= distance; ++zOffset) {
                    if (TropicalRainForestTree.canTreePlace(reader, (BlockPos)pos.func_181079_c(x + xOffset, y + yOffset, z + zOffset))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void treelog(Set<BlockPos> setlogblock, ISeedReader reader, BlockPos pos, MutableBoundingBox boundingBox) {
        if (TropicalRainForestTree.canTreePlace((IWorldGenerationBaseReader)reader, pos)) {
            this.setFinalBlockState(setlogblock, (IWorldWriter)reader, pos, LOG, boundingBox);
        }
    }

    private void leafs(ISeedReader reader, int x, int y, int z, MutableBoundingBox boundingBox, Set<BlockPos> blockPos) {
        BlockPos leafpos = new BlockPos(x, y, z);
        if (TropicalRainForestTree.isAir((IWorldGenerationBaseReader)reader, leafpos)) {
            this.setFinalBlockState(blockPos, (IWorldWriter)reader, leafpos, LEAVES, boundingBox);
        }
    }

    private void tryPlaceVines(ISeedReader worldIn, Random random, BlockPos pos, BooleanProperty sideProperty) {
        if (random.nextInt(3) > 0 && TropicalRainForestTree.isAir((IWorldGenerationBaseReader)worldIn, pos)) {
            this.func_230367_a_((IWorldWriter)worldIn, pos, (BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((Property)sideProperty, (Comparable)Boolean.valueOf(true)));
        }
    }
}

