/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.world.feature.features.overworld.trees.palm;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import voronoiaoc.byg.common.world.feature.features.overworld.trees.util.BYGAbstractTreeFeature;

public class PalmTree1
extends BYGAbstractTreeFeature<NoFeatureConfig> {
    private static final BlockState LOG = Blocks.field_196620_N.func_176223_P();
    private static final BlockState LEAVES = Blocks.field_196648_Z.func_176223_P();
    private static final BlockState BEENEST = Blocks.field_226905_ma_.func_176223_P();

    public PalmTree1(Codec<NoFeatureConfig> configIn) {
        super(configIn);
    }

    @Override
    public boolean place(Set<BlockPos> changedBlocks, ISeedReader worldIn, Random rand, BlockPos pos, MutableBoundingBox boundsIn, boolean isSapling) {
        int randTreeHeight = 3 + rand.nextInt(3);
        int posX = pos.func_177958_n();
        int posY = pos.func_177956_o();
        int posZ = pos.func_177952_p();
        if (posY >= 1 && posY + randTreeHeight + 1 < 256) {
            if (!PalmTree1.isDesiredGroundwDirtTag((IWorldGenerationBaseReader)worldIn, pos.func_177977_b(), Blocks.field_196658_i)) {
                return false;
            }
            if (!this.isAnotherTreeNearby((IWorldGenerationBaseReader)worldIn, pos, randTreeHeight, 0, isSapling)) {
                return false;
            }
            if (!this.doesSaplingHaveSpaceToGrow((IWorldGenerationBaseReader)worldIn, pos, randTreeHeight, 5, 5, 5, isSapling, new BlockPos[0])) {
                return false;
            }
            Direction direction = Direction.Plane.HORIZONTAL.func_179518_a(rand);
            int randTreeHeight2 = randTreeHeight - rand.nextInt(1);
            int posY1 = 2 - rand.nextInt(1);
            int posX1 = posX;
            int posZ1 = posZ;
            int topTrunkHeight = posY + randTreeHeight - 1;
            for (int buildTrunk = 0; buildTrunk < randTreeHeight; ++buildTrunk) {
                if (buildTrunk >= randTreeHeight2 && posY1 < 0) {
                    posX1 += direction.func_82601_c();
                    posZ1 += direction.func_82599_e();
                    ++posY1;
                }
                int logplacer = posY + buildTrunk;
                int logplacer2 = posY + buildTrunk + randTreeHeight;
                BlockPos blockpos1 = new BlockPos(posX1, logplacer, posZ1);
                BlockPos blockpos2 = new BlockPos(posX1, logplacer2, posZ1);
                this.treelog(changedBlocks, worldIn, blockpos1, boundsIn);
                this.treelog(changedBlocks, worldIn, blockpos2.func_177978_c().func_177976_e(), boundsIn);
            }
            int leavePreset = rand.nextInt(1) + 1;
            if (leavePreset == 1) {
                int leavessquarespos = rand.nextInt(1) + 1;
                for (int posXLeafWidth = -leavessquarespos; posXLeafWidth <= leavessquarespos; ++posXLeafWidth) {
                    for (int posZLeafWidthL0 = -leavessquarespos; posZLeafWidthL0 <= leavessquarespos; ++posZLeafWidthL0) {
                    }
                }
            }
            return true;
        }
        return false;
    }

    private boolean doesTreeFit(IWorldGenerationBaseReader reader, BlockPos blockPos, int height) {
        int x = blockPos.func_177958_n();
        int y = blockPos.func_177956_o();
        int z = blockPos.func_177952_p();
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (int yOffset = 0; yOffset <= height + 1; ++yOffset) {
            int distance = 0;
            for (int xOffset = -distance; xOffset <= distance; ++xOffset) {
                for (int zOffset = -distance; zOffset <= distance; ++zOffset) {
                    if (PalmTree1.canLogPlaceHere(reader, (BlockPos)pos.func_181079_c(x + xOffset, y + yOffset, z + zOffset))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void treelog(Set<BlockPos> setlogblock, ISeedReader reader, BlockPos pos, MutableBoundingBox boundingBox) {
        if (PalmTree1.canLogPlaceHere((IWorldGenerationBaseReader)reader, pos)) {
            this.setFinalBlockState(setlogblock, (IWorldWriter)reader, pos, LOG, boundingBox);
        }
    }

    private void leafs(ISeedReader reader, int x, int y, int z, MutableBoundingBox boundingBox, Set<BlockPos> blockPos) {
        BlockPos blockpos = new BlockPos(x, y, z);
        if (PalmTree1.isAir((IWorldGenerationBaseReader)reader, blockpos)) {
            this.setFinalBlockState(blockPos, (IWorldWriter)reader, blockpos, LEAVES, boundingBox);
        }
    }
}

