/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.world.feature.features.overworld.trees.deadhazel;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import voronoiaoc.byg.common.world.feature.features.overworld.trees.util.BYGAbstractTreeFeature;
import voronoiaoc.byg.core.byglists.BYGBlockList;

public class DeadHazel4
extends BYGAbstractTreeFeature<NoFeatureConfig> {
    public DeadHazel4(Codec<NoFeatureConfig> configIn) {
        super(configIn);
    }

    @Override
    protected boolean place(Set<BlockPos> changedBlocks, ISeedReader worldIn, Random rand, BlockPos pos, MutableBoundingBox boundsIn, boolean isSapling) {
        int randTreeHeight = 7 + rand.nextInt(5);
        BlockPos.Mutable mainmutable = new BlockPos.Mutable().func_189533_g((Vector3i)pos);
        if (pos.func_177956_o() + randTreeHeight + 1 < worldIn.func_217301_I()) {
            if (!DeadHazel4.isDesiredGroundwDirtTag((IWorldGenerationBaseReader)worldIn, pos.func_177977_b(), Blocks.field_196658_i)) {
                return false;
            }
            if (!this.isAnotherTreeNearby((IWorldGenerationBaseReader)worldIn, pos, randTreeHeight, 0, isSapling)) {
                return false;
            }
            if (!this.doesSaplingHaveSpaceToGrow((IWorldGenerationBaseReader)worldIn, pos, randTreeHeight, 5, 5, 5, isSapling, new BlockPos[0])) {
                return false;
            }
            for (int buildTrunk = 0; buildTrunk <= randTreeHeight; ++buildTrunk) {
                this.treeLog(changedBlocks, worldIn, (BlockPos)mainmutable, boundsIn);
                mainmutable.func_189536_c(Direction.UP);
            }
            mainmutable.func_189533_g((Vector3i)pos);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(-1, 0, -2), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(0, 0, -2), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(1, 0, -2), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(-1, 0, -1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(0, 0, -1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(3, 0, -1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(-2, 0, 0), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(-1, 0, 0), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(1, 0, 0), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(-1, 0, 1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(0, 0, 1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(1, 0, 1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(0, 1, -2), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(-1, 1, -1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(0, 1, -1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(1, 1, -1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(2, 1, -1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(-1, 1, 0), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(1, 1, 0), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(0, 1, 1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(-1, 2, -1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(0, 2, -1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(0, 3, -1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(0, randTreeHeight, -1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(-2, randTreeHeight, 0), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(-1, randTreeHeight, 0), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(1, randTreeHeight, 0), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(2, randTreeHeight, 0), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(-1, randTreeHeight, 1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(-4, randTreeHeight + 1, -1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(-3, randTreeHeight + 1, -1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(0, randTreeHeight + 1, -1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(2, randTreeHeight + 1, 0), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(3, randTreeHeight + 1, 0), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(4, randTreeHeight + 1, 0), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(-1, randTreeHeight + 1, 1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(0, randTreeHeight + 1, 1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(0, randTreeHeight + 1, 2), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(-2, randTreeHeight + 2, -4), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(-3, randTreeHeight + 2, -3), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(-3, randTreeHeight + 2, -2), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(0, randTreeHeight + 2, -2), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(3, randTreeHeight + 2, -2), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(3, randTreeHeight + 2, -1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(-1, randTreeHeight + 2, 1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(2, randTreeHeight + 2, 1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(5, randTreeHeight + 2, 1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(1, randTreeHeight + 2, 3), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(1, randTreeHeight + 2, 4), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(4, randTreeHeight + 3, -3), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(0, randTreeHeight + 3, -2), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(-2, randTreeHeight + 3, 1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(3, randTreeHeight + 3, 2), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(3, randTreeHeight + 3, 3), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(-2, randTreeHeight + 1, 1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(1, randTreeHeight - 2, 0), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(1, randTreeHeight - 1, 0), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-2, randTreeHeight - 1, 1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-3, randTreeHeight, -1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(4, randTreeHeight, -1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-2, randTreeHeight, 1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(0, randTreeHeight, 1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-3, randTreeHeight + 1, -3), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(2, randTreeHeight + 1, -2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-1, randTreeHeight + 1, -1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(4, randTreeHeight + 1, -1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(0, randTreeHeight + 1, 0), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(1, randTreeHeight + 1, 3), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(3, randTreeHeight + 1, 3), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-3, randTreeHeight + 2, -4), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-2, randTreeHeight + 2, -3), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(2, randTreeHeight + 2, -2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(3, randTreeHeight + 2, 1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-1, randTreeHeight + 2, 2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(3, randTreeHeight + 2, 3), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-3, randTreeHeight + 3, -4), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(3, randTreeHeight + 3, -1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-1, randTreeHeight + 3, 1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(4, randTreeHeight + 3, 2), boundsIn);
        }
        return true;
    }

    private void treeLog(Set<BlockPos> setlogblock, ISeedReader reader, BlockPos pos, MutableBoundingBox boundingBox) {
        if (DeadHazel4.canLogPlaceHere((IWorldGenerationBaseReader)reader, pos)) {
            this.setFinalBlockState(setlogblock, (IWorldWriter)reader, pos, BYGBlockList.WITCH_HAZEL_LOG.func_176223_P(), boundingBox);
        }
    }

    private void treeBranch(Set<BlockPos> setlogblock, ISeedReader reader, BlockPos pos, MutableBoundingBox boundingBox) {
        if (DeadHazel4.canLogPlaceHere((IWorldGenerationBaseReader)reader, pos)) {
            this.setFinalBlockState(setlogblock, (IWorldWriter)reader, pos, BYGBlockList.WITCH_HAZEL_LOG.func_176223_P(), boundingBox);
        }
    }

    private void leafs(Set<BlockPos> blockPos, ISeedReader reader, BlockPos pos, MutableBoundingBox boundingBox) {
        BlockPos.Mutable blockpos = new BlockPos.Mutable().func_189533_g((Vector3i)pos);
        if (DeadHazel4.isAir((IWorldGenerationBaseReader)reader, (BlockPos)blockpos)) {
            this.setFinalBlockState(blockPos, (IWorldWriter)reader, (BlockPos)blockpos, this.randomLeaves(), boundingBox);
        }
    }

    public BlockState randomLeaves() {
        Random random = new Random();
        int randomizer = random.nextInt(25);
        if (randomizer == 1) {
            return BYGBlockList.BLOOMING_WITCH_HAZEL_LEAVES.func_176223_P();
        }
        if (randomizer == 0) {
            return BYGBlockList.BLOOMING_WITCH_HAZEL_LEAVES.func_176223_P();
        }
        return BYGBlockList.WITCH_HAZEL_LEAVES.func_176223_P();
    }

    private boolean doesTreeFit(IWorldGenerationBaseReader reader, BlockPos blockPos, int height) {
        int x = blockPos.func_177958_n();
        int y = blockPos.func_177956_o();
        int z = blockPos.func_177952_p();
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (int yOffset = 0; yOffset <= height + 1; ++yOffset) {
            int distance = 2;
            for (int xOffset = -distance; xOffset <= distance; ++xOffset) {
                for (int zOffset = -distance; zOffset <= distance; ++zOffset) {
                    if (DeadHazel4.canLogPlaceHere(reader, (BlockPos)pos.func_181079_c(x + xOffset, y + yOffset, z + zOffset))) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

