/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.world.feature.features.overworld.trees.aspen;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import voronoiaoc.byg.common.world.feature.features.overworld.trees.util.BYGAbstractTreeFeature;
import voronoiaoc.byg.core.byglists.BYGBlockList;

public class AspenShrub2
extends BYGAbstractTreeFeature<NoFeatureConfig> {
    public AspenShrub2(Codec<NoFeatureConfig> configIn) {
        super(configIn);
    }

    @Override
    public boolean place(Set<BlockPos> changedBlocks, ISeedReader worldIn, Random rand, BlockPos pos, MutableBoundingBox boundsIn, boolean isSapling) {
        int randTreeHeight = rand.nextInt(1) + 1;
        int posX = pos.func_177958_n();
        int posY = pos.func_177956_o();
        int posZ = pos.func_177952_p();
        if (posY >= 1 && posY + randTreeHeight + 1 < worldIn.func_217301_I()) {
            if (!AspenShrub2.isDesiredGroundwDirtTag((IWorldGenerationBaseReader)worldIn, pos.func_177977_b(), Blocks.field_196658_i)) {
                return false;
            }
            Direction direction = Direction.Plane.HORIZONTAL.func_179518_a(rand);
            int randTreeHeight2 = randTreeHeight - rand.nextInt(1);
            int posY1 = 2 - rand.nextInt(1);
            int posX1 = posX;
            int posZ1 = posZ;
            int topTrunkHeight = posY + randTreeHeight - 1;
            for (int buildTrunk = 0; buildTrunk < randTreeHeight; ++buildTrunk) {
                if (buildTrunk >= randTreeHeight2 && posY1 < 0) {
                    posX1 += direction.func_82601_c();
                    posZ1 += direction.func_82599_e();
                    ++posY1;
                }
                int logplacer = posY + buildTrunk;
                BlockPos blockpos1 = new BlockPos(posX1, logplacer, posZ1);
                this.treelog(changedBlocks, worldIn, blockpos1, boundsIn);
            }
            int squareSize = 2;
            for (int posXLeafWidth = -squareSize; posXLeafWidth <= squareSize; ++posXLeafWidth) {
                for (int posZLeafWidthL0 = -squareSize; posZLeafWidthL0 <= squareSize; ++posZLeafWidthL0) {
                    this.leafs(worldIn, posX1, topTrunkHeight + 1, posZ1, boundsIn, changedBlocks);
                    this.leafs(worldIn, posX1 - 1, topTrunkHeight, posZ1, boundsIn, changedBlocks);
                    this.leafs(worldIn, posX1 + 1, topTrunkHeight, posZ1, boundsIn, changedBlocks);
                    this.leafs(worldIn, posX1 + 1, topTrunkHeight, posZ1 + 1, boundsIn, changedBlocks);
                    this.leafs(worldIn, posX1, topTrunkHeight, posZ1 + 1, boundsIn, changedBlocks);
                    this.leafs(worldIn, posX1, topTrunkHeight, posZ1 - 1, boundsIn, changedBlocks);
                }
            }
            return true;
        }
        return false;
    }

    private void treelog(Set<BlockPos> setlogblock, ISeedReader reader, BlockPos pos, MutableBoundingBox boundingBox) {
        if (AspenShrub2.canLogPlaceHere((IWorldGenerationBaseReader)reader, pos)) {
            this.setFinalBlockState(setlogblock, (IWorldWriter)reader, pos, BYGBlockList.ASPEN_LOG.func_176223_P(), boundingBox);
        }
    }

    private void leafs(ISeedReader reader, int x, int y, int z, MutableBoundingBox boundingBox, Set<BlockPos> blockPos) {
        BlockPos blockpos = new BlockPos(x, y, z);
        if (AspenShrub2.isAir((IWorldGenerationBaseReader)reader, blockpos)) {
            this.setFinalBlockState(blockPos, (IWorldWriter)reader, blockpos, BYGBlockList.ASPEN_LEAVES.func_176223_P(), boundingBox);
        }
    }
}

