/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.world.feature.features.overworld.mushrooms;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import voronoiaoc.byg.common.world.feature.features.overworld.trees.util.BYGAbstractTreeFeature;
import voronoiaoc.byg.core.byglists.BYGBlockList;

public class PurpleGlowshroomHuge
extends BYGAbstractTreeFeature<NoFeatureConfig> {
    public PurpleGlowshroomHuge(Codec<NoFeatureConfig> configIn) {
        super(configIn);
    }

    @Override
    public boolean place(Set<BlockPos> changedBlocks, ISeedReader worldIn, Random rand, BlockPos pos, MutableBoundingBox boundsIn, boolean isSapling) {
        int randTreeHeight = 23 + rand.nextInt(5);
        BlockPos.Mutable mainmutable = new BlockPos.Mutable().func_189533_g((Vector3i)pos);
        if (pos.func_177956_o() + randTreeHeight + 1 < worldIn.func_217301_I()) {
            BlockPos blockpos = pos.func_177977_b();
            if (!PurpleGlowshroomHuge.isDesiredGroundwDirtTag((IWorldGenerationBaseReader)worldIn, blockpos, Blocks.field_196658_i)) {
                return false;
            }
            if (!this.doesTreeFit((IWorldGenerationBaseReader)worldIn, pos, randTreeHeight)) {
                return false;
            }
            this.treeLog(changedBlocks, worldIn, mainmutable.func_177982_a(0, 0, 0), boundsIn);
            this.treeLog(changedBlocks, worldIn, mainmutable.func_177982_a(0, 1, 0), boundsIn);
            this.treeLog(changedBlocks, worldIn, mainmutable.func_177982_a(0, 2, 0), boundsIn);
            this.treeLog(changedBlocks, worldIn, mainmutable.func_177982_a(0, 3, 0), boundsIn);
            this.treeLog(changedBlocks, worldIn, mainmutable.func_177982_a(0, 4, 0), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(1, 4, -1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(-1, 4, 1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(2, 5, -2), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(1, 5, -1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(-1, 5, 1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(2, 6, -2), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(-1, 6, 1), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(-2, 6, 2), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(2, 7, -2), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(-2, 7, 2), boundsIn);
            this.treeBranch(changedBlocks, worldIn, mainmutable.func_177982_a(-2, 8, 2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(1, 7, -3), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(2, 7, -3), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(3, 7, -3), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(1, 7, -2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(3, 7, -2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(1, 7, -1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(2, 7, -1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(3, 7, -1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(2, 8, -3), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(1, 8, -2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(2, 8, -2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(3, 8, -2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(2, 8, -1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-3, 8, 1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-2, 8, 1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-1, 8, 1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-3, 8, 2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-1, 8, 2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-3, 8, 3), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-2, 8, 3), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-1, 8, 3), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(2, 9, -3), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(1, 9, -2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(2, 9, -2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(3, 9, -2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(2, 9, -1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-2, 9, 1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-3, 9, 2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-2, 9, 2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-1, 9, 2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-2, 9, 3), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(1, 10, -2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(2, 10, -2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(3, 10, -2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-2, 10, 1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-3, 10, 2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-2, 10, 2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-1, 10, 2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-2, 10, 3), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(2, 11, -2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-2, 11, 1), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-2, 11, 2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-2, 11, 3), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(2, 12, -2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-2, 12, 2), boundsIn);
            this.leafs(changedBlocks, worldIn, mainmutable.func_177982_a(-2, 13, 2), boundsIn);
        }
        return true;
    }

    private void treeLog(Set<BlockPos> setlogblock, ISeedReader reader, BlockPos pos, MutableBoundingBox boundingBox) {
        if (PurpleGlowshroomHuge.canLogPlaceHere((IWorldGenerationBaseReader)reader, pos)) {
            this.setFinalBlockState(setlogblock, (IWorldWriter)reader, pos, BYGBlockList.RED_GLOWSHROOM_STEM.func_176223_P(), boundingBox);
        }
    }

    private void treeBranch(Set<BlockPos> setlogblock, ISeedReader reader, BlockPos pos, MutableBoundingBox boundingBox) {
        if (PurpleGlowshroomHuge.canLogPlaceHere((IWorldGenerationBaseReader)reader, pos)) {
            this.setFinalBlockState(setlogblock, (IWorldWriter)reader, pos, BYGBlockList.RED_GLOWSHROOM_STEM.func_176223_P(), boundingBox);
        }
    }

    private void leafs(Set<BlockPos> blockPos, ISeedReader reader, BlockPos pos, MutableBoundingBox boundingBox) {
        if (PurpleGlowshroomHuge.isAir((IWorldGenerationBaseReader)reader, pos)) {
            this.setFinalBlockState(blockPos, (IWorldWriter)reader, pos, BYGBlockList.PURPLE_GLOWSHROOM_BLOCK.func_176223_P(), boundingBox);
        }
    }

    private boolean doesTreeFit(IWorldGenerationBaseReader reader, BlockPos blockPos, int height) {
        int x = blockPos.func_177958_n();
        int y = blockPos.func_177956_o();
        int z = blockPos.func_177952_p();
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (int yOffset = 0; yOffset <= height + 1; ++yOffset) {
            int distance = 0;
            for (int xOffset = -distance; xOffset <= distance; ++xOffset) {
                for (int zOffset = -distance; zOffset <= distance; ++zOffset) {
                    if (PurpleGlowshroomHuge.canLogPlaceHere(reader, (BlockPos)pos.func_181079_c(x + xOffset, y + yOffset, z + zOffset))) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

