/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.world.feature.features.overworld;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluids;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class LakeWideShallow
extends Feature<NoFeatureConfig> {
    protected static final Set<Material> unacceptableSolidMaterials = ImmutableSet.of((Object)Material.field_215713_z, (Object)Material.field_215712_y, (Object)Material.field_151584_j, (Object)Material.field_151569_G, (Object)Material.field_151570_A, (Object)Material.field_151574_g, (Object[])new Material[]{Material.field_151572_C, Material.field_151568_F, Material.field_151566_D, Material.field_175972_I, Material.field_151568_F});
    protected long noiseSeed;
    protected PerlinNoiseGenerator noiseGen;

    public void setSeed(long seed) {
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom(seed);
        if (this.noiseSeed != seed || this.noiseGen == null) {
            this.noiseGen = new PerlinNoiseGenerator(sharedseedrandom, (List)ImmutableList.of((Object)0));
        }
        this.noiseSeed = seed;
    }

    public LakeWideShallow(Codec<NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean func_241855_a(ISeedReader world, ChunkGenerator chunkSettings, Random random, BlockPos position, NoFeatureConfig configBlock) {
        this.setSeed(world.func_72905_C());
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable().func_189533_g((Vector3i)position.func_177979_c(2));
        for (int x = -2; x < 18; ++x) {
            for (int z = -2; z < 18; ++z) {
                int xTemp = x - 10;
                int zTemp = z - 10;
                if (xTemp * xTemp + zTemp * zTemp >= 64) continue;
                double samplePerlin1 = (this.noiseGen.func_215464_a((double)position.func_177958_n() + (double)x * 0.05, (double)position.func_177952_p() + (double)z * 0.05, true) + 1.0) * 3.0;
                int y = 0;
                while ((double)y > -samplePerlin1) {
                    blockpos$Mutable.func_189533_g((Vector3i)position).func_196234_d(x, y, z);
                    boolean containedFlag = this.checkIfValidSpot((IWorld)world, blockpos$Mutable, samplePerlin1);
                    if (containedFlag) {
                        world.func_180501_a((BlockPos)blockpos$Mutable, Blocks.field_150355_j.func_176223_P(), 3);
                        world.func_205219_F_().func_205360_a((BlockPos)blockpos$Mutable, (Object)Fluids.field_204546_a, 0);
                        BlockState blockState = world.func_180495_p((BlockPos)blockpos$Mutable.func_189536_c(Direction.UP));
                        Material material = blockState.func_185904_a();
                        if (material == Material.field_151585_k && blockState.func_177230_c() != Blocks.field_196651_dG) {
                            world.func_180501_a((BlockPos)blockpos$Mutable, Blocks.field_150350_a.func_176223_P(), 2);
                            while (blockpos$Mutable.func_177956_o() < world.func_217301_I() && world.func_180495_p((BlockPos)blockpos$Mutable.func_189536_c(Direction.UP)) == Blocks.field_196608_cF.func_176223_P()) {
                                world.func_180501_a((BlockPos)blockpos$Mutable, Blocks.field_150350_a.func_176223_P(), 2);
                            }
                        }
                        if (material == Material.field_151582_l && blockState.func_177230_c() != Blocks.field_150395_bd) {
                            world.func_180501_a((BlockPos)blockpos$Mutable, Blocks.field_150350_a.func_176223_P(), 2);
                            world.func_180501_a(blockpos$Mutable.func_177984_a(), Blocks.field_150350_a.func_176223_P(), 2);
                        }
                    }
                    --y;
                }
            }
        }
        return true;
    }

    private boolean checkIfValidSpot(IWorld world, BlockPos.Mutable blockpos$Mutable, double noise) {
        BlockPos.Mutable temp = new BlockPos.Mutable().func_189533_g((Vector3i)blockpos$Mutable);
        BlockState blockState = world.func_180495_p(temp.func_177984_a());
        while (!blockState.func_204520_s().func_206888_e() && temp.func_177956_o() < 255) {
            temp.func_189536_c(Direction.UP);
        }
        if (!blockState.func_196958_f() && blockState.func_204520_s().func_206888_e()) {
            return false;
        }
        blockState = world.func_180495_p(blockpos$Mutable.func_177977_b());
        Material material = blockState.func_185904_a();
        if ((!material.func_76220_a() || unacceptableSolidMaterials.contains(material) || BlockTags.field_199898_b.func_230235_a_((Object)blockState.func_177230_c())) && blockState.func_204520_s().func_206888_e() && blockState.func_204520_s() != Fluids.field_204546_a.func_207204_a(false)) {
            return false;
        }
        if (noise < 2.0 && world.func_180495_p(blockpos$Mutable.func_177984_a()).func_196958_f()) {
            int open = 0;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (!world.func_180495_p(blockpos$Mutable.func_177972_a(direction)).func_196958_f()) continue;
                ++open;
            }
            if (open == 1) {
                return true;
            }
        }
        for (int x2 = -1; x2 < 2; ++x2) {
            for (int z2 = -1; z2 < 2; ++z2) {
                blockState = world.func_180495_p(blockpos$Mutable.func_177982_a(x2, 0, z2));
                material = blockState.func_185904_a();
                if (material.func_76220_a() && !unacceptableSolidMaterials.contains(material) && !BlockTags.field_199898_b.func_230235_a_((Object)blockState.func_177230_c()) || !blockState.func_204520_s().func_206888_e() || blockState.func_204520_s() == Fluids.field_204546_a.func_207204_a(false)) continue;
                return false;
            }
        }
        return true;
    }
}

