/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.world.dimension.end;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.layer.Layer;
import voronoiaoc.byg.common.world.dimension.end.BYGEndLayerProvider;

public class BYGEndBiomeProvider
extends BiomeProvider {
    public static final Codec<BYGEndBiomeProvider> BYGENDCODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryLookupCodec.func_244331_a((RegistryKey)Registry.field_239720_u_).forGetter(theEndBiomeSource -> theEndBiomeSource.biomeRegistry), (App)Codec.LONG.fieldOf("seed").stable().forGetter(theEndBiomeSource -> theEndBiomeSource.seed)).apply((Applicative)instance, instance.stable(BYGEndBiomeProvider::new)));
    private final long seed;
    private final Layer biomeLayer;
    public static final List<Biome> bygEndBiomeList = new ArrayList<Biome>();
    private final Registry<Biome> biomeRegistry;

    public BYGEndBiomeProvider(Registry<Biome> registry, long seed) {
        super(bygEndBiomeList);
        this.seed = seed;
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom(seed);
        sharedseedrandom.setSeed(17292L);
        this.biomeLayer = BYGEndLayerProvider.stackLayers(seed);
        this.biomeRegistry = registry;
    }

    protected Codec<? extends BiomeProvider> func_230319_a_() {
        return BYGENDCODEC;
    }

    public BiomeProvider func_230320_a_(long seed) {
        return new BYGEndBiomeProvider(this.biomeRegistry, seed);
    }

    public Biome func_225526_b_(int x, int y, int z) {
        int i = x >> 2;
        int j = z >> 2;
        if ((long)i * (long)i + (long)j * (long)j <= 4096L) {
            return (Biome)this.biomeRegistry.func_243576_d(Biomes.field_76779_k);
        }
        return this.biomeLayer.func_242936_a(this.biomeRegistry, x, z);
    }
}

