/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.world.dimension.end;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import voronoiaoc.byg.BYG;
import voronoiaoc.byg.common.world.dimension.end.BYGEndBiomeProvider;
import voronoiaoc.byg.config.BYGWorldConfig;
import voronoiaoc.byg.core.byglists.BYGBiomeList;

public class BYGEndBiomeCatch {
    public static final ForgeRegistry<Biome> BIOME_REGISTRY = (ForgeRegistry)ForgeRegistries.BIOMES;
    public static final int IVISFIELDS = BIOME_REGISTRY.getID((IForgeRegistryEntry)BYGBiomeList.IVISFIELDS);
    public static final int SMALLENDISLANDS = BIOME_REGISTRY.getID(BIOME_REGISTRY.getValue(Biomes.field_201936_P.func_240901_a_()));
    public static final int ENDBARRENS = BIOME_REGISTRY.getID(BIOME_REGISTRY.getValue(Biomes.field_201939_S.func_240901_a_()));
    public static final int ENDHIGHLANDS = BIOME_REGISTRY.getID(BIOME_REGISTRY.getValue(Biomes.field_201938_R.func_240901_a_()));
    public static final int ENDMIDLANDS = BIOME_REGISTRY.getID(BIOME_REGISTRY.getValue(Biomes.field_201937_Q.func_240901_a_()));
    public static final int POISEFOREST = BIOME_REGISTRY.getID(BIOME_REGISTRY.getValue(new ResourceLocation("endergetic:poise_forest")));
    static String biomeRegistries = (String)BYGWorldConfig.externalEndBiomes.get();
    public static String configBiomes = biomeRegistries.trim().replace(" ", "");
    public static List<String> biomeList = Arrays.asList(configBiomes.split(","));
    public static ArrayList<Integer> endBiomeIDs = new ArrayList();

    public static void endBiomeConfigCollection() {
        BYG.LOGGER.debug("BYG: End Biome Config Collection starting...");
        if (biomeList.size() > 0) {
            int[] getConfigArray = new int[biomeList.size()];
            for (int index = 0; index < biomeList.size(); ++index) {
                Biome configResource = (Biome)WorldGenRegistries.field_243657_i.func_241873_b(new ResourceLocation(biomeList.get(index))).orElse(BIOME_REGISTRY.getValue(Biomes.field_76779_k.func_240901_a_()));
                if (configResource == null) {
                    BYG.LOGGER.warn("Illegal registry name! You put: " + biomeList.get(index));
                    continue;
                }
                if (configResource == null) continue;
                getConfigArray[index] = WorldGenRegistries.field_243657_i.func_148757_b((Object)configResource);
                Biome biome = (Biome)WorldGenRegistries.field_243657_i.func_148745_a(getConfigArray[index]);
                if (biome == null) continue;
                BYGEndBiomeProvider.bygEndBiomeList.add(biome);
                endBiomeIDs.add(BIOME_REGISTRY.getID((IForgeRegistryEntry)biome));
            }
        }
        BYG.LOGGER.debug("BYG: End Biome Config Collection complete!");
    }

    public static int getRandomEndBiomes(INoiseRandom rand) {
        return endBiomeIDs.get(rand.func_202696_a(endBiomeIDs.size()));
    }

    static {
        endBiomeIDs.add(SMALLENDISLANDS);
        endBiomeIDs.add(ENDBARRENS);
        endBiomeIDs.add(ENDHIGHLANDS);
        endBiomeIDs.add(ENDMIDLANDS);
        endBiomeIDs.add(IVISFIELDS);
        if (ModList.get().isLoaded("endergetic")) {
            endBiomeIDs.add(POISEFOREST);
        }
    }
}

