/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.properties.blocks;

import java.util.Map;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SixWayBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SonoranCactusBlock
extends Block {
    public static final BooleanProperty NORTH = SixWayBlock.field_196488_a;
    public static final BooleanProperty EAST = SixWayBlock.field_196490_b;
    public static final BooleanProperty SOUTH = SixWayBlock.field_196492_c;
    public static final BooleanProperty WEST = SixWayBlock.field_196495_y;
    public static final BooleanProperty UP = SixWayBlock.field_196496_z;
    public static final BooleanProperty DOWN = SixWayBlock.field_196489_A;
    public static final Map<Direction, BooleanProperty> FACING_TO_PROPERTY_MAP = SixWayBlock.field_196491_B;
    protected static final VoxelShape collisionShape = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    protected static final VoxelShape shape = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public SonoranCactusBlock(String registryName) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151570_A).func_200944_c().func_200943_b(0.4f).func_200947_a(SoundType.field_185854_g));
        this.setRegistryName(registryName);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.makeConnections((IBlockReader)context.func_195991_k(), context.func_195995_a());
    }

    public BlockState makeConnections(IBlockReader reader, BlockPos pos) {
        Block blockDown = reader.func_180495_p(pos.func_177977_b()).func_177230_c();
        Block blockUp = reader.func_180495_p(pos.func_177984_a()).func_177230_c();
        Block blockNorth = reader.func_180495_p(pos.func_177978_c()).func_177230_c();
        Block blockEast = reader.func_180495_p(pos.func_177974_f()).func_177230_c();
        Block blockSouth = reader.func_180495_p(pos.func_177968_d()).func_177230_c();
        Block blockWest = reader.func_180495_p(pos.func_177976_e()).func_177230_c();
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(blockDown == this || blockDown == Blocks.field_150354_m))).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(blockUp == this))).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(blockNorth == this))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(blockEast == this))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(blockSouth == this))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(blockWest == this));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (!state.func_196955_c((IWorldReader)worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        int connectionsNorth = 0;
        int connectionsSouth = 0;
        int connectionsEast = 0;
        int connectionsWest = 0;
        boolean checkStemFlag = true;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (worldIn.func_180495_p(pos.func_177972_a(Direction.UP)).func_177230_c() == this && worldIn.func_180495_p(pos.func_177972_a(direction)).func_177230_c() == this && worldIn.func_180495_p(pos.func_177972_a(Direction.DOWN)).func_177230_c() == Blocks.field_150354_m) {
                return false;
            }
            if (worldIn.func_180495_p(pos.func_177972_a(Direction.DOWN)).func_177230_c() != this) continue;
            for (int idx = 0; idx < 3; ++idx) {
                if (worldIn.func_180495_p(pos.func_177972_a(Direction.DOWN).func_177972_a(Direction.DOWN).func_177967_a(direction, idx)).func_177230_c() != this) continue;
                checkStemFlag = false;
            }
        }
        for (int idx = 1; idx <= 5; ++idx) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (worldIn.func_180495_p(pos.func_177967_a(direction, idx)).func_177230_c() != this) continue;
                if (direction == Direction.NORTH) {
                    ++connectionsNorth;
                }
                if (direction == Direction.SOUTH) {
                    ++connectionsSouth;
                }
                if (direction == Direction.EAST) {
                    ++connectionsEast;
                }
                if (direction != Direction.WEST) continue;
                ++connectionsWest;
            }
        }
        int connectionsTotal = connectionsNorth + connectionsSouth + connectionsEast + connectionsWest;
        if (connectionsNorth > 3 || connectionsSouth > 3 || connectionsEast > 3 || connectionsWest > 3) {
            return false;
        }
        if (!checkStemFlag) {
            return false;
        }
        return worldIn.func_180495_p(pos.func_177972_a(Direction.NORTH)).func_177230_c() == this || worldIn.func_180495_p(pos.func_177972_a(Direction.WEST)).func_177230_c() == this || worldIn.func_180495_p(pos.func_177972_a(Direction.SOUTH)).func_177230_c() == this || worldIn.func_180495_p(pos.func_177972_a(Direction.EAST)).func_177230_c() == this || worldIn.func_180495_p(pos.func_177972_a(Direction.DOWN)).func_177230_c() == this || worldIn.func_180495_p(pos.func_177972_a(Direction.WEST).func_177972_a(Direction.DOWN)).func_177230_c() == this || worldIn.func_180495_p(pos.func_177972_a(Direction.SOUTH).func_177972_a(Direction.DOWN)).func_177230_c() == this || worldIn.func_180495_p(pos.func_177972_a(Direction.EAST).func_177972_a(Direction.DOWN)).func_177230_c() == this || worldIn.func_180495_p(pos.func_177972_a(Direction.NORTH).func_177972_a(Direction.DOWN)).func_177230_c() == this || worldIn.func_180495_p(pos.func_177972_a(Direction.DOWN)).func_177230_c() == Blocks.field_150354_m;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return collisionShape;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return shape;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        entityIn.func_70097_a(DamageSource.field_76367_g, 1.0f);
    }
}

