/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.properties.blocks;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import voronoiaoc.byg.common.world.feature.features.overworld.trees.util.BYGTree;
import voronoiaoc.byg.core.byglists.BYGBlockList;

public class BYGSaplingProperties
extends BushBlock
implements IGrowable {
    public static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
    public static final IntegerProperty STAGE = BlockStateProperties.field_208137_al;
    private final BYGTree tree;

    public BYGSaplingProperties(BYGTree tree, String registryName) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200947_a(SoundType.field_185850_c).func_200943_b(0.0f).func_200942_a().func_200944_c());
        this.tree = tree;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)STAGE, (Comparable)Integer.valueOf(0)));
        this.setRegistryName(registryName);
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        Block block = state.func_177230_c();
        return block == Blocks.field_196658_i || block == Blocks.field_150346_d || block == Blocks.field_196660_k || block == Blocks.field_196661_l || block == Blocks.field_150458_ak || block == BYGBlockList.OVERGROWN_STONE;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        super.func_225534_a_(state, worldIn, pos, rand);
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (worldIn.func_201696_r(pos.func_177984_a()) >= 9 && rand.nextInt(7) == 0) {
            this.grow(worldIn, pos, state, rand);
        }
    }

    public void grow(ServerWorld world, BlockPos pos, BlockState state, Random rand) {
        if ((Integer)state.func_177229_b((Property)STAGE) == 0) {
            world.func_180501_a(pos, (BlockState)state.func_235896_a_((Property)STAGE), 4);
        } else {
            if (!ForgeEventFactory.saplingGrowTree((IWorld)world, (Random)rand, (BlockPos)pos)) {
                return;
            }
            this.tree.tree((ISeedReader)world, world.func_72863_F().func_201711_g(), pos, state, rand);
        }
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return (double)worldIn.field_73012_v.nextFloat() < 0.45;
    }

    public void func_225535_a_(ServerWorld world, Random rand, BlockPos pos, BlockState state) {
        this.grow(world, pos, state, rand);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{STAGE});
    }
}

