/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.biomes.biomes;

import java.util.HashMap;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import voronoiaoc.byg.common.biomes.BYGBiomeBuilder;
import voronoiaoc.byg.common.biomes.BiomeHelper;
import voronoiaoc.byg.common.biomes.BiomeTools;
import voronoiaoc.byg.common.world.feature.biomefeatures.BYGFeatures;
import voronoiaoc.byg.common.world.feature.biomefeatures.BYGTreeFeatures;
import voronoiaoc.byg.core.byglists.BYGBiomeList;

public class SnowyEvergreenTaiga
extends BYGBiomeBuilder
implements BiomeTools {
    static final ConfiguredSurfaceBuilder SURFACE_BUILDER = BiomeHelper.newConfiguredSurfaceBuilder("snowy_evergreen_taiga", new ConfiguredSurfaceBuilder(SurfaceBuilder.field_215396_G, (ISurfaceBuilderConfig)new SurfaceBuilderConfig(Blocks.field_196658_i.func_176223_P(), Blocks.field_150346_d.func_176223_P(), Blocks.field_150346_d.func_176223_P())));
    static final Biome.RainType PRECIPATATION = Biome.RainType.RAIN;
    static final Biome.Category CATEGORY = Biome.Category.TAIGA;
    static final float DEPTH = 0.35f;
    static final float SCALE = 0.01f;
    static final float TEMPERATURE = -0.5f;
    static final float DOWNFALL = 0.8f;
    static final int WATER_COLOR = 4159204;
    static final int WATER_FOG_COLOR = 329011;
    static final int GRASS_COLOR = 5011004;
    static final int FOLIAGE_COLOR = 0x228B22;
    static final String PARENT = null;
    static final Biome.Climate WEATHER = new Biome.Climate(PRECIPATATION, -0.5f, Biome.TemperatureModifier.NONE, 0.8f);
    static final MobSpawnInfo.Builder SPAWN_SETTINGS = new MobSpawnInfo.Builder();
    static final BiomeGenerationSettings.Builder GENERATION_SETTINGS = new BiomeGenerationSettings.Builder().func_242517_a(SURFACE_BUILDER);

    public SnowyEvergreenTaiga() {
        super(WEATHER, CATEGORY, 0.35f, 0.01f, new BiomeAmbience.Builder().func_235246_b_(4159204).func_235248_c_(329011).func_235239_a_(12638463).func_242541_f(5011004).func_242540_e(0x228B22).func_242539_d(BiomeHelper.calcSkyColor(0.8f)).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_(), GENERATION_SETTINGS.func_242508_a(), SPAWN_SETTINGS.func_242577_b());
    }

    @Override
    public Biome getRiver() {
        return (Biome)WorldGenRegistries.field_243657_i.func_243576_d(Biomes.field_76777_m);
    }

    @Override
    public HashMap<Biome, Integer> getHills() {
        HashMap<Biome, Integer> map = new HashMap<Biome, Integer>();
        map.put(BYGBiomeList.SNOWY_EVERGREEN_HILLS, 1);
        map.put(BYGBiomeList.FROZENLAKE, 1);
        map.put(BYGBiomeList.SNOWY_EVERGREEN_CLEARING, 2);
        return map;
    }

    @Override
    public Biome getHill(INoiseRandom rand) {
        return this.randomSubBiome(rand);
    }

    public Biome randomSubBiome(INoiseRandom random) {
        int randomPicker = random.func_202696_a(4);
        if (randomPicker == 0) {
            return BYGBiomeList.SNOWY_EVERGREEN_HILLS;
        }
        if (randomPicker == 1) {
            return BYGBiomeList.SNOWY_EVERGREEN_CLEARING;
        }
        if (randomPicker == 2) {
            return BYGBiomeList.SNOWY_EVERGREEN_CLEARING;
        }
        return BYGBiomeList.FRESHWATERLAKE;
    }

    static {
        DefaultBiomeFeatures.func_243733_b((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243756_p((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243757_q((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243707_U((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243706_T((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243712_Z((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243717_aa((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243727_ak((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243759_s((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        BYGTreeFeatures.addHollyTrees(GENERATION_SETTINGS);
        BYGFeatures.addLushBlueberries(GENERATION_SETTINGS);
        BYGFeatures.addMossyStoneBoulder(GENERATION_SETTINGS);
        BYGFeatures.addRockyStoneBoulder(GENERATION_SETTINGS);
        BYGFeatures.addCrocus(GENERATION_SETTINGS);
        BYGFeatures.addIris(GENERATION_SETTINGS);
        BYGFeatures.addBYGMushrooms(GENERATION_SETTINGS);
        BYGFeatures.addGrass(GENERATION_SETTINGS);
        BYGFeatures.addWinterSucculent(GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243730_an((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200737_ac, 12, 4, 4));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200784_X, 10, 4, 4));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200795_i, 10, 4, 4));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200796_j, 8, 4, 4));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200724_aC, 8, 4, 4));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200736_ab, 4, 2, 3));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_220356_B, 8, 2, 4));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.AMBIENT, new MobSpawnInfo.Spawners(EntityType.field_200791_e, 10, 8, 8));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200748_an, 100, 4, 4));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200725_aD, 100, 4, 4));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200741_ag, 100, 4, 4));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200727_aF, 25, 1, 1));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200797_k, 100, 4, 4));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200743_ai, 100, 4, 4));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200803_q, 10, 1, 4));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200759_ay, 5, 1, 1));
    }
}

