/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.biomes.biomes;

import java.util.HashMap;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import voronoiaoc.byg.common.biomes.BYGBiomeBuilder;
import voronoiaoc.byg.common.biomes.BiomeHelper;
import voronoiaoc.byg.common.biomes.BiomeTools;
import voronoiaoc.byg.common.world.feature.biomefeatures.BYGFeatures;
import voronoiaoc.byg.common.world.feature.biomefeatures.BYGTreeFeatures;
import voronoiaoc.byg.core.byglists.BYGBiomeList;
import voronoiaoc.byg.core.byglists.BYGSBList;

public class RedRockMountains
extends BYGBiomeBuilder
implements BiomeTools {
    static final ConfiguredSurfaceBuilder SURFACE_BUILDER = BiomeHelper.newConfiguredSurfaceBuilder("red_rock_mountains", new ConfiguredSurfaceBuilder(BYGSBList.RED_ROCK_SB, (ISurfaceBuilderConfig)SurfaceBuilder.field_215425_v));
    static final Biome.RainType PRECIPATATION = Biome.RainType.RAIN;
    static final Biome.Category CATEGORY = Biome.Category.PLAINS;
    static final float DEPTH = 2.0f;
    static final float SCALE = 0.5f;
    static final float TEMPERATURE = 1.2f;
    static final float DOWNFALL = 0.1f;
    static final int WATER_COLOR = 4159204;
    static final int WATER_FOG_COLOR = 329011;
    static final int GRASS_COLOR = 0xA5A56A;
    static final int FOLIAGE_COLOR = 0xA5A56A;
    static final String PARENT = null;
    static final Biome.Climate WEATHER = new Biome.Climate(PRECIPATATION, 1.2f, Biome.TemperatureModifier.NONE, 0.1f);
    static final MobSpawnInfo.Builder SPAWN_SETTINGS = new MobSpawnInfo.Builder();
    static final BiomeGenerationSettings.Builder GENERATION_SETTINGS = new BiomeGenerationSettings.Builder().func_242517_a(SURFACE_BUILDER);

    public RedRockMountains() {
        super(WEATHER, CATEGORY, 2.0f, 0.5f, new BiomeAmbience.Builder().func_235246_b_(4159204).func_235248_c_(329011).func_235239_a_(12638463).func_242541_f(0xA5A56A).func_242540_e(0xA5A56A).func_242539_d(BiomeHelper.calcSkyColor(0.8f)).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_(), GENERATION_SETTINGS.func_242508_a(), SPAWN_SETTINGS.func_242577_b());
    }

    @Override
    public Biome getRiver() {
        return this.getBiome();
    }

    @Override
    public HashMap<Biome, Integer> getHills() {
        HashMap<Biome, Integer> map = new HashMap<Biome, Integer>();
        map.put(BYGBiomeList.RED_ROCK_LOWLANDS, 1);
        map.put(BYGBiomeList.RED_ROCK_HIGHLANDS, 2);
        map.put(BYGBiomeList.WOODEDREDROCKMOUNTAINS, 1);
        return map;
    }

    @Override
    public Biome getHill(INoiseRandom rand) {
        return this.randomSubBiome(rand);
    }

    public Biome randomSubBiome(INoiseRandom random) {
        int randomPicker = random.func_202696_a(4);
        if (randomPicker == 0) {
            return BYGBiomeList.RED_ROCK_LOWLANDS;
        }
        if (randomPicker == 1) {
            return BYGBiomeList.RED_ROCK_HIGHLANDS;
        }
        if (randomPicker == 2) {
            return BYGBiomeList.RED_ROCK_HIGHLANDS;
        }
        return BYGBiomeList.WOODEDREDROCKMOUNTAINS;
    }

    static {
        DefaultBiomeFeatures.func_243733_b((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243751_k((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243752_l((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243712_Z((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243717_aa((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243730_an((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        BYGFeatures.addTerracottaBoulder(GENERATION_SETTINGS);
        BYGTreeFeatures.addPaloVerdeTrees(GENERATION_SETTINGS);
        BYGFeatures.addBYGMushrooms(GENERATION_SETTINGS);
        BYGFeatures.addGrass(GENERATION_SETTINGS);
        BYGFeatures.addFirecracker(GENERATION_SETTINGS);
        SPAWN_SETTINGS.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200736_ab, 4, 2, 3));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.AMBIENT, new MobSpawnInfo.Spawners(EntityType.field_200791_e, 10, 8, 8));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200748_an, 100, 4, 4));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200763_C, 95, 4, 4));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200727_aF, 5, 1, 1));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200741_ag, 100, 4, 4));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200797_k, 100, 4, 4));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200743_ai, 100, 4, 4));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200803_q, 10, 1, 4));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200759_ay, 5, 1, 1));
    }
}

