/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.biomes.biomes;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import voronoiaoc.byg.common.biomes.BYGBiomeBuilder;
import voronoiaoc.byg.common.biomes.BiomeHelper;
import voronoiaoc.byg.common.biomes.BiomeTools;
import voronoiaoc.byg.common.world.feature.biomefeatures.BYGFeatures;
import voronoiaoc.byg.common.world.feature.biomefeatures.BYGTreeFeatures;
import voronoiaoc.byg.core.byglists.BYGSBList;

public class MojaveDesert
extends BYGBiomeBuilder
implements BiomeTools {
    static final ConfiguredSurfaceBuilder SURFACE_BUILDER = BiomeHelper.newConfiguredSurfaceBuilder("mojave", new ConfiguredSurfaceBuilder(BYGSBList.MOJAVE, (ISurfaceBuilderConfig)new SurfaceBuilderConfig(Blocks.field_150354_m.func_176223_P(), Blocks.field_150354_m.func_176223_P(), Blocks.field_150322_A.func_176223_P())));
    static final Biome.RainType PRECIPATATION = Biome.RainType.NONE;
    static final Biome.Category CATEGORY = Biome.Category.DESERT;
    static final float DEPTH = 0.125f;
    static final float SCALE = 0.05f;
    static final float TEMPERATURE = 2.0f;
    static final float DOWNFALL = 0.0f;
    static final int WATER_COLOR = 4159204;
    static final int WATER_FOG_COLOR = 329011;
    static final String PARENT = null;
    static final Biome.Climate WEATHER = new Biome.Climate(PRECIPATATION, 2.0f, Biome.TemperatureModifier.NONE, 0.0f);
    static final MobSpawnInfo.Builder SPAWN_SETTINGS = new MobSpawnInfo.Builder();
    static final BiomeGenerationSettings.Builder GENERATION_SETTINGS = new BiomeGenerationSettings.Builder().func_242517_a(SURFACE_BUILDER);

    public MojaveDesert() {
        super(WEATHER, CATEGORY, 0.125f, 0.05f, new BiomeAmbience.Builder().func_235246_b_(4159204).func_235248_c_(329011).func_235239_a_(12638463).func_242539_d(BiomeHelper.calcSkyColor(0.8f)).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_(), GENERATION_SETTINGS.func_242508_a(), SPAWN_SETTINGS.func_242577_b());
    }

    @Override
    public HashMap<Biome, Integer> getHills() {
        return Maps.newHashMap(Collections.singletonMap(WorldGenRegistries.field_243657_i.func_243576_d(Biomes.field_76769_d), 1));
    }

    @Override
    public Biome getHill(INoiseRandom rand) {
        return (Biome)WorldGenRegistries.field_243657_i.func_230516_a_(Biomes.field_76769_d);
    }

    static {
        DefaultBiomeFeatures.func_243733_b((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243707_U((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243709_W((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243705_S((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243712_Z((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243720_ad((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243727_ak((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243722_af((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243730_an((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        BYGFeatures.addMiniCactus(GENERATION_SETTINGS);
        BYGTreeFeatures.addJoshuaTrees(GENERATION_SETTINGS);
        BYGFeatures.addBYGDesertPlants(GENERATION_SETTINGS);
        BYGFeatures.addFirecracker(GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243720_ad((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        BYGFeatures.addBYGMushrooms(GENERATION_SETTINGS);
        BYGFeatures.addGrass(GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243699_M((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        BYGTreeFeatures.addBushes(GENERATION_SETTINGS);
        SPAWN_SETTINGS.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners(EntityType.field_204262_at, 4, 2, 3));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners(EntityType.field_203778_ae, 10, 8, 8));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200748_an, 100, 4, 4));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200741_ag, 100, 4, 4));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200797_k, 100, 4, 4));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200743_ai, 100, 4, 4));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200803_q, 10, 1, 4));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200759_ay, 5, 1, 1));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200725_aD, 19, 4, 4));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200727_aF, 1, 1, 1));
        SPAWN_SETTINGS.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200763_C, 80, 4, 4));
    }
}

