/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.biomes.biomes;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import voronoiaoc.byg.common.biomes.BYGBiomeBuilder;
import voronoiaoc.byg.common.biomes.BiomeHelper;
import voronoiaoc.byg.common.biomes.BiomeTools;
import voronoiaoc.byg.common.world.feature.biomefeatures.BYGFeatures;
import voronoiaoc.byg.common.world.feature.biomefeatures.BYGTreeFeatures;
import voronoiaoc.byg.core.byglists.BYGBiomeList;

public class EvergreenTaiga
extends BYGBiomeBuilder
implements BiomeTools {
    static final ConfiguredSurfaceBuilder SURFACE_BUILDER = BiomeHelper.newConfiguredSurfaceBuilder("evergreen_taiga", new ConfiguredSurfaceBuilder(SurfaceBuilder.field_215396_G, (ISurfaceBuilderConfig)new SurfaceBuilderConfig(Blocks.field_196658_i.func_176223_P(), Blocks.field_150346_d.func_176223_P(), Blocks.field_150346_d.func_176223_P())));
    static final Biome.RainType PRECIPATATION = Biome.RainType.RAIN;
    static final Biome.Category CATEGORY = Biome.Category.TAIGA;
    static final float DEPTH = 0.75f;
    static final float SCALE = 0.1f;
    static final float TEMPERATURE = 0.25f;
    static final float DOWNFALL = 0.8f;
    static final int WATER_COLOR = 4159204;
    static final int WATER_FOG_COLOR = 329011;
    static final int GRASS_COLOR = 5011004;
    static final int FOLIAGE_COLOR = 0x228B22;
    static final String PARENT = null;
    static final Biome.Climate WEATHER = new Biome.Climate(PRECIPATATION, 0.25f, Biome.TemperatureModifier.NONE, 0.8f);
    static final MobSpawnInfo.Builder SPAWN_SETTINGS = new MobSpawnInfo.Builder();
    static final BiomeGenerationSettings.Builder GENERATION_SETTINGS = new BiomeGenerationSettings.Builder().func_242517_a(SURFACE_BUILDER);

    public EvergreenTaiga() {
        super(WEATHER, CATEGORY, 0.75f, 0.1f, new BiomeAmbience.Builder().func_235246_b_(4159204).func_235248_c_(329011).func_235239_a_(12638463).func_242541_f(5011004).func_242540_e(0x228B22).func_242539_d(BiomeHelper.calcSkyColor(0.8f)).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_(), GENERATION_SETTINGS.func_242508_a(), SPAWN_SETTINGS.func_242577_b());
    }

    @Override
    public HashMap<Biome, Integer> getHills() {
        HashMap map = Maps.newHashMap();
        map.put(BYGBiomeList.EVERGREEN_HILLS, 1);
        map.put(BYGBiomeList.EVERGREEN_CLEARING, 2);
        map.put(BYGBiomeList.FRESHWATERLAKE, 1);
        return map;
    }

    @Override
    public Biome getHill(INoiseRandom rand) {
        return this.randomSubBiome(rand);
    }

    public Biome randomSubBiome(INoiseRandom random) {
        int randomPicker = random.func_202696_a(4);
        if (randomPicker == 0) {
            return BYGBiomeList.EVERGREEN_HILLS;
        }
        if (randomPicker == 1) {
            return BYGBiomeList.EVERGREEN_CLEARING;
        }
        if (randomPicker == 2) {
            return BYGBiomeList.EVERGREEN_CLEARING;
        }
        return BYGBiomeList.FRESHWATERLAKE;
    }

    public Biome randomSubBiome(Random random) {
        int randomPicker = random.nextInt(4);
        if (randomPicker == 0) {
            return BYGBiomeList.EVERGREEN_HILLS;
        }
        if (randomPicker == 1) {
            return BYGBiomeList.EVERGREEN_CLEARING;
        }
        if (randomPicker == 2) {
            return BYGBiomeList.EVERGREEN_CLEARING;
        }
        return BYGBiomeList.FRESHWATERLAKE;
    }

    static {
        DefaultBiomeFeatures.func_243733_b((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243756_p((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243757_q((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243707_U((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243706_T((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243712_Z((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243717_aa((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243727_ak((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243759_s((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
        BYGTreeFeatures.addHollyTrees(GENERATION_SETTINGS);
        BYGFeatures.addLushBlueberries(GENERATION_SETTINGS);
        BYGFeatures.addMossyStoneBoulder(GENERATION_SETTINGS);
        BYGFeatures.addRockyStoneBoulder(GENERATION_SETTINGS);
        BYGFeatures.addCrocus(GENERATION_SETTINGS);
        BYGFeatures.addIris(GENERATION_SETTINGS);
        BYGFeatures.addBYGMushrooms(GENERATION_SETTINGS);
        BYGFeatures.addGrass(GENERATION_SETTINGS);
        BYGFeatures.addWinterSucculent(GENERATION_SETTINGS);
        DefaultBiomeFeatures.func_243730_an((BiomeGenerationSettings.Builder)GENERATION_SETTINGS);
    }
}

