/*
 * Decompiled with CFR 0.152.
 */
package voronoiaoc.byg.common.biomes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.BiomeLayer;
import net.minecraftforge.fml.loading.FMLPaths;
import voronoiaoc.byg.BYG;
import voronoiaoc.byg.config.biomeweight.ConfigWeightManager;
import voronoiaoc.byg.core.byglists.BYGBiomeList;

public class BYGBiomeWeightSystem {
    public static List<Integer> HOT = new ArrayList<Integer>();
    public static List<Integer> COOL = new ArrayList<Integer>();
    public static List<Integer> WARM = new ArrayList<Integer>();
    public static List<Integer> ICY = new ArrayList<Integer>();

    public static void addBiomesToWeightSystem() {
        ConfigWeightManager.loadConfig(ConfigWeightManager.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("byg-weights-common.toml"));
        BYG.LOGGER.debug("BYG: Adding biome entries with their respective weights...");
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.ALLIUMFIELDS, ConfigWeightManager.ALLIUMFIELDS.getWeight(), OverworldBiomeClimate.WARM);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.ALPS, ConfigWeightManager.ALPS.getWeight(), OverworldBiomeClimate.ICY);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.AMARANTHFIELDS, ConfigWeightManager.AMARANTHFIELDS.getWeight(), OverworldBiomeClimate.WARM);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.AUTUMNAL_VALLEY, ConfigWeightManager.AUTUMNALVALLEY.getWeight(), OverworldBiomeClimate.COOL);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.ANCIENTFOREST, ConfigWeightManager.ANCIENTFOREST.getWeight(), OverworldBiomeClimate.WARM);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.ASPENFOREST, ConfigWeightManager.ASPENFOREST.getWeight(), OverworldBiomeClimate.WARM);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.BAOBABSAVANNA, ConfigWeightManager.BAOBABSAVANNA.getWeight(), OverworldBiomeClimate.DESERT);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.BAYOU, ConfigWeightManager.BAYOU.getWeight(), OverworldBiomeClimate.WARM);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.BLUETAIGA, ConfigWeightManager.BLUETAIGA.getWeight(), OverworldBiomeClimate.COOL);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.BLUFFSTEEPS, ConfigWeightManager.BLUFFSTEEPS.getWeight(), OverworldBiomeClimate.COOL);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.BOREALFOREST, ConfigWeightManager.BOREALFOREST.getWeight(), OverworldBiomeClimate.COOL);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.COLDSWAMPLANDS, ConfigWeightManager.COLDSWAMPLANDS.getWeight(), OverworldBiomeClimate.COOL);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.CIKA_WOODS, ConfigWeightManager.CIKA_WOODS.getWeight(), OverworldBiomeClimate.COOL);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.CYPRESSSWAMPLANDS, ConfigWeightManager.CYPRESS_SWAMPLAND.getWeight(), OverworldBiomeClimate.WARM);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.CHERRYBLOSSOMFOREST, ConfigWeightManager.CHERRY_BLOSSOM_FOREST.getWeight(), OverworldBiomeClimate.WARM);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.CONIFEROUSFOREST, ConfigWeightManager.CONIFEROUSFOREST.getWeight(), OverworldBiomeClimate.COOL);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.DOVERMOUNTAINS, ConfigWeightManager.DOVERMOUNTAINS.getWeight(), OverworldBiomeClimate.COOL);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.DEADSEA, ConfigWeightManager.DEADSEA.getWeight(), OverworldBiomeClimate.DESERT);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.DECIDUOUSFOREST, ConfigWeightManager.DECIDUOUSFOREST.getWeight(), OverworldBiomeClimate.WARM);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.DUNES, ConfigWeightManager.DUNES.getWeight(), OverworldBiomeClimate.DESERT);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.EBONYWOODS, ConfigWeightManager.EBONY_WOODS.getWeight(), OverworldBiomeClimate.WARM);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.ENCHANTEDFOREST, ConfigWeightManager.ENCHANTED_FOREST.getWeight(), OverworldBiomeClimate.WARM);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.EVERGREENTAIGA, ConfigWeightManager.EVERGREEN_TAIGA.getWeight(), OverworldBiomeClimate.WARM);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.GLOWSHROOMBAYOU, ConfigWeightManager.GLOWSHROOMBAYOU.getWeight(), OverworldBiomeClimate.WARM);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.GRASSLANDPLATEAU, ConfigWeightManager.GRASSLANDPLATEAU.getWeight(), OverworldBiomeClimate.WARM);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.GREATLAKES, ConfigWeightManager.GREATLAKES.getWeight(), OverworldBiomeClimate.COOL);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.GUIANASHIELD, ConfigWeightManager.GUIANASHIELD.getWeight(), OverworldBiomeClimate.WARM);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.GROVE, ConfigWeightManager.GROVE.getWeight(), OverworldBiomeClimate.WARM);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.ENCHANTED_GROVE, ConfigWeightManager.ENCHANTED_GROVE.getWeight(), OverworldBiomeClimate.WARM);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.JACARANDAFOREST, ConfigWeightManager.JACARANDAFOREST.getWeight(), OverworldBiomeClimate.WARM);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.CRAGGARDENS, ConfigWeightManager.CRAGGARDENS.getWeight(), OverworldBiomeClimate.WARM);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.MANGROVEMARSHES, ConfigWeightManager.MANGROVE_MARSHES.getWeight(), OverworldBiomeClimate.WARM);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.MAPLETAIGA, ConfigWeightManager.MAPLE_TAIGA.getWeight(), OverworldBiomeClimate.COOL);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.MEADOW, ConfigWeightManager.MEADOW.getWeight(), OverworldBiomeClimate.WARM);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.MOJAVE_DESERT, ConfigWeightManager.MOJAVEDESERT.getWeight(), OverworldBiomeClimate.DESERT);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.LUSH_TUNDRA, ConfigWeightManager.LUSH_TUNDRA.getWeight(), OverworldBiomeClimate.ICY);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.ORCHARD, ConfigWeightManager.ORCHARD.getWeight(), OverworldBiomeClimate.WARM);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.PRAIRIE, ConfigWeightManager.PRAIRIE.getWeight(), OverworldBiomeClimate.WARM);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.REDDESERT, ConfigWeightManager.REDDESERT.getWeight(), OverworldBiomeClimate.DESERT);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.REDOAKFOREST, ConfigWeightManager.REDOAKFOREST.getWeight(), OverworldBiomeClimate.WARM);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.RED_ROCK_MOUNTAINS, ConfigWeightManager.REDROCKMOUNTAINS.getWeight(), OverworldBiomeClimate.DESERT);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.REDWOOD_TROPICS, ConfigWeightManager.REDWOOD_TROPICS.getWeight(), OverworldBiomeClimate.WARM);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.SEASONALBIRCHFOREST, ConfigWeightManager.SEASONALBIRCHFOREST.getWeight(), OverworldBiomeClimate.COOL);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.SEASONALDECIDUOUSFOREST, ConfigWeightManager.SEASONALDECIDUOUSFOREST.getWeight(), OverworldBiomeClimate.COOL);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.SEASONALFOREST, ConfigWeightManager.SEASONALFOREST.getWeight(), OverworldBiomeClimate.COOL);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.SEASONALTAIGA, ConfigWeightManager.SEASONALTAIGA.getWeight(), OverworldBiomeClimate.COOL);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.SHATTEREDGLACIER, ConfigWeightManager.SHATTEREDGLACIER.getWeight(), OverworldBiomeClimate.ICY);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.SHRUBLANDS, ConfigWeightManager.SHRUBLANDS.getWeight(), OverworldBiomeClimate.DESERT);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.SKYRISHIGHLANDS, ConfigWeightManager.SKYRISHIGHLANDS.getWeight(), OverworldBiomeClimate.COOL);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.SNOWYBLUETAIGA, ConfigWeightManager.SNOWYBLUETAIGA.getWeight(), OverworldBiomeClimate.ICY);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.SNOWYCONIFEROUSFOREST, ConfigWeightManager.SNOWYCONIFEROUSFOREST.getWeight(), OverworldBiomeClimate.ICY);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.SNOWYDECIDUOUSFOREST, ConfigWeightManager.SNOWYDECIDUOUSFOREST.getWeight(), OverworldBiomeClimate.ICY);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.SNOWYEVERGREENTAIGA, ConfigWeightManager.SNOWY_EVERGREEN_TAIGA.getWeight(), OverworldBiomeClimate.ICY);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.THE_BLACK_FOREST, ConfigWeightManager.THE_BLACK_FOREST.getWeight(), OverworldBiomeClimate.COOL);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.TROPICALFUNGALRAINFOREST, ConfigWeightManager.TROPICALFUNGALFOREST.getWeight(), OverworldBiomeClimate.WARM);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.TROPICALRAINFOREST, ConfigWeightManager.TROPICALRAINFOREST.getWeight(), OverworldBiomeClimate.WARM);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.VIBRANTSWAMPLANDS, ConfigWeightManager.VIBRANTSWAMPLANDS.getWeight(), OverworldBiomeClimate.WARM);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.SIERRAVALLEY, ConfigWeightManager.SIERRAVALLEY.getWeight(), OverworldBiomeClimate.DESERT);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.WEEPINGWITCHFOREST, ConfigWeightManager.WEEPING_WITCH_FOREST.getWeight(), OverworldBiomeClimate.COOL);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.WOODLANDS, ConfigWeightManager.WOODLANDS.getWeight(), OverworldBiomeClimate.WARM);
        BYGBiomeWeightSystem.addBiomeEntry(BYGBiomeList.ZELKOVAFOREST, ConfigWeightManager.ZELKOVAFOREST.getWeight(), OverworldBiomeClimate.COOL);
        BYG.LOGGER.debug("BYG: Added biome entries with their respective weights!");
    }

    public static void addBiomeEntry(Biome biome, int weight, OverworldBiomeClimate type) {
        if (weight > 0) {
            if (type == OverworldBiomeClimate.WARM) {
                WARM.add(WorldGenRegistries.field_243657_i.func_148757_b((Object)biome));
            }
            if (type == OverworldBiomeClimate.COOL) {
                COOL.add(WorldGenRegistries.field_243657_i.func_148757_b((Object)biome));
            }
            if (type == OverworldBiomeClimate.DESERT) {
                HOT.add(WorldGenRegistries.field_243657_i.func_148757_b((Object)biome));
            }
            if (type == OverworldBiomeClimate.ICY) {
                ICY.add(WorldGenRegistries.field_243657_i.func_148757_b((Object)biome));
            }
        }
    }

    public static void addBYGBiomesToVanillaOverworld() {
        for (int integer : HOT) {
            BiomeLayer.field_202744_r = BYGBiomeWeightSystem.addElement(BiomeLayer.field_202744_r, integer);
        }
        for (int integer : WARM) {
            BiomeLayer.field_202745_s = BYGBiomeWeightSystem.addElement(BiomeLayer.field_202745_s, integer);
        }
        for (int integer : COOL) {
            BiomeLayer.field_202746_t = BYGBiomeWeightSystem.addElement(BiomeLayer.field_202746_t, integer);
        }
        for (int integer : ICY) {
            BiomeLayer.field_202747_u = BYGBiomeWeightSystem.addElement(BiomeLayer.field_202747_u, integer);
        }
    }

    static int[] addElement(int[] a, int e) {
        a = Arrays.copyOf(a, a.length + 1);
        a[a.length - 1] = e;
        return a;
    }

    public static enum OverworldBiomeClimate {
        ICY,
        COOL,
        WARM,
        DESERT;

    }
}

