/*
 * Decompiled with CFR 0.152.
 */
package net.quetzi.morpheus.world;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.quetzi.morpheus.helpers.Config;

public class WorldSleepState {
    private RegistryKey<World> dimension;
    private HashMap<String, Boolean> playerStatus;

    public WorldSleepState(RegistryKey<World> dimension) {
        this.dimension = dimension;
        this.playerStatus = new HashMap();
    }

    public int getPercentSleeping() {
        return this.playerStatus.size() - this.getMiningPlayers() - this.getSpectators() > 0 ? (this.getSleepingPlayers() > 0 ? this.getSleepingPlayers() * 100 / (this.playerStatus.size() - this.getMiningPlayers() - this.getSpectators()) : 0) : 100;
    }

    public int getPlayerCount() {
        return this.playerStatus.size();
    }

    public void resetPlayers() {
        this.playerStatus.clear();
    }

    private int getMiningPlayers() {
        int miningPlayers = 0;
        for (PlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
            if (player.func_130014_f_().func_234923_W_() != this.dimension || !(player.func_226278_cu_() < (double)((Integer)Config.SERVER.groundLevel.get()).intValue())) continue;
            ++miningPlayers;
        }
        return (Boolean)Config.SERVER.includeMiners.get() != false ? miningPlayers : 0;
    }

    private int getSpectators() {
        int spectators = 0;
        for (PlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
            if (!player.func_175149_v() && !player.func_184812_l_()) continue;
            ++spectators;
        }
        return spectators;
    }

    public int getSleepingPlayers() {
        int asleepCount = 0;
        for (Map.Entry<String, Boolean> entry : this.playerStatus.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            ++asleepCount;
        }
        return asleepCount;
    }

    public String toString() {
        return (Boolean)Config.SERVER.includeMiners.get() == false ? this.getSleepingPlayers() + "/" + this.playerStatus.size() + " (" + this.getPercentSleeping() + "%)" : this.getSleepingPlayers() + "/" + this.playerStatus.size() + " - " + this.getMiningPlayers() + " miners (" + this.getPercentSleeping() + "%)";
    }

    public void setPlayerAsleep(String username) {
        this.playerStatus.put(username, true);
    }

    public void setPlayerAwake(String username) {
        this.playerStatus.put(username, false);
    }

    public boolean isPlayerSleeping(String username) {
        if (this.playerStatus.containsKey(username)) {
            return this.playerStatus.get(username);
        }
        this.playerStatus.put(username, false);
        return false;
    }

    public void removePlayer(String username) {
        this.playerStatus.remove(username);
    }

    public void wakeAllPlayers() {
        for (Map.Entry<String, Boolean> entry : this.playerStatus.entrySet()) {
            entry.setValue(false);
        }
    }
}

