/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.powder_power.util;

import com.kwpugh.powder_power.util.PlayerEquipUtil;
import com.kwpugh.powder_power.util.PowderPowerConfig;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.OreBlock;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.PhantomEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="powder_power", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ForgeEventSubscriber {
    static int miningExp = (Integer)PowderPowerConfig.exp_token_mining_value.get();
    static int killingExp = (Integer)PowderPowerConfig.exp_token_killing_value.get();

    @SubscribeEvent
    public static void onLivingHurtEvent(LivingAttackEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (event.getSource() == DamageSource.field_76379_h && PlayerEquipUtil.isPlayerGotFallProtection(player) && event.isCancelable()) {
                event.setCanceled(true);
            }
            if ((event.getSource() == DamageSource.field_76372_a || event.getSource() == DamageSource.field_76370_b || event.getSource() == DamageSource.field_76371_c) && PlayerEquipUtil.isPlayerGotFireProtection(player) && event.isCancelable()) {
                event.setCanceled(true);
            }
            if (event.getSource() == DamageSource.field_76369_e && PlayerEquipUtil.isPlayerGotWaterBreathing(player) && event.isCancelable()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void breakingBlockSpeed(PlayerEvent.BreakSpeed event) {
        PlayerEntity player = event.getPlayer();
        ItemStack stack = player.func_184614_ca();
        BlockPos pos = event.getPos();
        Block block = event.getState().func_177230_c();
        if (player != null && !(player instanceof FakePlayer) && !player.func_184812_l_() && PlayerEquipUtil.isPlayerGotHasteToken(player)) {
            if (block == Blocks.field_150343_Z) {
                event.setNewSpeed((float)((Integer)PowderPowerConfig.haste_token_break_speed.get() * 8));
            } else {
                event.setNewSpeed((float)((Integer)PowderPowerConfig.haste_token_break_speed.get()).intValue());
            }
        }
    }

    @SubscribeEvent
    public static void onKillingExpDropEvent(LivingExperienceDropEvent event) {
        PlayerEntity player;
        if (event.getAttackingPlayer() instanceof PlayerEntity && event.getEntityLiving() instanceof MobEntity && PlayerEquipUtil.isPlayerGotExpToken(player = event.getAttackingPlayer())) {
            int orgExp = event.getOriginalExperience();
            int newExp = orgExp * killingExp;
            event.setDroppedExperience(newExp);
        }
    }

    @SubscribeEvent
    public static void onMiningExpDropEvent(BlockEvent.BreakEvent event) {
        PlayerEntity player;
        if (event.getState().func_177230_c() instanceof OreBlock && event.getPlayer() instanceof PlayerEntity && PlayerEquipUtil.isPlayerGotExpToken(player = event.getPlayer())) {
            event.setExpToDrop(miningExp);
        }
    }

    @SubscribeEvent
    public static void onLivingSetAttackTarget(LivingSetAttackTargetEvent event) {
        if (event.getTarget() instanceof PlayerEntity && event.getEntityLiving() instanceof MobEntity) {
            PlayerEntity player = (PlayerEntity)event.getTarget();
            MobEntity attacker = (MobEntity)event.getEntityLiving();
            if (PlayerEquipUtil.isPlayerGotUnseenToken(player) && attacker instanceof PhantomEntity) {
                attacker.func_70624_b(null);
            }
            if (PlayerEquipUtil.isPlayerGotUnseenTokenInHand(player)) {
                attacker.func_70624_b(null);
            }
        }
    }
}

