/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.powder_power.items.hammers;

import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;

public class HammerUtil {
    public static final Random random = new Random();

    public static void attemptBreakNeighbors(World world, BlockPos pos, PlayerEntity player, Set<Material> effectiveMaterials) {
        RayTraceResult trace = HammerUtil.calcRayTrace(world, player, RayTraceContext.FluidMode.ANY);
        if (trace.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockTrace = (BlockRayTraceResult)trace;
            Direction face = blockTrace.func_216354_b();
            for (int a = -1; a <= 1; ++a) {
                for (int b = -1; b <= 1; ++b) {
                    if (a == 0 && b == 0) continue;
                    BlockPos target = null;
                    if (face == Direction.UP || face == Direction.DOWN) {
                        target = pos.func_177982_a(a, 0, b);
                    }
                    if (face == Direction.NORTH || face == Direction.SOUTH) {
                        target = pos.func_177982_a(a, b, 0);
                    }
                    if (face == Direction.EAST || face == Direction.WEST) {
                        target = pos.func_177982_a(0, a, b);
                    }
                    HammerUtil.attemptBreak(world, target, player, effectiveMaterials);
                }
            }
        }
    }

    public static void attemptBreak(World world, BlockPos pos, PlayerEntity player, Set<Material> effectiveMaterials) {
        BlockState state = world.func_180495_p(pos);
        boolean isEffective = effectiveMaterials.contains(state.func_185904_a());
        boolean isWithinHarvestLevel = player.func_184614_ca().func_150998_b(state);
        boolean witherImmune = BlockTags.field_219755_X.func_230235_a_((Object)state.func_177230_c());
        if (isEffective && !witherImmune && isWithinHarvestLevel) {
            world.func_175655_b(pos, false);
            Block.func_220054_a((BlockState)state, (World)world, (BlockPos)pos, null, (Entity)player, (ItemStack)player.func_184614_ca());
        }
    }

    public static RayTraceResult calcRayTrace(World worldIn, PlayerEntity player, RayTraceContext.FluidMode fluidMode) {
        float f = player.field_70125_A;
        float f1 = player.field_70177_z;
        Vector3d vec3d = player.func_174824_e(1.0f);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e() + 1.0;
        Vector3d vec3d1 = vec3d.func_72441_c((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return worldIn.func_217299_a(new RayTraceContext(vec3d, vec3d1, RayTraceContext.BlockMode.OUTLINE, fluidMode, (Entity)player));
    }
}

