/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.elements;

import com.mojang.blaze3d.matrix.MatrixStack;
import info.u_team.u_team_core.util.GuiUtil;
import java.util.ArrayList;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyStorageWidget
extends Widget {
    public static final ResourceLocation ENERGY_TEXTURE = new ResourceLocation("uteamcore", "textures/gui/energy.png");
    private final LongSupplier capacity;
    private final LongSupplier storage;

    public EnergyStorageWidget(int x, int y, int height, LazyOptional<IEnergyStorage> energyStorage) {
        this(x, y, height, () -> ((Integer)energyStorage.map(IEnergyStorage::getMaxEnergyStored).orElse((Object)0)).intValue(), () -> ((Integer)energyStorage.map(IEnergyStorage::getEnergyStored).orElse((Object)0)).intValue());
    }

    public EnergyStorageWidget(int x, int y, int height, Supplier<IEnergyStorage> energyStorage) {
        this(x, y, height, () -> ((IEnergyStorage)energyStorage.get()).getMaxEnergyStored(), () -> ((IEnergyStorage)energyStorage.get()).getEnergyStored());
    }

    public EnergyStorageWidget(int x, int y, int height, LongSupplier capacity, LongSupplier storage) {
        super(x, y, 14, height < 3 ? 3 : height, ITextComponent.func_244388_a(null));
        this.capacity = capacity;
        this.storage = storage;
    }

    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int yComponent;
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.func_110434_K().func_110577_a(ENERGY_TEXTURE);
        double ratio = (double)this.storage.getAsLong() / (double)this.capacity.getAsLong();
        if (ratio > 1.0) {
            ratio = 1.0;
        }
        int storageOffset = (int)((1.0 - ratio) * (double)(this.field_230689_k_ - 2));
        for (yComponent = 1; yComponent < this.field_230689_k_ - 1; yComponent += 2) {
            EnergyStorageWidget.func_238463_a_((MatrixStack)matrixStack, (int)(this.field_230690_l_ + 1), (int)(this.field_230691_m_ + yComponent), (float)0.0f, (float)0.0f, (int)12, (int)2, (int)16, (int)16);
        }
        for (yComponent = 1 + storageOffset; yComponent < this.field_230689_k_ - 1; ++yComponent) {
            if (yComponent % 2 == 0) {
                EnergyStorageWidget.func_238463_a_((MatrixStack)matrixStack, (int)(this.field_230690_l_ + 1), (int)(this.field_230691_m_ + yComponent), (float)0.0f, (float)3.0f, (int)12, (int)1, (int)16, (int)16);
                continue;
            }
            EnergyStorageWidget.func_238463_a_((MatrixStack)matrixStack, (int)(this.field_230690_l_ + 1), (int)(this.field_230691_m_ + yComponent), (float)0.0f, (float)2.0f, (int)12, (int)1, (int)16, (int)16);
        }
        GuiUtil.drawContainerBorder(matrixStack, this.field_230690_l_, this.field_230691_m_, this.field_230688_j_, this.field_230689_k_);
    }

    public void func_230443_a_(MatrixStack matrixStack, int mouseX, int mouseY) {
        if (this.field_230692_n_) {
            Minecraft minecraft = Minecraft.func_71410_x();
            ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
            list.add(ITextComponent.func_244388_a((String)(this.storage.getAsLong() + " / " + this.capacity.getAsLong() + " FE")));
            minecraft.field_71462_r.func_243308_b(matrixStack, list, mouseX, mouseY);
        }
    }

    public void func_230988_a_(SoundHandler handler) {
    }
}

