/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.cos.impl.network.packet;

import java.util.UUID;
import lain.mods.cos.impl.ModObjects;
import lain.mods.cos.impl.inventory.InventoryCosArmor;
import lain.mods.cos.impl.network.NetworkManager;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketSyncCosArmor
implements NetworkManager.NetworkPacket {
    UUID uuid;
    int slot;
    boolean isSkinArmor;
    ItemStack itemCosArmor;

    public PacketSyncCosArmor() {
    }

    public PacketSyncCosArmor(UUID uuid, InventoryCosArmor inventory, int slot) {
        if (uuid == null) {
            throw new IllegalArgumentException();
        }
        this.uuid = uuid;
        this.slot = slot;
        this.isSkinArmor = inventory.isSkinArmor(slot);
        this.itemCosArmor = inventory.func_70301_a(slot);
    }

    @Override
    public void handlePacketClient(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ModObjects.invMan.getCosArmorInventoryClient(this.uuid).setStackInSlot(this.slot, this.itemCosArmor);
            ModObjects.invMan.getCosArmorInventoryClient(this.uuid).setSkinArmor(this.slot, this.isSkinArmor);
        });
    }

    @Override
    public void handlePacketServer(NetworkEvent.Context context) {
    }

    @Override
    public void readFromBuffer(PacketBuffer buffer) {
        this.uuid = new UUID(buffer.readLong(), buffer.readLong());
        this.slot = buffer.readByte();
        this.isSkinArmor = buffer.readBoolean();
        this.itemCosArmor = buffer.func_150791_c();
    }

    @Override
    public void writeToBuffer(PacketBuffer buffer) {
        buffer.writeLong(this.uuid.getMostSignificantBits());
        buffer.writeLong(this.uuid.getLeastSignificantBits());
        buffer.writeByte(this.slot);
        buffer.writeBoolean(this.isSkinArmor);
        buffer.func_150788_a(this.itemCosArmor);
    }
}

