/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_backpacks.container;

import info.u_team.u_team_core.container.UContainer;
import info.u_team.useful_backpacks.init.UsefulBackpacksContainerTypes;
import info.u_team.useful_backpacks.inventory.BackpackInventory;
import info.u_team.useful_backpacks.type.Backpack;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class BackpackContainer
extends UContainer {
    private final IInventory backpackInventory;
    private final Backpack backpack;
    private final int selectedSlot;

    public static BackpackContainer createClientContainer(int id, PlayerInventory playerInventory, PacketBuffer buffer) {
        Backpack backpack = (Backpack)buffer.func_179257_a(Backpack.class);
        int selectedSlot = buffer.func_150792_a();
        return new BackpackContainer(id, playerInventory, (IInventory)new Inventory(backpack.getInventorySize()), backpack, selectedSlot);
    }

    public BackpackContainer(int id, PlayerInventory playerInventory, IInventory backpackInventory, Backpack backpack, int selectedSlot) {
        super((ContainerType)UsefulBackpacksContainerTypes.BACKPACK.get(), id);
        this.backpackInventory = backpackInventory;
        this.backpack = backpack;
        this.selectedSlot = selectedSlot;
        this.appendBackpackInventory(backpack.getSlotBackpackX(), backpack.getSlotBackpackY());
        this.appendPlayerInventory(playerInventory, backpack.getSlotPlayerX(), backpack.getSlotPlayerY());
    }

    public void appendBackpackInventory(int x, int y) {
        for (int height = 0; height < this.backpack.getInventoryHeight(); ++height) {
            for (int width = 0; width < this.backpack.getInventoryWidth(); ++width) {
                this.func_75146_a(new Slot(this.backpackInventory, width + height * this.backpack.getInventoryWidth(), width * 18 + x, height * 18 + y));
            }
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.backpackInventory instanceof BackpackInventory) {
            ((BackpackInventory)this.backpackInventory).writeItemStack();
        }
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < this.backpack.getInventorySize() ? !this.func_75135_a(itemstack1, this.backpack.getInventorySize(), this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, this.backpack.getInventorySize(), false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickType, PlayerEntity player) {
        Slot tmpSlot = slotId >= 0 && slotId < this.field_75151_b.size() ? (Slot)this.field_75151_b.get(slotId) : null;
        if (tmpSlot != null && tmpSlot.field_75224_c == player.field_71071_by && tmpSlot.getSlotIndex() == this.selectedSlot) {
            return tmpSlot.func_75211_c();
        }
        if (clickType == ClickType.SWAP) {
            ItemStack currentItem;
            ItemStack stack = player.field_71071_by.func_70301_a(dragType);
            ItemStack itemStack = PlayerInventory.func_184435_e((int)this.selectedSlot) ? (ItemStack)player.field_71071_by.field_70462_a.get(this.selectedSlot) : (currentItem = this.selectedSlot == -1 ? (ItemStack)player.field_71071_by.field_184439_c.get(0) : ItemStack.field_190927_a);
            if (!currentItem.func_190926_b() && stack == currentItem) {
                return ItemStack.field_190927_a;
            }
        }
        return super.func_184996_a(slotId, dragType, clickType, player);
    }

    public Backpack getBackpack() {
        return this.backpack;
    }
}

