/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.doubledoors.events;

import com.natamus.collective.functions.WorldFunctions;
import com.natamus.doubledoors.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.StoneButtonBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WoodButtonBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DoorEvent {
    private static List<BlockPos> prevpoweredpos = new ArrayList<BlockPos>();
    private static HashMap<BlockPos, Integer> prevbuttonpos = new HashMap();

    @SubscribeEvent
    public void onNeighbourNotice(BlockEvent.NeighborNotifyEvent e) {
        World world = WorldFunctions.getWorldIfInstanceOfAndNotRemote((IWorld)e.getWorld());
        if (world == null) {
            return;
        }
        BooleanProperty proppowered = BlockStateProperties.field_208194_u;
        BlockPos pos = e.getPos().func_185334_h();
        BlockState state = e.getState();
        Block block = state.func_177230_c();
        if (!(block instanceof PressurePlateBlock)) {
            if (!(block instanceof StoneButtonBlock) && !(block instanceof WoodButtonBlock)) {
                return;
            }
            if (!prevbuttonpos.containsKey(pos)) {
                prevbuttonpos.put(pos, 1);
                return;
            }
            prevbuttonpos.remove(pos);
            if (!((Boolean)state.func_177229_b((Property)proppowered)).booleanValue()) {
                if (!prevpoweredpos.contains(pos)) {
                    return;
                }
                prevpoweredpos.remove(pos);
            }
        } else if (!((Boolean)state.func_177229_b((Property)proppowered)).booleanValue() && !prevpoweredpos.contains(pos)) {
            return;
        }
        boolean playsound = true;
        boolean stateprop = (Boolean)state.func_177229_b((Property)proppowered);
        Iterator blocksaround = BlockPos.func_218287_a((int)(pos.func_177958_n() - 1), (int)pos.func_177956_o(), (int)(pos.func_177952_p() - 1), (int)(pos.func_177958_n() + 1), (int)(pos.func_177956_o() + 1), (int)(pos.func_177952_p() + 1)).iterator();
        BlockPos doorpos = null;
        while (blocksaround.hasNext()) {
            BlockPos npos = ((BlockPos)blocksaround.next()).func_185334_h();
            BlockState ostate = world.func_180495_p(npos);
            if (!Util.isDoorBlock(ostate)) continue;
            doorpos = npos;
            break;
        }
        if (doorpos != null && this.processDoor(world, doorpos, world.func_180495_p(doorpos), stateprop, playsound) && stateprop) {
            prevpoweredpos.add(pos);
        }
    }

    @SubscribeEvent
    public void onDoorClick(PlayerInteractEvent.RightClickBlock e) {
        World world = e.getWorld();
        if (world.field_72995_K && e.getHand().equals((Object)Hand.MAIN_HAND)) {
            return;
        }
        PlayerEntity player = e.getPlayer();
        if (player.func_225608_bj_()) {
            return;
        }
        BlockPos cpos = e.getPos();
        BlockState clickstate = world.func_180495_p(cpos);
        if (!Util.isDoorBlock(clickstate)) {
            return;
        }
        if (clickstate.func_185904_a().equals(Material.field_151573_f)) {
            return;
        }
        if (this.processDoor(world, cpos, clickstate, null, true)) {
            e.setUseBlock(Event.Result.DENY);
            e.setCanceled(true);
        }
    }

    private boolean processDoor(World world, BlockPos pos, BlockState state, Boolean isopen, Boolean playsound) {
        Block block = state.func_177230_c();
        if (block instanceof DoorBlock && ((DoubleBlockHalf)state.func_177229_b((Property)DoorBlock.field_176523_O)).equals((Object)DoubleBlockHalf.UPPER)) {
            pos = pos.func_177977_b().func_185334_h();
            state = world.func_180495_p(pos);
        }
        if (isopen == null) {
            isopen = (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208193_t) == false;
        }
        int yoffset = 0;
        if (!(block instanceof DoorBlock)) {
            yoffset = 1;
        }
        Iterator blocksaround = BlockPos.func_218287_a((int)(pos.func_177958_n() - 1), (int)(pos.func_177956_o() - 1), (int)(pos.func_177952_p() - 1), (int)(pos.func_177958_n() + 1), (int)(pos.func_177956_o() + yoffset), (int)(pos.func_177952_p() + 1)).iterator();
        while (blocksaround.hasNext()) {
            BlockPos bpa = (BlockPos)blocksaround.next();
            if (bpa.equals((Object)pos)) continue;
            BlockState ostate = world.func_180495_p(bpa);
            Block oblock = ostate.func_177230_c();
            if (!Util.isDoorBlock(ostate) || !oblock.getRegistryName().equals((Object)block.getRegistryName())) continue;
            if (oblock instanceof DoorBlock) {
                DoorBlock door = (DoorBlock)oblock;
                if (((DoorHingeSide)state.func_177229_b((Property)DoorBlock.field_176521_M)).equals((Object)ostate.func_177229_b((Property)DoorBlock.field_176521_M))) continue;
                if (playsound.booleanValue()) {
                    door.func_242663_a(world, state, pos, isopen.booleanValue());
                } else {
                    world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)DoorBlock.field_176519_b, (Comparable)isopen), 10);
                }
                world.func_180501_a(bpa, (BlockState)ostate.func_206870_a((Property)DoorBlock.field_176519_b, (Comparable)isopen), 10);
                return true;
            }
            if (oblock instanceof TrapDoorBlock) {
                if (playsound.booleanValue()) {
                    if (isopen.booleanValue()) {
                        int i = ostate.func_185904_a() == Material.field_151573_f ? 1037 : 1007;
                        world.func_217378_a(null, i, pos, 0);
                    } else {
                        int j = ostate.func_185904_a() == Material.field_151573_f ? 1036 : 1013;
                        world.func_217378_a(null, j, pos, 0);
                    }
                }
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208193_t, (Comparable)isopen), 10);
                world.func_180501_a(bpa, (BlockState)ostate.func_206870_a((Property)BlockStateProperties.field_208193_t, (Comparable)isopen), 10);
                return true;
            }
            if (!(oblock instanceof FenceGateBlock)) continue;
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)DoorBlock.field_176519_b, (Comparable)isopen), 10);
            world.func_180501_a(bpa, (BlockState)ostate.func_206870_a((Property)DoorBlock.field_176519_b, (Comparable)isopen), 10);
            return true;
        }
        return false;
    }
}

