/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.multiblock;

import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.util.TriPredicate;
import vazkii.patchouli.api.IStateMatcher;

public class StateMatcher
implements IStateMatcher {
    public static final StateMatcher ANY = StateMatcher.displayOnly(Blocks.field_150350_a.func_176223_P());
    public static final StateMatcher AIR = StateMatcher.fromPredicate(Blocks.field_150350_a.func_176223_P(), (TriPredicate<IBlockReader, BlockPos, BlockState>)((TriPredicate)(w, p, s) -> s.isAir(w, p)));
    private final BlockState displayState;
    private final TriPredicate<IBlockReader, BlockPos, BlockState> statePredicate;

    private StateMatcher(BlockState displayState, TriPredicate<IBlockReader, BlockPos, BlockState> statePredicate) {
        this.displayState = displayState;
        this.statePredicate = statePredicate;
    }

    public static StateMatcher fromPredicate(BlockState display, Predicate<BlockState> predicate) {
        return new StateMatcher(display, (TriPredicate<IBlockReader, BlockPos, BlockState>)((TriPredicate)(world, pos, state) -> predicate.test((BlockState)state)));
    }

    public static StateMatcher fromPredicate(Block display, Predicate<BlockState> predicate) {
        return StateMatcher.fromPredicate(display.func_176223_P(), predicate);
    }

    public static StateMatcher fromPredicate(BlockState display, TriPredicate<IBlockReader, BlockPos, BlockState> predicate) {
        return new StateMatcher(display, predicate);
    }

    public static StateMatcher fromPredicate(Block display, TriPredicate<IBlockReader, BlockPos, BlockState> predicate) {
        return new StateMatcher(display.func_176223_P(), predicate);
    }

    public static StateMatcher fromState(BlockState displayState, boolean strict) {
        return StateMatcher.fromPredicate(displayState, strict ? state -> state == displayState : state -> state.func_177230_c() == displayState.func_177230_c());
    }

    public static StateMatcher fromStateWithFilter(BlockState state, Predicate<Property<?>> filter) {
        return StateMatcher.fromPredicate(state, (BlockState state1) -> {
            if (state.func_177230_c() != state1.func_177230_c()) {
                return false;
            }
            return state1.func_235904_r_().stream().filter(filter).allMatch(property -> state1.func_235901_b_(property) && state.func_235901_b_(property) && Objects.equals(state.func_177229_b(property), state1.func_177229_b(property)));
        });
    }

    public static StateMatcher fromState(BlockState displayState) {
        return StateMatcher.fromState(displayState, true);
    }

    public static StateMatcher fromBlockLoose(Block block) {
        return StateMatcher.fromState(block.func_176223_P(), false);
    }

    public static StateMatcher fromBlockStrict(Block block) {
        return StateMatcher.fromState(block.func_176223_P(), true);
    }

    public static StateMatcher displayOnly(BlockState state) {
        return new StateMatcher(state, (TriPredicate<IBlockReader, BlockPos, BlockState>)((TriPredicate)(w, p, s) -> true));
    }

    public static StateMatcher displayOnly(Block block) {
        return StateMatcher.displayOnly(block.func_176223_P());
    }

    @Override
    public BlockState getDisplayedState(int ticks) {
        return this.displayState;
    }

    @Override
    public TriPredicate<IBlockReader, BlockPos, BlockState> getStatePredicate() {
        return this.statePredicate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StateMatcher that = (StateMatcher)o;
        return this.statePredicate.equals(that.statePredicate);
    }

    public int hashCode() {
        return Objects.hash(this.statePredicate);
    }
}

