/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.text;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.Style;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.text.BookTextParser;
import vazkii.patchouli.client.book.text.Span;
import vazkii.patchouli.common.book.Book;

public class SpanState {
    public final GuiBook gui;
    public final Book book;
    private final Style baseStyle;
    private final Deque<Style> styleStack = new ArrayDeque<Style>();
    public IFormattableTextComponent tooltip = BookTextParser.EMPTY_STRING_COMPONENT;
    public Supplier<Boolean> onClick = null;
    public List<Span> cluster = null;
    public boolean isExternalLink = false;
    public boolean endingExternal = false;
    public int lineBreaks = 0;
    public int spacingLeft = 0;
    public int spacingRight = 0;

    public SpanState(GuiBook gui, Book book, Style baseStyle) {
        this.gui = gui;
        this.book = book;
        this.baseStyle = baseStyle;
        this.styleStack.push(baseStyle);
    }

    public String color(Color color) {
        return this.modifyStyle(s -> s.func_240718_a_(color));
    }

    public String baseColor() {
        return this.color(this.baseStyle.func_240711_a_());
    }

    public String modifyStyle(Function<Style, Style> f) {
        Style top = this.styleStack.pop();
        this.styleStack.push(f.apply(top));
        return "";
    }

    public void pushStyle(Style style) {
        Style top = this.styleStack.peek();
        this.styleStack.push(style.func_240717_a_(top));
    }

    public Style popStyle() {
        Style ret = this.styleStack.pop();
        if (this.styleStack.isEmpty()) {
            throw new IllegalStateException("Underflow in style stack");
        }
        return ret;
    }

    public void reset() {
        this.endingExternal = this.isExternalLink;
        this.styleStack.clear();
        this.styleStack.push(this.baseStyle);
        this.cluster = null;
        this.tooltip = BookTextParser.EMPTY_STRING_COMPONENT;
        this.onClick = null;
        this.isExternalLink = false;
    }

    public Style peekStyle() {
        return this.styleStack.getFirst();
    }
}

